#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/fortranimpl.h"
/* virs.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (a ? *(PetscFortranAddr *)(a) : 0)
#define PetscFromPointer(a) (PetscFortranAddr)(a)
#define PetscRmPointer(a)
#endif

#include "petscsnes.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define snesvigetinactiveset_ SNESVIGETINACTIVESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define snesvigetinactiveset_ snesvigetinactiveset
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define dmsetvi_ DMSETVI
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define dmsetvi_ dmsetvi
#endif
/* Provide declarations for malloc/free if needed for strings */
#include <stdlib.h>


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
PETSC_EXTERN void  snesvigetinactiveset_(SNES snes,IS *inact, int *ierr)
{
CHKFORTRANNULLOBJECT(snes);
PetscBool inact_null = !*(void**) inact ? PETSC_TRUE : PETSC_FALSE;
CHKFORTRANNULLOBJECT(inact);
*ierr = SNESVIGetInactiveSet(
	(SNES)PetscToPointer((snes) ),inact);
// if C routine nullifed the object, we must set to to -2 to indicate null set in Fortran
if (! inact_null && !*(void**) inact) * (void **) inact = (void *)-2;
}
PETSC_EXTERN void  dmsetvi_(DM dm,IS inactive, int *ierr)
{
CHKFORTRANNULLOBJECT(dm);
CHKFORTRANNULLOBJECT(inactive);
*ierr = DMSetVI(
	(DM)PetscToPointer((dm) ),
	(IS)PetscToPointer((inactive) ));
}
#if defined(__cplusplus)
}
#endif
