# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.authorization import AuthorizationManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAuthorizationManagementPermissionsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AuthorizationManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_permissions_list_for_resource_group(self, resource_group):
        response = self.client.permissions.list_for_resource_group(
            resource_group_name=resource_group.name,
            api_version="2022-05-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_permissions_list_for_resource(self, resource_group):
        response = self.client.permissions.list_for_resource(
            resource_group_name=resource_group.name,
            resource_provider_namespace="str",
            parent_resource_path="str",
            resource_type="str",
            resource_name="str",
            api_version="2022-05-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
