# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.iotfirmwaredefense.aio import IoTFirmwareDefenseMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestIoTFirmwareDefenseMgmtFirmwaresOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(IoTFirmwareDefenseMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_firmwares_get(self, resource_group):
        response = await self.client.firmwares.get(
            resource_group_name=resource_group.name,
            workspace_name="str",
            firmware_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_firmwares_create(self, resource_group):
        response = await self.client.firmwares.create(
            resource_group_name=resource_group.name,
            workspace_name="str",
            firmware_id="str",
            resource={
                "id": "str",
                "name": "str",
                "properties": {
                    "description": "str",
                    "fileName": "str",
                    "fileSize": 0,
                    "model": "str",
                    "provisioningState": "str",
                    "status": "str",
                    "statusMessages": [{"errorCode": 0, "message": "str"}],
                    "vendor": "str",
                    "version": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_firmwares_update(self, resource_group):
        response = await self.client.firmwares.update(
            resource_group_name=resource_group.name,
            workspace_name="str",
            firmware_id="str",
            properties={
                "properties": {
                    "description": "str",
                    "fileName": "str",
                    "fileSize": 0,
                    "model": "str",
                    "provisioningState": "str",
                    "status": "str",
                    "statusMessages": [{"errorCode": 0, "message": "str"}],
                    "vendor": "str",
                    "version": "str",
                }
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_firmwares_delete(self, resource_group):
        response = await self.client.firmwares.delete(
            resource_group_name=resource_group.name,
            workspace_name="str",
            firmware_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_firmwares_list_by_workspace(self, resource_group):
        response = self.client.firmwares.list_by_workspace(
            resource_group_name=resource_group.name,
            workspace_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
