# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.resourceconnector.aio import ResourceConnectorMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestResourceConnectorMgmtAppliancesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ResourceConnectorMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_appliances_get(self, resource_group):
        response = await self.client.appliances.get(
            resource_group_name=resource_group.name,
            resource_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_appliances_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.appliances.begin_create_or_update(
                resource_group_name=resource_group.name,
                resource_name="str",
                parameters={
                    "location": "str",
                    "id": "str",
                    "identity": {"principalId": "str", "tenantId": "str", "type": "str"},
                    "name": "str",
                    "properties": {
                        "distro": "str",
                        "events": [
                            {
                                "code": "str",
                                "message": "str",
                                "severity": "str",
                                "status": "str",
                                "timestamp": "2020-02-20 00:00:00",
                                "type": "str",
                            }
                        ],
                        "infrastructureConfig": {"provider": "str"},
                        "networkProfile": {
                            "dnsConfiguration": {"version": "str"},
                            "gatewayConfiguration": {"version": "str"},
                            "proxyConfiguration": {"version": "str"},
                        },
                        "provisioningState": "str",
                        "publicKey": "str",
                        "status": "str",
                        "version": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_appliances_update(self, resource_group):
        response = await self.client.appliances.update(
            resource_group_name=resource_group.name,
            resource_name="str",
            parameters={"tags": {"str": "str"}},
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_appliances_begin_delete(self, resource_group):
        response = await (
            await self.client.appliances.begin_delete(
                resource_group_name=resource_group.name,
                resource_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_appliances_list_by_resource_group(self, resource_group):
        response = self.client.appliances.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_appliances_list_by_subscription(self, resource_group):
        response = self.client.appliances.list_by_subscription()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_appliances_list_cluster_user_credential(self, resource_group):
        response = await self.client.appliances.list_cluster_user_credential(
            resource_group_name=resource_group.name,
            resource_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_appliances_list_keys(self, resource_group):
        response = await self.client.appliances.list_keys(
            resource_group_name=resource_group.name,
            resource_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_appliances_get_upgrade_graph(self, resource_group):
        response = await self.client.appliances.get_upgrade_graph(
            resource_group_name=resource_group.name,
            resource_name="str",
            upgrade_graph="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_appliances_list_operations(self, resource_group):
        response = self.client.appliances.list_operations()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_appliances_get_telemetry_config(self, resource_group):
        response = await self.client.appliances.get_telemetry_config()

        # please add some check logic here by yourself
        # ...
