% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-package.R
\name{ExampleData.TR_OSL}
\alias{ExampleData.TR_OSL}
\title{Example TR-OSL data}
\format{
One \linkS4class{RLum.Data.Curve} dataset imported using the function \link{read_XSYG2R}

\describe{
\code{ExampleData.TR_OSL}: A single \linkS4class{RLum.Data.Curve} object with the TR-OSL data
}
}
\description{
Single TR-OSL curve obtained by Schmidt et al. (2019) for quartz sample BT729
(origin: Trebgast Valley, Germany, quartz, 90-200 µm, unpublished data).
}
\examples{

##(1) curves
data(ExampleData.TR_OSL, envir = environment())
plot_RLum(ExampleData.TR_OSL)

}
\references{
Schmidt, C., Simmank, O., Kreutzer, S., 2019.
Time-Resolved Optically Stimulated Luminescence of Quartz in the Nanosecond Time Domain.
Journal of Luminescence 213, 376-387.
}
\seealso{
\link{fit_OSLLifeTimes}
}
\keyword{datasets}
