# 2024-07-09 Triage Log

More regressions than improvements this week, caused by a combination of fixes,
refactorings, third-party dependency updates and in general the compiler doing
slightly more work.

Triage done by **@kobzol**.
Revision
range: [cf2df68d..a2d58197](https://perf.rust-lang.org/?start=cf2df68d1f5e56803c97d91e2b1a9f1c9923c533&end=a2d58197a766085856504328948c89a33a6a36e8&absolute=false&stat=instructions%3Au)

**Summary**:

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 0.7%  |  [0.2%, 2.5%]  |  53   |
| Regressions ❌ <br /> (secondary)  | 1.0%  |  [0.4%, 1.5%]  |  31   |
|  Improvements ✅ <br /> (primary)  | -0.6% | [-1.2%, -0.2%] |  10   |
| Improvements ✅ <br /> (secondary) | -1.7% | [-2.4%, -1.4%] |   4   |
|         All ❌✅ (primary)          | 0.5%  | [-1.2%, 2.5%]  |  63   |

1 Regression, 2 Improvements, 7 Mixed; 3 of them in rollups
62 artifact comparisons made in total

#### Regressions

Make `can_eq` process obligations (almost)
everywhere [#127172](https://github.com/rust-lang/rust/pull/127172) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=20ae37c18df95f9246c019b04957d23b4164bf7a&end=89aefb9c53090851be903b5a9171a2efdc3fd16f&stat=instructions:u)

|         (instructions:u)          | mean |    range     | count |
|:---------------------------------:|:----:|:------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 0.3% | [0.2%, 0.6%] |  25   |
| Regressions ❌ <br /> (secondary)  | 0.8% | [0.7%, 0.9%] |   7   |
|  Improvements ✅ <br /> (primary)  |  -   |      -       |   0   |
| Improvements ✅ <br /> (secondary) |  -   |      -       |   0   |
|         All ❌✅ (primary)          | 0.3% | [0.2%, 0.6%] |  25   |

- Small regression across several benchmarks.
- Not marking as triaged yet, https://github.com/rust-lang/rust/pull/127473 has been
  opened to investigate a potential performance fix.

#### Improvements

Make jump threading state
sparse [#127036](https://github.com/rust-lang/rust/pull/127036) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1cfd47fe0b78f48a04ac8fce792a406b638da40b&end=2b90614e94cfb400820cfc10fe63b0db74f9e67a&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   |   -   |       -        |   0   |
| Regressions ❌ <br /> (secondary)  |   -   |       -        |   0   |
|  Improvements ✅ <br /> (primary)  | -0.8% | [-1.1%, -0.5%] |   5   |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.4%, -0.4%] |   1   |
|         All ❌✅ (primary)          | -0.8% | [-1.1%, -0.5%] |   5   |

Cache hir_owner_nodes in
ParentHirIterator. [#127421](https://github.com/rust-lang/rust/pull/127421) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=89aefb9c53090851be903b5a9171a2efdc3fd16f&end=b1de36ff34a4fe4ba820f195481a13aee74e1358&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   |   -   |       -        |   0   |
| Regressions ❌ <br /> (secondary)  |   -   |       -        |   0   |
|  Improvements ✅ <br /> (primary)  | -0.3% | [-1.0%, -0.2%] |  16   |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.1%, -0.1%] |   3   |
|         All ❌✅ (primary)          | -0.3% | [-1.0%, -0.2%] |  16   |

#### Mixed

Check alias args for WF even if they have escaping bound
vars [#123737](https://github.com/rust-lang/rust/pull/123737) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=67f0d43890801f50ef2d24cd66de523f89ccb157&end=d163e5e515d470a713f7d6907852904622a85d4e&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 0.5%  |  [0.5%, 0.5%]  |   1   |
| Regressions ❌ <br /> (secondary)  | 0.7%  |  [0.4%, 1.1%]  |   4   |
|  Improvements ✅ <br /> (primary)  | -0.2% | [-0.2%, -0.2%] |   2   |
| Improvements ✅ <br /> (secondary) |   -   |       -        |   0   |
|         All ❌✅ (primary)          | 0.0%  | [-0.2%, 0.5%]  |   3   |

- This change is required for further improvements of the type system, the compiler does a bit more work.
- The regression is limited to one stress test and one cargo benchmark.
- Marked as triaged.

Re-implement a type-size based
limit [#125507](https://github.com/rust-lang/rust/pull/125507) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2db4ff40af2b9f93b6240dbd67ed7f2f34b19776&end=c872a1418a4be3ea84a8d5232238b60d35339ba9&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 1.3%  |  [0.3%, 1.9%]  |   5   |
| Regressions ❌ <br /> (secondary)  | 0.9%  |  [0.9%, 0.9%]  |   1   |
|  Improvements ✅ <br /> (primary)  |   -   |       -        |   0   |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.4%, -0.4%] |   1   |
|         All ❌✅ (primary)          | 1.3%  |  [0.3%, 1.9%]  |   5   |

- This PR re-enabled a type size limit check that was not working for a long time.
- It heavily regressed a stress test that contains very deeply nested types, this regression
  has been resolved in https://github.com/rust-lang/rust/pull/127288.
- It seems like the PR is causing issues for various projects, and it might be reverted, but
  the perf. regression itself has been fixed by https://github.com/rust-lang/rust/pull/127288.
- Marked as triaged.

rustdoc: update to pulldown-cmark
0.11 [#127127](https://github.com/rust-lang/rust/pull/127127) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b45401283fad51849dbb37d78f0b2093a21fb58f&end=66b4f0021bfb11a8c20d084c99a40f4a78ce1d38&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 0.8%  |  [0.2%, 1.8%]  |  16   |
| Regressions ❌ <br /> (secondary)  | 0.5%  |  [0.3%, 0.6%]  |   7   |
|  Improvements ✅ <br /> (primary)  |   -   |       -        |   0   |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] |   1   |
|         All ❌✅ (primary)          | 0.8%  |  [0.2%, 1.8%]  |  16   |

- This PR updated the used version of `pulldown-cmark`, which resolves several bugs in handling doc blocks.
- It caused a small regression in `doc` builds.
- Marked as triaged.

cache type sizes in type-size limit
visitor [#127288](https://github.com/rust-lang/rust/pull/127288) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c4225812973cee4bba952cbf7a421f69871fed0d&end=cc8da78a036dc3c15c35a97651b02af9a6d30c1e&stat=instructions:u)

|         (instructions:u)          |  mean  |      range      | count |
|:---------------------------------:|:------:|:---------------:|:-----:|
|  Regressions ❌ <br /> (primary)   |  0.3%  |  [0.2%, 0.3%]   |   9   |
| Regressions ❌ <br /> (secondary)  |  0.7%  |  [0.6%, 0.8%]   |   3   |
|  Improvements ✅ <br /> (primary)  | -1.3%  | [-1.6%, -0.4%]  |   4   |
| Improvements ✅ <br /> (secondary) | -85.4% | [-99.8%, -1.9%] |   7   |
|         All ❌✅ (primary)          | -0.2%  |  [-1.6%, 0.3%]  |  13   |

- Resolved a perf. regression from https://github.com/rust-lang/rust/pull/125507.

Rollup of 8 pull
requests [#127403](https://github.com/rust-lang/rust/pull/127403) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5c08cc765af9975d4b176f7a377bbf927791e20d&end=51917e2e69702e5752bce6a4f3bfd285d0f4ae39&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 0.2%  |  [0.2%, 0.3%]  |   3   |
| Regressions ❌ <br /> (secondary)  |   -   |       -        |   0   |
|  Improvements ✅ <br /> (primary)  |   -   |       -        |   0   |
| Improvements ✅ <br /> (secondary) | -0.9% | [-1.3%, -0.6%] |   9   |
|         All ❌✅ (primary)          | 0.2%  |  [0.2%, 0.3%]  |   3   |

- Small regression on a single benchmark, but only in incremental unchanged build.
- Improvements outweigh the regressions.
- Marked as triaged.

Rollup of 10 pull
requests [#127476](https://github.com/rust-lang/rust/pull/127476) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9af6fee87de71729efca7dbb61c0931180895424&end=7fdefb804ec300fb605039522a7c0dfc9e7dc366&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 0.5%  |  [0.2%, 1.7%]  |  15   |
| Regressions ❌ <br /> (secondary)  | 0.3%  |  [0.1%, 0.7%]  |   3   |
|  Improvements ✅ <br /> (primary)  |   -   |       -        |   0   |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] |   1   |
|         All ❌✅ (primary)          | 0.5%  |  [0.2%, 1.7%]  |  15   |

- Small regressions on `doc` builds caused by https://github.com/rust-lang/rust/pull/127439.
- This is a necessary refactoring, and the author has deemed the small perf. hit to be worth it.
- Marked as triaged.

Rollup of 5 pull
requests [#127486](https://github.com/rust-lang/rust/pull/127486) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=cfd7cf5a0e497c238dcf9947e2eeec01837beeb4&end=a06e9c83f6bc6b9b69f1b0d9f1ab659f8f03db4d&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 0.4%  |  [0.2%, 0.4%]  |   7   |
| Regressions ❌ <br /> (secondary)  | 0.2%  |  [0.2%, 0.2%]  |   1   |
|  Improvements ✅ <br /> (primary)  | -0.8% | [-0.8%, -0.8%] |   1   |
| Improvements ✅ <br /> (secondary) |   -   |       -        |   0   |
|         All ❌✅ (primary)          | 0.2%  | [-0.8%, 0.4%]  |   8   |

- Unclear which PR has caused the (small) regression.
- Not marking as triaged yet.
