/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "backends/keymapper/standard-actions.h"

namespace Common {

const char *const kStandardActionLeftClick     = "LCLK";
const char *const kStandardActionMiddleClick   = "MCLK";
const char *const kStandardActionRightClick    = "RCLK";
const char *const kStandardActionInteract      = "INTRCT";
const char *const kStandardActionSkip          = "SKIP";
const char *const kStandardActionPause         = "PAUSE";
const char *const kStandardActionMoveUp        = "UP";
const char *const kStandardActionMoveDown      = "DOWN";
const char *const kStandardActionMoveLeft      = "LEFT";
const char *const kStandardActionMoveRight     = "RIGHT";
const char *const kStandardActionOpenMainMenu  = "MENU";
const char *const kStandardActionLoad          = "LOAD";
const char *const kStandardActionSave          = "SAVE";
const char *const kStandardActionOpenSettings  = "OPTS";
const char *const kStandardActionEE            = "EEKY";
const char *const kStandardActionCut           = "CUT";
const char *const kStandardActionCopy          = "COPY";
const char *const kStandardActionPaste         = "PASTE";

} //namespace Common
