#ifndef SYSTEMINFO_H
#define SYSTEMINFO_H

#include "Info/cpu_info.h"
#include "Utils/command_util.h"
#include "Utils/file_util.h"
#include "Utils/format_util.h"

#include "stacer-core_global.h"

// Run command in English language (guarantee same behaviour across languages)
#define LSCPU_COMMAND "LC_ALL=C lscpu"
#define PROC_CPUINFO "/proc/cpuinfo"

class STACERCORESHARED_EXPORT SystemInfo
{
  public:
    SystemInfo();

    QString getHostname() const;
    QString getPlatform() const;
    QString getDistribution() const;
    QString getKernel() const;
    QString getCpuModel() const;
    QString getCpuSpeed() const;
    QString getCpuCore() const;
    QString getUsername() const;

    QFileInfoList getCrashReports() const;
    QFileInfoList getAppLogs() const;
    QFileInfoList getAppCaches() const;

    QStringList getUserList() const;
    QStringList getGroupList() const;

  private slots:
  private:
    QString cpuCore;
    QString cpuModel;
    QString cpuSpeed;
    QString username;
};

#endif // SYSTEMINFO_H
