use progvis:lang:cpp:ptr;
use progvis:lang:cpp:impl;
use core:asm;

// Print a string to the GUI.
void printStr(Str str) {
	progvis:program:output(str);
	// stdOut.write(str);
	// stdOut.flush();
}

// Convert from c-string to a Storm string.
Str toStorm(ConstPtr<Byte> chars) {
	checkPtr(chars.base);

	Bool foundNull = false;
	Nat offset = chars.offset - sPtr.current * 2;
	Nat size = chars.base.readSize * chars.base.readCount;
	StrBuf buf;
	while (offset < size) {
		Byte b = chars.base.markReadByte(offset);
		if (b == 0) {
			foundNull = true;
			break;
		}

		buf << Char(b.nat);

		offset++;
	}

	if (!foundNull)
		throw PtrError("buffer overflow", "Missing 0-byte at the end of the string.");

	buf.toS;
}

Nat cStrLength(ConstPtr<Byte> src) {
	checkPtr(src.base);

	Bool foundNull = false;
	Nat total = 0;
	Nat offset = src.offset - sPtr.current * 2;
	Nat size = src.base.readSize * src.base.readCount;
	while (offset <= size) {
		if (src.base.markReadByte(offset) == 0) {
			foundNull = true;
			break;
		}

		offset++;
		total++;
	}

	if (!foundNull)
		throw PtrError("buffer overflow", "Missing 0-byte at the end of the string.");

	total;
}

// Output functions used by the implementation. They are here to avoid reloading the entire C
// frontend everytime we load a program that uses printf.
class PrintfHelpers {
	void putInt(Int width, Bool zeroPad, Int value) : static {
		StrBuf buf;
		if (width < 0)
			buf << left;
		else
			buf << right;

		buf << core:width(abs(width).nat);
		if (zeroPad)
			buf << core:fill('0');

		buf << value;
		printStr(buf.toS);
	}

	void putChar(Int width, Bool zeroPad, Byte value) : static {
		StrBuf buf;
		if (width < 0)
			buf << left;
		else
			buf << right;

		buf << core:width(abs(width).nat);
		if (zeroPad)
			buf << core:fill('0');

		buf << Char(value.nat);
		printStr(buf.toS);
	}

	void putStr(Int width, ConstPtr<Byte> str) : static {
		Int len = cStrLength(str).int;
		Int pad = max(abs(width) - len, 0);
		Str padStr = " " * pad.nat;

		if (width > 0)
			printStr(padStr);

		printStr(toStorm(str));
		if (width < 0)
			printStr(padStr);
	}
}
