//===-- Implementation of the GPU remquo function -------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#include "src/math/remquo.h"
#include "src/__support/common.h"

#include "declarations.h"
#include "src/__support/macros/config.h"

namespace LIBC_NAMESPACE_DECL {

LLVM_LIBC_FUNCTION(double, remquo, (double x, double y, int *quo)) {
  int tmp;
  double r = __ocml_remquo_f64(x, y, (gpu::Private<int> *)&tmp);
  *quo = tmp;
  return r;
}

} // namespace LIBC_NAMESPACE_DECL
