"""
Appropriate settings to run during development.

When running in development mode, selected.py should point to this file.
"""

from debusine.project.settings import defaults

try:
    from debusine.project.settings.db_postgresql import DATABASES
except (ModuleNotFoundError, PermissionError):
    from debusine.project.settings.db_postgresql_default import DATABASES

__all__ = [
    "ADMINS",
    "CACHES",
    "DATABASES",
    "DEBUG",
    "DEBUSINE_DEBIAN_ARCHIVE_FQDN",
    "DEBUSINE_DEBIAN_ARCHIVE_URL_SCHEME",
    "DEBUSINE_FQDN",
    "DEBUSINE_URL_SCHEME",
    "EMAIL_BACKEND",
    "INSTALLED_APPS",
    "INTERNAL_IPS",
    "MIDDLEWARE",
    "XHR_SIMULATED_DELAY",
]

DEBUG = True

ADMINS = ()

EMAIL_BACKEND = 'django.core.mail.backends.console.EmailBackend'

DEBUSINE_FQDN = "127.0.0.1:8000"
DEBUSINE_URL_SCHEME = "http"
DEBUSINE_DEBIAN_ARCHIVE_FQDN = "127.0.0.1:8001"
DEBUSINE_DEBIAN_ARCHIVE_URL_SCHEME = "http"

CACHES = {
    'default': {'BACKEND': 'django.core.cache.backends.locmem.LocMemCache'}
}

XHR_SIMULATED_DELAY = 0.5

INSTALLED_APPS = defaults.INSTALLED_APPS.copy()
MIDDLEWARE = defaults.MIDDLEWARE.copy()
for optional_app, middleware in (
    ("debug_toolbar", "debug_toolbar.middleware.DebugToolbarMiddleware"),
    ("django_extensions", None),
):
    try:
        __import__(optional_app)
    except ImportError:
        pass
    else:
        INSTALLED_APPS.append(optional_app)
        if middleware:
            MIDDLEWARE.insert(0, middleware)

INTERNAL_IPS = ['127.0.0.1']
