Naumova 2013 metaphase chromatin model (out of date)
====================================================
This is an implementation of the "two-stage" model used by Maxim Imakaev in the Naumova et Al 2013 Science paper on metaphase chromatin.  (Download the supplemental materials section and scroll down to the section: "Two-stage process: linear compaction - axial compression")

### Images
<img src="images/t=0_before_minimizaion.jpg" width=220> <img src="images/rightarrow.svg" height=80>  <img src="images/stage2_interior.jpg" width=220>

--------------------------------------------------------------------------
## WARNING: THIS IS NO LONGER AN UP-TO-DATE METAPHASE CHROMATIN MODEL

This was a very early attempt to imagine a mechanical process that might explain limited structural data available at the time.  Newer models (which are very different) have since been proposed.  The purpose of this example is only to demonstrate one way to model a non-trival active process (the process described in that paper) ...using moltemplate.  It is probably not an accurate model of chromatin.

Furthermore, this is a low resolution model of chromatin.  Each bead is larger than the persistence length of DNA.  Nucleosomes and other DNA-binding proteins are not explicitly included in the model.

Furthermore,  the two-stage model at the end of Naumova et al Science 2013 uses the "30nm-fiber" model, whose details are (somewhat vaguely) described in the supplemental materials section.  The 30-nm fiber model of DNA is a hypothetical model of DNA which has not been observed in most Eukaryotic cells (with a few examples).  This is another reason to avoid this model.

### So please do not use this example as starting point for creating a new DNA model

(I think it would be better to start from scratch.)
--------------------------------------------------------------------------

### Instructions

More detailed instructions on how to build LAMMPS input files and run a short simulation are provided in other README files.

1) To build the files which LAMMPS needs, follow the instructions in:
[README_setup.sh](README_setup.sh)

2) To run LAMMPS with these files, follow these instructions:
[README_run.sh](README_run.sh)


### Why use moltemplate?

Honestly, you don't need to use moltemplate to build this polymer.  It is almost counter-productive to use moltemplate to build this kind of polymer because it is so simple.  (The polymer has only 1 bead per atom. It just makes it more complicated to introduce all these extra files including [monomer.lt](moltemplate_files/monomer.lt), [condensin.lt](moltemplate_files/condensin.lt) and [system.lt](moltemplate_files/system.lt), especially considering that [system.lt](moltemplate_files/system.lt) is a complex file which is generated by a separate script.)

However building the sytem using moltemplate may pay off if you replace each point-like monomer with a multi-atom molecule later on. (Right now, using moltemplate to build this system is sort of overkill.  The other coarse-grained DNA models distributed with moltemplate do a better job showcasing why moltemplate is useful.

### Details

Unlike that study, I did not use "softened" Lennard-Jones potentials
(which allow the chains to pass through each other).

#### 10-nm fiber model

For the 10nm model,
n=128000,
L=200,
U(alpha)=5*(1 - cos(alpha))
bond_length=1.0     (=10nm)
sigma=1.0 (particle radius = 10nm)

#### 30-nm fiber model

"The 30nm-like fiber was modeled by increasing the volume of each monomer and the amount of DNA represented by each monomer by a factor of 4.25, while keeping other parameters the same at the monomer level."

I interpret this to mean that, for the 30nm model,
n=128000/4.25~=30117   (however I rounded up to 32768=2^15)
L=200/4.25~=47         (however I rounded up to 51)
U(alpha)=1.17647*(1 - cos(alpha))    (5/4.25=1.17647)

To increase the volume by a factor o 4.25, I increase both the diameter of each bead (the "sigma" parameter), and the bond-lengths connecting them from 1.0 (corresponding to 10nm) to 4.25^(1/3)~=1.6198 (corresponding to 16.198nm).

*It is also worth mentioning that since this paper was published, more papers have appeared that question the existence of the 30-nm chromatin fiber model in most Eurkaryotes.*
