% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenario.R
\name{checkScenario}
\alias{checkScenario}
\title{Check and correct the given scenario}
\usage{
checkScenario(scenario = defaultScenario())
}
\arguments{
\item{scenario}{\code{list()}\cr Data structure containing \pkg{irace}
settings. The data structure has to be the one returned by the function
\code{\link[=defaultScenario]{defaultScenario()}} or \code{\link[=readScenario]{readScenario()}}.}
}
\value{
The scenario received as a parameter, possibly corrected. Unset
scenario settings are set to their default values.
}
\description{
Checks for errors a (possibly incomplete) scenario setup of
\pkg{irace}  and transforms it into a valid scenario.
}
\details{
This function checks that the directories and the file names
provided and required by the \pkg{irace} exist. It also checks that the
settings are of the proper type, e.g. that settings expected to be integers
are really integers. Finally, it also checks that there is no inconsistency
between settings.  If an error is found that prevents \pkg{irace} from
running properly, it will stop with an error.
}
\seealso{
\describe{
\item{\code{\link[=readScenario]{readScenario()}}}{for reading a configuration scenario from a file.}
\item{\code{\link[=printScenario]{printScenario()}}}{prints the given scenario.}
\item{\code{\link[=defaultScenario]{defaultScenario()}}}{returns the default scenario settings of \pkg{irace}.}
\item{\code{\link[=checkScenario]{checkScenario()}}}{to check that the scenario is valid.}
}
}
\author{
Manuel López-Ibáñez and Jérémie Dubois-Lacoste
}
