% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{vec-set}
\alias{vec-set}
\alias{vec_set_intersect}
\alias{vec_set_difference}
\alias{vec_set_union}
\alias{vec_set_symmetric_difference}
\title{Set operations}
\usage{
vec_set_intersect(
  x,
  y,
  ...,
  ptype = NULL,
  x_arg = "x",
  y_arg = "y",
  error_call = current_env()
)

vec_set_difference(
  x,
  y,
  ...,
  ptype = NULL,
  x_arg = "x",
  y_arg = "y",
  error_call = current_env()
)

vec_set_union(
  x,
  y,
  ...,
  ptype = NULL,
  x_arg = "x",
  y_arg = "y",
  error_call = current_env()
)

vec_set_symmetric_difference(
  x,
  y,
  ...,
  ptype = NULL,
  x_arg = "x",
  y_arg = "y",
  error_call = current_env()
)
}
\arguments{
\item{x, y}{A pair of vectors.}

\item{...}{These dots are for future extensions and must be empty.}

\item{ptype}{If \code{NULL}, the default, the output type is determined by
computing the common type between \code{x} and \code{y}. If supplied, both \code{x} and
\code{y} will be cast to this type.}

\item{x_arg, y_arg}{Argument names for \code{x} and \code{y}. These are used in error
messages.}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
A vector of the common type of \code{x} and \code{y} (or \code{ptype}, if supplied)
containing the result of the corresponding set function.
}
\description{
\itemize{
\item \code{vec_set_intersect()} returns all values in both \code{x} and \code{y}.
\item \code{vec_set_difference()} returns all values in \code{x} but not \code{y}. Note
that this is an asymmetric set difference, meaning it is not commutative.
\item \code{vec_set_union()} returns all values in either \code{x} or \code{y}.
\item \code{vec_set_symmetric_difference()} returns all values in either \code{x} or \code{y}
but not both. This is a commutative difference.
}

Because these are \emph{set} operations, these functions only return unique values
from \code{x} and \code{y}, returned in the order they first appeared in the original
input. Names of \code{x} and \code{y} are retained on the result, but names are always
taken from \code{x} if the value appears in both inputs.

These functions work similarly to \code{\link[base:sets]{base::intersect()}}, \code{\link[base:sets]{base::setdiff()}}, and
\code{\link[base:sets]{base::union()}}, but don't strip attributes and can be used with data frames.
}
\details{
Missing values are treated as equal to other missing values. For doubles and
complexes, \code{NaN} are equal to other \code{NaN}, but not to \code{NA}.
}
\section{Dependencies}{

\subsection{\code{vec_set_intersect()}}{
\itemize{
\item \code{\link[=vec_proxy_equal]{vec_proxy_equal()}}
\item \code{\link[=vec_slice]{vec_slice()}}
\item \code{\link[=vec_ptype2]{vec_ptype2()}}
\item \code{\link[=vec_cast]{vec_cast()}}
}
}

\subsection{\code{vec_set_difference()}}{
\itemize{
\item \code{\link[=vec_proxy_equal]{vec_proxy_equal()}}
\item \code{\link[=vec_slice]{vec_slice()}}
\item \code{\link[=vec_ptype2]{vec_ptype2()}}
\item \code{\link[=vec_cast]{vec_cast()}}
}
}

\subsection{\code{vec_set_union()}}{
\itemize{
\item \code{\link[=vec_proxy_equal]{vec_proxy_equal()}}
\item \code{\link[=vec_slice]{vec_slice()}}
\item \code{\link[=vec_ptype2]{vec_ptype2()}}
\item \code{\link[=vec_cast]{vec_cast()}}
\item \code{\link[=vec_c]{vec_c()}}
}
}

\subsection{\code{vec_set_symmetric_difference()}}{
\itemize{
\item \code{\link[=vec_proxy_equal]{vec_proxy_equal()}}
\item \code{\link[=vec_slice]{vec_slice()}}
\item \code{\link[=vec_ptype2]{vec_ptype2()}}
\item \code{\link[=vec_cast]{vec_cast()}}
\item \code{\link[=vec_c]{vec_c()}}
}
}
}

\examples{
x <- c(1, 2, 1, 4, 3)
y <- c(2, 5, 5, 1)

# All unique values in both `x` and `y`.
# Duplicates in `x` and `y` are always removed.
vec_set_intersect(x, y)

# All unique values in `x` but not `y`
vec_set_difference(x, y)

# All unique values in either `x` or `y`
vec_set_union(x, y)

# All unique values in either `x` or `y` but not both
vec_set_symmetric_difference(x, y)

# These functions can also be used with data frames
x <- data_frame(
  a = c(2, 3, 2, 2),
  b = c("j", "k", "j", "l")
)
y <- data_frame(
  a = c(1, 2, 2, 2, 3),
  b = c("j", "l", "j", "l", "j")
)

vec_set_intersect(x, y)
vec_set_difference(x, y)
vec_set_union(x, y)
vec_set_symmetric_difference(x, y)

# Vector names don't affect set membership, but if you'd like to force
# them to, you can transform the vector into a two column data frame
x <- c(a = 1, b = 2, c = 2, d = 3)
y <- c(c = 2, b = 1, a = 3, d = 3)

vec_set_intersect(x, y)

x <- data_frame(name = names(x), value = unname(x))
y <- data_frame(name = names(y), value = unname(y))

vec_set_intersect(x, y)
}
