// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Log.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.logging {

  public class LogEntry : ICloneable {
    public object Clone() {
      LogEntry copy = new LogEntry();
      copy.id = this.id;
      copy.timestamp = this.timestamp;
      copy.eventClass = this.eventClass;
      copy.message = this.message;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["id"] = this.id;
      json["timestamp"] = (this.timestamp.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
      json["eventClass"] = this.eventClass;
      json["message"] = this.message;
      return json;
    }

    public static LogEntry Decode(LightJson.JsonObject json, Agent agent) {
      LogEntry inst = new LogEntry();
      inst.id = (int)json["id"];
      inst.timestamp = new System.DateTime(json["timestamp"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
      inst.eventClass = (string)json["eventClass"];
      inst.message = (string)json["message"];
      return inst;
    }

    public int id = 0;
    public System.DateTime timestamp = new System.DateTime(0);
    public string eventClass = "";
    public string message = "";
  }
}
