// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from KeypadManager.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.smartlock {
  public class KeypadManager : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("smartlock.KeypadManager:1.0.0", null);

    public KeypadManager(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public KeypadManager(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new KeypadManager StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new KeypadManager(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public class KeypadSettings : ICloneable {
      public object Clone() {
        KeypadSettings copy = new KeypadSettings();
        copy.name = this.name;
        copy.description = this.description;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["name"] = this.name;
        json["description"] = this.description;
        return json;
      }

      public static KeypadSettings Decode(LightJson.JsonObject json, Agent agent) {
        KeypadSettings inst = new KeypadSettings();
        inst.name = (string)json["name"];
        inst.description = (string)json["description"];
        return inst;
      }

      public string name = "";
      public string description = "";
    }

    public class KeypadEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("smartlock.KeypadManager.KeypadEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public Com.Raritan.Idl.smartlock.Keypad keypad = null;
    }

    public class KeypadAttachedEvent : Com.Raritan.Idl.smartlock.KeypadManager.KeypadEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("smartlock.KeypadManager.KeypadAttachedEvent:1.0.0", Com.Raritan.Idl.smartlock.KeypadManager.KeypadEvent.typeInfo);

    }

    public class KeypadDetachedEvent : Com.Raritan.Idl.smartlock.KeypadManager.KeypadEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("smartlock.KeypadManager.KeypadDetachedEvent:1.0.0", Com.Raritan.Idl.smartlock.KeypadManager.KeypadEvent.typeInfo);

    }

    public class KeypadSettingsChangedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("smartlock.KeypadManager.KeypadSettingsChangedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public Com.Raritan.Idl.smartlock.KeypadManager.KeypadSettings oldSettings = new Com.Raritan.Idl.smartlock.KeypadManager.KeypadSettings();
      public Com.Raritan.Idl.smartlock.KeypadManager.KeypadSettings newSettings = new Com.Raritan.Idl.smartlock.KeypadManager.KeypadSettings();
      public string position = "";
    }

    public class GetKeypadsResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.smartlock.Keypad> _ret_;
    }

    public GetKeypadsResult getKeypads() {
      JsonObject _parameters = null;
      var _result = RpcCall("getKeypads", _parameters);
      var _ret = new GetKeypadsResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.smartlock.Keypad>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.smartlock.Keypad.StaticCast(ObjectProxy.Decode(_value, agent))));
      return _ret;
    }

    public AsyncRequest getKeypads(AsyncRpcResponse<GetKeypadsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getKeypads(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getKeypads(AsyncRpcResponse<GetKeypadsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getKeypads", _parameters,
        _result => {
          try {
            var _ret = new GetKeypadsResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.smartlock.Keypad>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.smartlock.Keypad.StaticCast(ObjectProxy.Decode(_value, agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetKeypadByIdResult {
      public Com.Raritan.Idl.smartlock.Keypad _ret_;
    }

    public GetKeypadByIdResult getKeypadById(string keypadId) {
      var _parameters = new LightJson.JsonObject();
      _parameters["keypadId"] = keypadId;

      var _result = RpcCall("getKeypadById", _parameters);
      var _ret = new GetKeypadByIdResult();
      _ret._ret_ = Com.Raritan.Idl.smartlock.Keypad.StaticCast(ObjectProxy.Decode(_result["_ret_"], agent));
      return _ret;
    }

    public AsyncRequest getKeypadById(string keypadId, AsyncRpcResponse<GetKeypadByIdResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getKeypadById(keypadId, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getKeypadById(string keypadId, AsyncRpcResponse<GetKeypadByIdResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["keypadId"] = keypadId;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getKeypadById", _parameters,
        _result => {
          try {
            var _ret = new GetKeypadByIdResult();
            _ret._ret_ = Com.Raritan.Idl.smartlock.Keypad.StaticCast(ObjectProxy.Decode(_result["_ret_"], agent));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetKeypadSettingsResult {
      public int _ret_;
    }

    public SetKeypadSettingsResult setKeypadSettings(string position, Com.Raritan.Idl.smartlock.KeypadManager.KeypadSettings setting) {
      var _parameters = new LightJson.JsonObject();
      _parameters["position"] = position;
      _parameters["setting"] = setting.Encode();

      var _result = RpcCall("setKeypadSettings", _parameters);
      var _ret = new SetKeypadSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setKeypadSettings(string position, Com.Raritan.Idl.smartlock.KeypadManager.KeypadSettings setting, AsyncRpcResponse<SetKeypadSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setKeypadSettings(position, setting, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setKeypadSettings(string position, Com.Raritan.Idl.smartlock.KeypadManager.KeypadSettings setting, AsyncRpcResponse<SetKeypadSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["position"] = position;
        _parameters["setting"] = setting.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setKeypadSettings", _parameters,
        _result => {
          try {
            var _ret = new SetKeypadSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetAllKeypadSettingsResult {
      public System.Collections.Generic.IDictionary<string, Com.Raritan.Idl.smartlock.KeypadManager.KeypadSettings> _ret_;
    }

    public GetAllKeypadSettingsResult getAllKeypadSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getAllKeypadSettings", _parameters);
      var _ret = new GetAllKeypadSettingsResult();
      _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
        _value => new System.Collections.Generic.KeyValuePair<string, Com.Raritan.Idl.smartlock.KeypadManager.KeypadSettings>(_value["key"], Com.Raritan.Idl.smartlock.KeypadManager.KeypadSettings.Decode(_value["value"], agent))));
      return _ret;
    }

    public AsyncRequest getAllKeypadSettings(AsyncRpcResponse<GetAllKeypadSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getAllKeypadSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getAllKeypadSettings(AsyncRpcResponse<GetAllKeypadSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getAllKeypadSettings", _parameters,
        _result => {
          try {
            var _ret = new GetAllKeypadSettingsResult();
            _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
              _value => new System.Collections.Generic.KeyValuePair<string, Com.Raritan.Idl.smartlock.KeypadManager.KeypadSettings>(_value["key"], Com.Raritan.Idl.smartlock.KeypadManager.KeypadSettings.Decode(_value["value"], agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
