# Contributing
The SPDX License List is maintained by the [SPDX legal team](https://spdx.dev/engage/participate/legal-team/). This repo is used for the submission and review of licenses, as well as maintaining [documentation](DOCS) related to the SPDX License List. Suggestions with a larger scope, cross-functional issues, and questions should be directed to the [SPDX-legal mailing list](https://lists.spdx.org/g/Spdx-legal). 

## Submitting a license for consideration
To submit a license for consideration for the SPDX License List, follow the process for [requesting a new license](DOCS/request-new-license.md). Please be sure to review the relevant documentation prior to your submission, notably, the [license inclusion principles](DOCS/license-inclusion-principles.md). Each license submission requires review and incomplete or inappropriate submissions only take away the precious time of a small number of volunteers from other tasks.

## Minor updates
Minor changes such as markup and typo fixes may be submitted directly to this repository (either as issues or pull-requests) without previous discussion. 
If you find a broken URL for a license, you may make a pull request to add the new URL, but please note our policy to [retain old URLs](DOCS/license-fields.md), which can be helpful for matching. 

## Improvements to documentation
Newcomers have a great perspective as to the effectiveness of documentation! You can make suggestions via an issue, if you want to discuss the changes. If there is something needs updating, a typo, or other minor improvements, feel free to go ahead and create a PR!

## Reviewing submitted licenses
Once you have familiarized yourself with the [License inclusion principles](DOCS/license-inclusion-principles.md), comment on new license requests as to whether you think the license meets the License Inclusion Principles and therefore should be included on the SPDX License List, in any issue labeled ["new license/exception request"](https://github.com/spdx/license-list-XML/issues?q=is%3Aopen+is%3Aissue+label%3A%22new+license%2Fexception+request%22+-label%3A%22new+license%2Fexception%3A+Accepted%22).

## Major changes
Examples of a major change include: a change to policies (such as the license includiont principles); additional fields; additional functionality. It is recommended to raise a major change on the mailing list first, which may also lead to a scheduled discussion on an upcoming call. Some changes may warrant use of the [Change Proposal](https://github.com/spdx/change-proposal) process. 

## Questions about the SPDX License List
Please use the [mailing list](https://lists.spdx.org/g/spdx-legal) for questions about the SPDX License List or to let us know about how you are using it!


