/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/


#ifndef INTERACTIVEGEOMETRYVIEWER_H
#define INTERACTIVEGEOMETRYVIEWER_H

#include "InteractiveGeometryViewerAPI.h"

// -- Core stuff
#include <InteractiveViewer.h>

/**
  * @ingroup group_sdk_libraries_core_interactivegeometryviewer
  *
  * @brief Interactive 3D viewer
  *
  * InteractiveGeometryViewer is a the general purpose InteractiveViewer subclass dedicated to manage
  * 3D visualization and interaction.
  *
  * It manages the camitk::InterfaceGeometry and camitk::InterfaceBitMap facet of components.
  *
  * All the logic is done by InteractiveViewer.
  *
  * If this viewer extension is loaded, the default instance of this viewer can be accessed directly
  * by Application::getViewer("3D Viewer").
  *
  * @see camitk::InteractiveViewer
  * @see camitk::InterfaceGeometry
  * @see camitk::InterfaceBitMap
  * @see camitk::Viewer
  *
  */
class INTERACTIVEGEOMETRYVIEWER_API InteractiveGeometryViewer : public camitk::InteractiveViewer {
    Q_OBJECT

public:

    Q_INVOKABLE InteractiveGeometryViewer(QString name);

    /** destructor */
    virtual ~InteractiveGeometryViewer() override = default;

};


#endif // INTERACTIVEGEOMETRYVIEWER_H

