/*************************************************************************
**
**    This file is part of the 'forwords' educational programm.
**    Copyright (C) 2024  Alexander Fomin
**
**    This program is free software: you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation, either version 3 of the License, or
**    (at your option) any later version.
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program.  If not, see <https://www.gnu.org/licenses/>.
**
**    Contact: fomin_alex@yahoo.com
**
**************************************************************************/

#ifndef TTS_H
#define TTS_H

#include <QStringList>
#include <QFile>
#include <QLibrary>
#include <espeak-ng/speak_lib.h>

class tts
{
public:
    tts();
    const QStringList *getVoiceList();
    bool        setVoice(QString voice);
    void        speakOut(QString text);
    const QStringList *getEngines();
    bool        setEngine(QString engine);
    void        SpeachCancel();

private:

    typedef int (*ttsInit)(espeak_AUDIO_OUTPUT, int, const char*, int);
    typedef const espeak_VOICE** (*ListVoices)(espeak_VOICE*);
    typedef espeak_ERROR (*SetVoiceByName)(const char*);
    typedef espeak_ERROR (*Synth)(const void*, size_t, unsigned int, espeak_POSITION_TYPE,
                                  unsigned int, unsigned int, unsigned int*, void*);
    typedef espeak_ERROR (*espeak_Cancel)(void);

    ttsInit         fTTSinit;
    ListVoices      fListVoices;
    SetVoiceByName  fSetVoice;
    Synth           fSynth;
    espeak_Cancel   fEspeakCancel;
    QByteArray  vSpeechBuffer;
    QStringList *lEngines;
    QStringList *lVoices;
    QLibrary    lib;
    QString     vCurrentEngine;
};

#endif // TTS_H
