//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armapimanagement

// APIClientBeginCreateOrUpdateOptions contains the optional parameters for the APIClient.BeginCreateOrUpdate method.
type APIClientBeginCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string

	// Resumes the LRO from the provided token.
	ResumeToken string
}

// APIClientDeleteOptions contains the optional parameters for the APIClient.Delete method.
type APIClientDeleteOptions struct {
	// Delete all revisions of the Api.
	DeleteRevisions *bool
}

// APIClientGetEntityTagOptions contains the optional parameters for the APIClient.GetEntityTag method.
type APIClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APIClientGetOptions contains the optional parameters for the APIClient.Get method.
type APIClientGetOptions struct {
	// placeholder for future optional parameters
}

// APIClientListByServiceOptions contains the optional parameters for the APIClient.NewListByServicePager method.
type APIClientListByServiceOptions struct {
	// Include full ApiVersionSet resource in response
	ExpandAPIVersionSet *bool

	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | serviceUrl | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | path | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | isCurrent | filter | eq, ne | |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Include tags in the response.
	Tags *string

	// Number of records to return.
	Top *int32
}

// APIClientListByTagsOptions contains the optional parameters for the APIClient.NewListByTagsPager method.
type APIClientListByTagsOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | apiRevision | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | path | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | serviceUrl | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | isCurrent | filter | eq | |
	Filter *string

	// Include not tagged APIs.
	IncludeNotTaggedApis *bool

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// APIClientUpdateOptions contains the optional parameters for the APIClient.Update method.
type APIClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// APIDiagnosticClientCreateOrUpdateOptions contains the optional parameters for the APIDiagnosticClient.CreateOrUpdate method.
type APIDiagnosticClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// APIDiagnosticClientDeleteOptions contains the optional parameters for the APIDiagnosticClient.Delete method.
type APIDiagnosticClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// APIDiagnosticClientGetEntityTagOptions contains the optional parameters for the APIDiagnosticClient.GetEntityTag method.
type APIDiagnosticClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APIDiagnosticClientGetOptions contains the optional parameters for the APIDiagnosticClient.Get method.
type APIDiagnosticClientGetOptions struct {
	// placeholder for future optional parameters
}

// APIDiagnosticClientListByServiceOptions contains the optional parameters for the APIDiagnosticClient.NewListByServicePager
// method.
type APIDiagnosticClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// APIDiagnosticClientUpdateOptions contains the optional parameters for the APIDiagnosticClient.Update method.
type APIDiagnosticClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// APIExportClientGetOptions contains the optional parameters for the APIExportClient.Get method.
type APIExportClientGetOptions struct {
	// placeholder for future optional parameters
}

// APIIssueAttachmentClientCreateOrUpdateOptions contains the optional parameters for the APIIssueAttachmentClient.CreateOrUpdate
// method.
type APIIssueAttachmentClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// APIIssueAttachmentClientDeleteOptions contains the optional parameters for the APIIssueAttachmentClient.Delete method.
type APIIssueAttachmentClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// APIIssueAttachmentClientGetEntityTagOptions contains the optional parameters for the APIIssueAttachmentClient.GetEntityTag
// method.
type APIIssueAttachmentClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APIIssueAttachmentClientGetOptions contains the optional parameters for the APIIssueAttachmentClient.Get method.
type APIIssueAttachmentClientGetOptions struct {
	// placeholder for future optional parameters
}

// APIIssueAttachmentClientListByServiceOptions contains the optional parameters for the APIIssueAttachmentClient.NewListByServicePager
// method.
type APIIssueAttachmentClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | userId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// APIIssueClientCreateOrUpdateOptions contains the optional parameters for the APIIssueClient.CreateOrUpdate method.
type APIIssueClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// APIIssueClientDeleteOptions contains the optional parameters for the APIIssueClient.Delete method.
type APIIssueClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// APIIssueClientGetEntityTagOptions contains the optional parameters for the APIIssueClient.GetEntityTag method.
type APIIssueClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APIIssueClientGetOptions contains the optional parameters for the APIIssueClient.Get method.
type APIIssueClientGetOptions struct {
	// Expand the comment attachments.
	ExpandCommentsAttachments *bool
}

// APIIssueClientListByServiceOptions contains the optional parameters for the APIIssueClient.NewListByServicePager method.
type APIIssueClientListByServiceOptions struct {
	// Expand the comment attachments.
	ExpandCommentsAttachments *bool

	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | userId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | state | filter | eq | |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// APIIssueClientUpdateOptions contains the optional parameters for the APIIssueClient.Update method.
type APIIssueClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// APIIssueCommentClientCreateOrUpdateOptions contains the optional parameters for the APIIssueCommentClient.CreateOrUpdate
// method.
type APIIssueCommentClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// APIIssueCommentClientDeleteOptions contains the optional parameters for the APIIssueCommentClient.Delete method.
type APIIssueCommentClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// APIIssueCommentClientGetEntityTagOptions contains the optional parameters for the APIIssueCommentClient.GetEntityTag method.
type APIIssueCommentClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APIIssueCommentClientGetOptions contains the optional parameters for the APIIssueCommentClient.Get method.
type APIIssueCommentClientGetOptions struct {
	// placeholder for future optional parameters
}

// APIIssueCommentClientListByServiceOptions contains the optional parameters for the APIIssueCommentClient.NewListByServicePager
// method.
type APIIssueCommentClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | userId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// APIOperationClientCreateOrUpdateOptions contains the optional parameters for the APIOperationClient.CreateOrUpdate method.
type APIOperationClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// APIOperationClientDeleteOptions contains the optional parameters for the APIOperationClient.Delete method.
type APIOperationClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// APIOperationClientGetEntityTagOptions contains the optional parameters for the APIOperationClient.GetEntityTag method.
type APIOperationClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APIOperationClientGetOptions contains the optional parameters for the APIOperationClient.Get method.
type APIOperationClientGetOptions struct {
	// placeholder for future optional parameters
}

// APIOperationClientListByAPIOptions contains the optional parameters for the APIOperationClient.NewListByAPIPager method.
type APIOperationClientListByAPIOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | method | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | urlTemplate | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Include tags in the response.
	Tags *string

	// Number of records to return.
	Top *int32
}

// APIOperationClientUpdateOptions contains the optional parameters for the APIOperationClient.Update method.
type APIOperationClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// APIOperationPolicyClientCreateOrUpdateOptions contains the optional parameters for the APIOperationPolicyClient.CreateOrUpdate
// method.
type APIOperationPolicyClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// APIOperationPolicyClientDeleteOptions contains the optional parameters for the APIOperationPolicyClient.Delete method.
type APIOperationPolicyClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// APIOperationPolicyClientGetEntityTagOptions contains the optional parameters for the APIOperationPolicyClient.GetEntityTag
// method.
type APIOperationPolicyClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APIOperationPolicyClientGetOptions contains the optional parameters for the APIOperationPolicyClient.Get method.
type APIOperationPolicyClientGetOptions struct {
	// Policy Export Format.
	Format *PolicyExportFormat
}

// APIOperationPolicyClientListByOperationOptions contains the optional parameters for the APIOperationPolicyClient.ListByOperation
// method.
type APIOperationPolicyClientListByOperationOptions struct {
	// placeholder for future optional parameters
}

// APIPolicyClientCreateOrUpdateOptions contains the optional parameters for the APIPolicyClient.CreateOrUpdate method.
type APIPolicyClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// APIPolicyClientDeleteOptions contains the optional parameters for the APIPolicyClient.Delete method.
type APIPolicyClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// APIPolicyClientGetEntityTagOptions contains the optional parameters for the APIPolicyClient.GetEntityTag method.
type APIPolicyClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APIPolicyClientGetOptions contains the optional parameters for the APIPolicyClient.Get method.
type APIPolicyClientGetOptions struct {
	// Policy Export Format.
	Format *PolicyExportFormat
}

// APIPolicyClientListByAPIOptions contains the optional parameters for the APIPolicyClient.ListByAPI method.
type APIPolicyClientListByAPIOptions struct {
	// placeholder for future optional parameters
}

// APIProductClientListByApisOptions contains the optional parameters for the APIProductClient.NewListByApisPager method.
type APIProductClientListByApisOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// APIReleaseClientCreateOrUpdateOptions contains the optional parameters for the APIReleaseClient.CreateOrUpdate method.
type APIReleaseClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// APIReleaseClientDeleteOptions contains the optional parameters for the APIReleaseClient.Delete method.
type APIReleaseClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// APIReleaseClientGetEntityTagOptions contains the optional parameters for the APIReleaseClient.GetEntityTag method.
type APIReleaseClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APIReleaseClientGetOptions contains the optional parameters for the APIReleaseClient.Get method.
type APIReleaseClientGetOptions struct {
	// placeholder for future optional parameters
}

// APIReleaseClientListByServiceOptions contains the optional parameters for the APIReleaseClient.NewListByServicePager method.
type APIReleaseClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | notes | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// APIReleaseClientUpdateOptions contains the optional parameters for the APIReleaseClient.Update method.
type APIReleaseClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// APIRevisionClientListByServiceOptions contains the optional parameters for the APIRevisionClient.NewListByServicePager
// method.
type APIRevisionClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | apiRevision | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// APISchemaClientBeginCreateOrUpdateOptions contains the optional parameters for the APISchemaClient.BeginCreateOrUpdate
// method.
type APISchemaClientBeginCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string

	// Resumes the LRO from the provided token.
	ResumeToken string
}

// APISchemaClientDeleteOptions contains the optional parameters for the APISchemaClient.Delete method.
type APISchemaClientDeleteOptions struct {
	// If true removes all references to the schema before deleting it.
	Force *bool
}

// APISchemaClientGetEntityTagOptions contains the optional parameters for the APISchemaClient.GetEntityTag method.
type APISchemaClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APISchemaClientGetOptions contains the optional parameters for the APISchemaClient.Get method.
type APISchemaClientGetOptions struct {
	// placeholder for future optional parameters
}

// APISchemaClientListByAPIOptions contains the optional parameters for the APISchemaClient.NewListByAPIPager method.
type APISchemaClientListByAPIOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | contentType | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// APITagDescriptionClientCreateOrUpdateOptions contains the optional parameters for the APITagDescriptionClient.CreateOrUpdate
// method.
type APITagDescriptionClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// APITagDescriptionClientDeleteOptions contains the optional parameters for the APITagDescriptionClient.Delete method.
type APITagDescriptionClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// APITagDescriptionClientGetEntityTagOptions contains the optional parameters for the APITagDescriptionClient.GetEntityTag
// method.
type APITagDescriptionClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APITagDescriptionClientGetOptions contains the optional parameters for the APITagDescriptionClient.Get method.
type APITagDescriptionClientGetOptions struct {
	// placeholder for future optional parameters
}

// APITagDescriptionClientListByServiceOptions contains the optional parameters for the APITagDescriptionClient.NewListByServicePager
// method.
type APITagDescriptionClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// APIVersionSetClientCreateOrUpdateOptions contains the optional parameters for the APIVersionSetClient.CreateOrUpdate method.
type APIVersionSetClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// APIVersionSetClientDeleteOptions contains the optional parameters for the APIVersionSetClient.Delete method.
type APIVersionSetClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// APIVersionSetClientGetEntityTagOptions contains the optional parameters for the APIVersionSetClient.GetEntityTag method.
type APIVersionSetClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APIVersionSetClientGetOptions contains the optional parameters for the APIVersionSetClient.Get method.
type APIVersionSetClientGetOptions struct {
	// placeholder for future optional parameters
}

// APIVersionSetClientListByServiceOptions contains the optional parameters for the APIVersionSetClient.NewListByServicePager
// method.
type APIVersionSetClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// APIVersionSetClientUpdateOptions contains the optional parameters for the APIVersionSetClient.Update method.
type APIVersionSetClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// APIWikiClientCreateOrUpdateOptions contains the optional parameters for the APIWikiClient.CreateOrUpdate method.
type APIWikiClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// APIWikiClientDeleteOptions contains the optional parameters for the APIWikiClient.Delete method.
type APIWikiClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// APIWikiClientGetEntityTagOptions contains the optional parameters for the APIWikiClient.GetEntityTag method.
type APIWikiClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// APIWikiClientGetOptions contains the optional parameters for the APIWikiClient.Get method.
type APIWikiClientGetOptions struct {
	// placeholder for future optional parameters
}

// APIWikiClientUpdateOptions contains the optional parameters for the APIWikiClient.Update method.
type APIWikiClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// APIWikisClientListOptions contains the optional parameters for the APIWikisClient.NewListPager method.
type APIWikisClientListOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | eq | contains |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// AuthorizationAccessPolicyClientCreateOrUpdateOptions contains the optional parameters for the AuthorizationAccessPolicyClient.CreateOrUpdate
// method.
type AuthorizationAccessPolicyClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// AuthorizationAccessPolicyClientDeleteOptions contains the optional parameters for the AuthorizationAccessPolicyClient.Delete
// method.
type AuthorizationAccessPolicyClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationAccessPolicyClientGetOptions contains the optional parameters for the AuthorizationAccessPolicyClient.Get
// method.
type AuthorizationAccessPolicyClientGetOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationAccessPolicyClientListByAuthorizationOptions contains the optional parameters for the AuthorizationAccessPolicyClient.NewListByAuthorizationPager
// method.
type AuthorizationAccessPolicyClientListByAuthorizationOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// AuthorizationClientConfirmConsentCodeOptions contains the optional parameters for the AuthorizationClient.ConfirmConsentCode
// method.
type AuthorizationClientConfirmConsentCodeOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationClientCreateOrUpdateOptions contains the optional parameters for the AuthorizationClient.CreateOrUpdate method.
type AuthorizationClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// AuthorizationClientDeleteOptions contains the optional parameters for the AuthorizationClient.Delete method.
type AuthorizationClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationClientGetOptions contains the optional parameters for the AuthorizationClient.Get method.
type AuthorizationClientGetOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationClientListByAuthorizationProviderOptions contains the optional parameters for the AuthorizationClient.NewListByAuthorizationProviderPager
// method.
type AuthorizationClientListByAuthorizationProviderOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// AuthorizationLoginLinksClientPostOptions contains the optional parameters for the AuthorizationLoginLinksClient.Post method.
type AuthorizationLoginLinksClientPostOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationProviderClientCreateOrUpdateOptions contains the optional parameters for the AuthorizationProviderClient.CreateOrUpdate
// method.
type AuthorizationProviderClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// AuthorizationProviderClientDeleteOptions contains the optional parameters for the AuthorizationProviderClient.Delete method.
type AuthorizationProviderClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationProviderClientGetOptions contains the optional parameters for the AuthorizationProviderClient.Get method.
type AuthorizationProviderClientGetOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationProviderClientListByServiceOptions contains the optional parameters for the AuthorizationProviderClient.NewListByServicePager
// method.
type AuthorizationProviderClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// AuthorizationServerClientCreateOrUpdateOptions contains the optional parameters for the AuthorizationServerClient.CreateOrUpdate
// method.
type AuthorizationServerClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// AuthorizationServerClientDeleteOptions contains the optional parameters for the AuthorizationServerClient.Delete method.
type AuthorizationServerClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationServerClientGetEntityTagOptions contains the optional parameters for the AuthorizationServerClient.GetEntityTag
// method.
type AuthorizationServerClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationServerClientGetOptions contains the optional parameters for the AuthorizationServerClient.Get method.
type AuthorizationServerClientGetOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationServerClientListByServiceOptions contains the optional parameters for the AuthorizationServerClient.NewListByServicePager
// method.
type AuthorizationServerClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// AuthorizationServerClientListSecretsOptions contains the optional parameters for the AuthorizationServerClient.ListSecrets
// method.
type AuthorizationServerClientListSecretsOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationServerClientUpdateOptions contains the optional parameters for the AuthorizationServerClient.Update method.
type AuthorizationServerClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// BackendClientCreateOrUpdateOptions contains the optional parameters for the BackendClient.CreateOrUpdate method.
type BackendClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// BackendClientDeleteOptions contains the optional parameters for the BackendClient.Delete method.
type BackendClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// BackendClientGetEntityTagOptions contains the optional parameters for the BackendClient.GetEntityTag method.
type BackendClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// BackendClientGetOptions contains the optional parameters for the BackendClient.Get method.
type BackendClientGetOptions struct {
	// placeholder for future optional parameters
}

// BackendClientListByServiceOptions contains the optional parameters for the BackendClient.NewListByServicePager method.
type BackendClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | title | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | url | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// BackendClientReconnectOptions contains the optional parameters for the BackendClient.Reconnect method.
type BackendClientReconnectOptions struct {
	// Reconnect request parameters.
	Parameters *BackendReconnectContract
}

// BackendClientUpdateOptions contains the optional parameters for the BackendClient.Update method.
type BackendClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// CacheClientCreateOrUpdateOptions contains the optional parameters for the CacheClient.CreateOrUpdate method.
type CacheClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// CacheClientDeleteOptions contains the optional parameters for the CacheClient.Delete method.
type CacheClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// CacheClientGetEntityTagOptions contains the optional parameters for the CacheClient.GetEntityTag method.
type CacheClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// CacheClientGetOptions contains the optional parameters for the CacheClient.Get method.
type CacheClientGetOptions struct {
	// placeholder for future optional parameters
}

// CacheClientListByServiceOptions contains the optional parameters for the CacheClient.NewListByServicePager method.
type CacheClientListByServiceOptions struct {
	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// CacheClientUpdateOptions contains the optional parameters for the CacheClient.Update method.
type CacheClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// CertificateClientCreateOrUpdateOptions contains the optional parameters for the CertificateClient.CreateOrUpdate method.
type CertificateClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// CertificateClientDeleteOptions contains the optional parameters for the CertificateClient.Delete method.
type CertificateClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// CertificateClientGetEntityTagOptions contains the optional parameters for the CertificateClient.GetEntityTag method.
type CertificateClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// CertificateClientGetOptions contains the optional parameters for the CertificateClient.Get method.
type CertificateClientGetOptions struct {
	// placeholder for future optional parameters
}

// CertificateClientListByServiceOptions contains the optional parameters for the CertificateClient.NewListByServicePager
// method.
type CertificateClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | subject | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | thumbprint | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | expirationDate | filter | ge, le, eq, ne, gt, lt | |
	Filter *string

	// When set to true, the response contains only certificates entities which failed refresh.
	IsKeyVaultRefreshFailed *bool

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// CertificateClientRefreshSecretOptions contains the optional parameters for the CertificateClient.RefreshSecret method.
type CertificateClientRefreshSecretOptions struct {
	// placeholder for future optional parameters
}

// ClientBeginPerformConnectivityCheckAsyncOptions contains the optional parameters for the Client.BeginPerformConnectivityCheckAsync
// method.
type ClientBeginPerformConnectivityCheckAsyncOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ContentItemClientCreateOrUpdateOptions contains the optional parameters for the ContentItemClient.CreateOrUpdate method.
type ContentItemClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// ContentItemClientDeleteOptions contains the optional parameters for the ContentItemClient.Delete method.
type ContentItemClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ContentItemClientGetEntityTagOptions contains the optional parameters for the ContentItemClient.GetEntityTag method.
type ContentItemClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// ContentItemClientGetOptions contains the optional parameters for the ContentItemClient.Get method.
type ContentItemClientGetOptions struct {
	// placeholder for future optional parameters
}

// ContentItemClientListByServiceOptions contains the optional parameters for the ContentItemClient.NewListByServicePager
// method.
type ContentItemClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// ContentTypeClientCreateOrUpdateOptions contains the optional parameters for the ContentTypeClient.CreateOrUpdate method.
type ContentTypeClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// ContentTypeClientDeleteOptions contains the optional parameters for the ContentTypeClient.Delete method.
type ContentTypeClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ContentTypeClientGetOptions contains the optional parameters for the ContentTypeClient.Get method.
type ContentTypeClientGetOptions struct {
	// placeholder for future optional parameters
}

// ContentTypeClientListByServiceOptions contains the optional parameters for the ContentTypeClient.NewListByServicePager
// method.
type ContentTypeClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// DelegationSettingsClientCreateOrUpdateOptions contains the optional parameters for the DelegationSettingsClient.CreateOrUpdate
// method.
type DelegationSettingsClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// DelegationSettingsClientGetEntityTagOptions contains the optional parameters for the DelegationSettingsClient.GetEntityTag
// method.
type DelegationSettingsClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// DelegationSettingsClientGetOptions contains the optional parameters for the DelegationSettingsClient.Get method.
type DelegationSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DelegationSettingsClientListSecretsOptions contains the optional parameters for the DelegationSettingsClient.ListSecrets
// method.
type DelegationSettingsClientListSecretsOptions struct {
	// placeholder for future optional parameters
}

// DelegationSettingsClientUpdateOptions contains the optional parameters for the DelegationSettingsClient.Update method.
type DelegationSettingsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// DeletedServicesClientBeginPurgeOptions contains the optional parameters for the DeletedServicesClient.BeginPurge method.
type DeletedServicesClientBeginPurgeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeletedServicesClientGetByNameOptions contains the optional parameters for the DeletedServicesClient.GetByName method.
type DeletedServicesClientGetByNameOptions struct {
	// placeholder for future optional parameters
}

// DeletedServicesClientListBySubscriptionOptions contains the optional parameters for the DeletedServicesClient.NewListBySubscriptionPager
// method.
type DeletedServicesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticClientCreateOrUpdateOptions contains the optional parameters for the DiagnosticClient.CreateOrUpdate method.
type DiagnosticClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// DiagnosticClientDeleteOptions contains the optional parameters for the DiagnosticClient.Delete method.
type DiagnosticClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticClientGetEntityTagOptions contains the optional parameters for the DiagnosticClient.GetEntityTag method.
type DiagnosticClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticClientGetOptions contains the optional parameters for the DiagnosticClient.Get method.
type DiagnosticClientGetOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticClientListByServiceOptions contains the optional parameters for the DiagnosticClient.NewListByServicePager method.
type DiagnosticClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// DiagnosticClientUpdateOptions contains the optional parameters for the DiagnosticClient.Update method.
type DiagnosticClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// DocumentationClientCreateOrUpdateOptions contains the optional parameters for the DocumentationClient.CreateOrUpdate method.
type DocumentationClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// DocumentationClientDeleteOptions contains the optional parameters for the DocumentationClient.Delete method.
type DocumentationClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DocumentationClientGetEntityTagOptions contains the optional parameters for the DocumentationClient.GetEntityTag method.
type DocumentationClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// DocumentationClientGetOptions contains the optional parameters for the DocumentationClient.Get method.
type DocumentationClientGetOptions struct {
	// placeholder for future optional parameters
}

// DocumentationClientListByServiceOptions contains the optional parameters for the DocumentationClient.NewListByServicePager
// method.
type DocumentationClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | eq | contains |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// DocumentationClientUpdateOptions contains the optional parameters for the DocumentationClient.Update method.
type DocumentationClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// EmailTemplateClientCreateOrUpdateOptions contains the optional parameters for the EmailTemplateClient.CreateOrUpdate method.
type EmailTemplateClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// EmailTemplateClientDeleteOptions contains the optional parameters for the EmailTemplateClient.Delete method.
type EmailTemplateClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// EmailTemplateClientGetEntityTagOptions contains the optional parameters for the EmailTemplateClient.GetEntityTag method.
type EmailTemplateClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// EmailTemplateClientGetOptions contains the optional parameters for the EmailTemplateClient.Get method.
type EmailTemplateClientGetOptions struct {
	// placeholder for future optional parameters
}

// EmailTemplateClientListByServiceOptions contains the optional parameters for the EmailTemplateClient.NewListByServicePager
// method.
type EmailTemplateClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// EmailTemplateClientUpdateOptions contains the optional parameters for the EmailTemplateClient.Update method.
type EmailTemplateClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// GatewayAPIClientCreateOrUpdateOptions contains the optional parameters for the GatewayAPIClient.CreateOrUpdate method.
type GatewayAPIClientCreateOrUpdateOptions struct {
	Parameters *AssociationContract
}

// GatewayAPIClientDeleteOptions contains the optional parameters for the GatewayAPIClient.Delete method.
type GatewayAPIClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// GatewayAPIClientGetEntityTagOptions contains the optional parameters for the GatewayAPIClient.GetEntityTag method.
type GatewayAPIClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// GatewayAPIClientListByServiceOptions contains the optional parameters for the GatewayAPIClient.NewListByServicePager method.
type GatewayAPIClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// GatewayCertificateAuthorityClientCreateOrUpdateOptions contains the optional parameters for the GatewayCertificateAuthorityClient.CreateOrUpdate
// method.
type GatewayCertificateAuthorityClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// GatewayCertificateAuthorityClientDeleteOptions contains the optional parameters for the GatewayCertificateAuthorityClient.Delete
// method.
type GatewayCertificateAuthorityClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// GatewayCertificateAuthorityClientGetEntityTagOptions contains the optional parameters for the GatewayCertificateAuthorityClient.GetEntityTag
// method.
type GatewayCertificateAuthorityClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// GatewayCertificateAuthorityClientGetOptions contains the optional parameters for the GatewayCertificateAuthorityClient.Get
// method.
type GatewayCertificateAuthorityClientGetOptions struct {
	// placeholder for future optional parameters
}

// GatewayCertificateAuthorityClientListByServiceOptions contains the optional parameters for the GatewayCertificateAuthorityClient.NewListByServicePager
// method.
type GatewayCertificateAuthorityClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | eq, ne | |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// GatewayClientCreateOrUpdateOptions contains the optional parameters for the GatewayClient.CreateOrUpdate method.
type GatewayClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// GatewayClientDeleteOptions contains the optional parameters for the GatewayClient.Delete method.
type GatewayClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// GatewayClientGenerateTokenOptions contains the optional parameters for the GatewayClient.GenerateToken method.
type GatewayClientGenerateTokenOptions struct {
	// placeholder for future optional parameters
}

// GatewayClientGetEntityTagOptions contains the optional parameters for the GatewayClient.GetEntityTag method.
type GatewayClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// GatewayClientGetOptions contains the optional parameters for the GatewayClient.Get method.
type GatewayClientGetOptions struct {
	// placeholder for future optional parameters
}

// GatewayClientListByServiceOptions contains the optional parameters for the GatewayClient.NewListByServicePager method.
type GatewayClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | region | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// GatewayClientListKeysOptions contains the optional parameters for the GatewayClient.ListKeys method.
type GatewayClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// GatewayClientRegenerateKeyOptions contains the optional parameters for the GatewayClient.RegenerateKey method.
type GatewayClientRegenerateKeyOptions struct {
	// placeholder for future optional parameters
}

// GatewayClientUpdateOptions contains the optional parameters for the GatewayClient.Update method.
type GatewayClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// GatewayHostnameConfigurationClientCreateOrUpdateOptions contains the optional parameters for the GatewayHostnameConfigurationClient.CreateOrUpdate
// method.
type GatewayHostnameConfigurationClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// GatewayHostnameConfigurationClientDeleteOptions contains the optional parameters for the GatewayHostnameConfigurationClient.Delete
// method.
type GatewayHostnameConfigurationClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// GatewayHostnameConfigurationClientGetEntityTagOptions contains the optional parameters for the GatewayHostnameConfigurationClient.GetEntityTag
// method.
type GatewayHostnameConfigurationClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// GatewayHostnameConfigurationClientGetOptions contains the optional parameters for the GatewayHostnameConfigurationClient.Get
// method.
type GatewayHostnameConfigurationClientGetOptions struct {
	// placeholder for future optional parameters
}

// GatewayHostnameConfigurationClientListByServiceOptions contains the optional parameters for the GatewayHostnameConfigurationClient.NewListByServicePager
// method.
type GatewayHostnameConfigurationClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | hostname | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// GlobalSchemaClientBeginCreateOrUpdateOptions contains the optional parameters for the GlobalSchemaClient.BeginCreateOrUpdate
// method.
type GlobalSchemaClientBeginCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string

	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GlobalSchemaClientDeleteOptions contains the optional parameters for the GlobalSchemaClient.Delete method.
type GlobalSchemaClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// GlobalSchemaClientGetEntityTagOptions contains the optional parameters for the GlobalSchemaClient.GetEntityTag method.
type GlobalSchemaClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// GlobalSchemaClientGetOptions contains the optional parameters for the GlobalSchemaClient.Get method.
type GlobalSchemaClientGetOptions struct {
	// placeholder for future optional parameters
}

// GlobalSchemaClientListByServiceOptions contains the optional parameters for the GlobalSchemaClient.NewListByServicePager
// method.
type GlobalSchemaClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// GraphQLAPIResolverClientCreateOrUpdateOptions contains the optional parameters for the GraphQLAPIResolverClient.CreateOrUpdate
// method.
type GraphQLAPIResolverClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// GraphQLAPIResolverClientDeleteOptions contains the optional parameters for the GraphQLAPIResolverClient.Delete method.
type GraphQLAPIResolverClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// GraphQLAPIResolverClientGetEntityTagOptions contains the optional parameters for the GraphQLAPIResolverClient.GetEntityTag
// method.
type GraphQLAPIResolverClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// GraphQLAPIResolverClientGetOptions contains the optional parameters for the GraphQLAPIResolverClient.Get method.
type GraphQLAPIResolverClientGetOptions struct {
	// placeholder for future optional parameters
}

// GraphQLAPIResolverClientListByAPIOptions contains the optional parameters for the GraphQLAPIResolverClient.NewListByAPIPager
// method.
type GraphQLAPIResolverClientListByAPIOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | path | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// GraphQLAPIResolverClientUpdateOptions contains the optional parameters for the GraphQLAPIResolverClient.Update method.
type GraphQLAPIResolverClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// GraphQLAPIResolverPolicyClientCreateOrUpdateOptions contains the optional parameters for the GraphQLAPIResolverPolicyClient.CreateOrUpdate
// method.
type GraphQLAPIResolverPolicyClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// GraphQLAPIResolverPolicyClientDeleteOptions contains the optional parameters for the GraphQLAPIResolverPolicyClient.Delete
// method.
type GraphQLAPIResolverPolicyClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// GraphQLAPIResolverPolicyClientGetEntityTagOptions contains the optional parameters for the GraphQLAPIResolverPolicyClient.GetEntityTag
// method.
type GraphQLAPIResolverPolicyClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// GraphQLAPIResolverPolicyClientGetOptions contains the optional parameters for the GraphQLAPIResolverPolicyClient.Get method.
type GraphQLAPIResolverPolicyClientGetOptions struct {
	// Policy Export Format.
	Format *PolicyExportFormat
}

// GraphQLAPIResolverPolicyClientListByResolverOptions contains the optional parameters for the GraphQLAPIResolverPolicyClient.NewListByResolverPager
// method.
type GraphQLAPIResolverPolicyClientListByResolverOptions struct {
	// placeholder for future optional parameters
}

// GroupClientCreateOrUpdateOptions contains the optional parameters for the GroupClient.CreateOrUpdate method.
type GroupClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// GroupClientDeleteOptions contains the optional parameters for the GroupClient.Delete method.
type GroupClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// GroupClientGetEntityTagOptions contains the optional parameters for the GroupClient.GetEntityTag method.
type GroupClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// GroupClientGetOptions contains the optional parameters for the GroupClient.Get method.
type GroupClientGetOptions struct {
	// placeholder for future optional parameters
}

// GroupClientListByServiceOptions contains the optional parameters for the GroupClient.NewListByServicePager method.
type GroupClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | externalId | filter | eq | |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// GroupClientUpdateOptions contains the optional parameters for the GroupClient.Update method.
type GroupClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// GroupUserClientCheckEntityExistsOptions contains the optional parameters for the GroupUserClient.CheckEntityExists method.
type GroupUserClientCheckEntityExistsOptions struct {
	// placeholder for future optional parameters
}

// GroupUserClientCreateOptions contains the optional parameters for the GroupUserClient.Create method.
type GroupUserClientCreateOptions struct {
	// placeholder for future optional parameters
}

// GroupUserClientDeleteOptions contains the optional parameters for the GroupUserClient.Delete method.
type GroupUserClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// GroupUserClientListOptions contains the optional parameters for the GroupUserClient.NewListPager method.
type GroupUserClientListOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | firstName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | lastName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | email | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | registrationDate | filter | ge, le, eq, ne, gt, lt | |
	// | note | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// IdentityProviderClientCreateOrUpdateOptions contains the optional parameters for the IdentityProviderClient.CreateOrUpdate
// method.
type IdentityProviderClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// IdentityProviderClientDeleteOptions contains the optional parameters for the IdentityProviderClient.Delete method.
type IdentityProviderClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// IdentityProviderClientGetEntityTagOptions contains the optional parameters for the IdentityProviderClient.GetEntityTag
// method.
type IdentityProviderClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// IdentityProviderClientGetOptions contains the optional parameters for the IdentityProviderClient.Get method.
type IdentityProviderClientGetOptions struct {
	// placeholder for future optional parameters
}

// IdentityProviderClientListByServiceOptions contains the optional parameters for the IdentityProviderClient.NewListByServicePager
// method.
type IdentityProviderClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// IdentityProviderClientListSecretsOptions contains the optional parameters for the IdentityProviderClient.ListSecrets method.
type IdentityProviderClientListSecretsOptions struct {
	// placeholder for future optional parameters
}

// IdentityProviderClientUpdateOptions contains the optional parameters for the IdentityProviderClient.Update method.
type IdentityProviderClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// IssueClientGetOptions contains the optional parameters for the IssueClient.Get method.
type IssueClientGetOptions struct {
	// placeholder for future optional parameters
}

// IssueClientListByServiceOptions contains the optional parameters for the IssueClient.NewListByServicePager method.
type IssueClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | apiId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | title | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | authorName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | state | filter | eq | |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// LoggerClientCreateOrUpdateOptions contains the optional parameters for the LoggerClient.CreateOrUpdate method.
type LoggerClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// LoggerClientDeleteOptions contains the optional parameters for the LoggerClient.Delete method.
type LoggerClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// LoggerClientGetEntityTagOptions contains the optional parameters for the LoggerClient.GetEntityTag method.
type LoggerClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// LoggerClientGetOptions contains the optional parameters for the LoggerClient.Get method.
type LoggerClientGetOptions struct {
	// placeholder for future optional parameters
}

// LoggerClientListByServiceOptions contains the optional parameters for the LoggerClient.NewListByServicePager method.
type LoggerClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | loggerType | filter | eq | |
	// | resourceId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// LoggerClientUpdateOptions contains the optional parameters for the LoggerClient.Update method.
type LoggerClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// NamedValueClientBeginCreateOrUpdateOptions contains the optional parameters for the NamedValueClient.BeginCreateOrUpdate
// method.
type NamedValueClientBeginCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string

	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NamedValueClientBeginRefreshSecretOptions contains the optional parameters for the NamedValueClient.BeginRefreshSecret
// method.
type NamedValueClientBeginRefreshSecretOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NamedValueClientBeginUpdateOptions contains the optional parameters for the NamedValueClient.BeginUpdate method.
type NamedValueClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NamedValueClientDeleteOptions contains the optional parameters for the NamedValueClient.Delete method.
type NamedValueClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// NamedValueClientGetEntityTagOptions contains the optional parameters for the NamedValueClient.GetEntityTag method.
type NamedValueClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// NamedValueClientGetOptions contains the optional parameters for the NamedValueClient.Get method.
type NamedValueClientGetOptions struct {
	// placeholder for future optional parameters
}

// NamedValueClientListByServiceOptions contains the optional parameters for the NamedValueClient.NewListByServicePager method.
type NamedValueClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | tags | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith, any, all |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// When set to true, the response contains only named value entities which failed refresh.
	IsKeyVaultRefreshFailed *bool

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// NamedValueClientListValueOptions contains the optional parameters for the NamedValueClient.ListValue method.
type NamedValueClientListValueOptions struct {
	// placeholder for future optional parameters
}

// NetworkStatusClientListByLocationOptions contains the optional parameters for the NetworkStatusClient.ListByLocation method.
type NetworkStatusClientListByLocationOptions struct {
	// placeholder for future optional parameters
}

// NetworkStatusClientListByServiceOptions contains the optional parameters for the NetworkStatusClient.ListByService method.
type NetworkStatusClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// NotificationClientCreateOrUpdateOptions contains the optional parameters for the NotificationClient.CreateOrUpdate method.
type NotificationClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// NotificationClientGetOptions contains the optional parameters for the NotificationClient.Get method.
type NotificationClientGetOptions struct {
	// placeholder for future optional parameters
}

// NotificationClientListByServiceOptions contains the optional parameters for the NotificationClient.NewListByServicePager
// method.
type NotificationClientListByServiceOptions struct {
	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// NotificationRecipientEmailClientCheckEntityExistsOptions contains the optional parameters for the NotificationRecipientEmailClient.CheckEntityExists
// method.
type NotificationRecipientEmailClientCheckEntityExistsOptions struct {
	// placeholder for future optional parameters
}

// NotificationRecipientEmailClientCreateOrUpdateOptions contains the optional parameters for the NotificationRecipientEmailClient.CreateOrUpdate
// method.
type NotificationRecipientEmailClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// NotificationRecipientEmailClientDeleteOptions contains the optional parameters for the NotificationRecipientEmailClient.Delete
// method.
type NotificationRecipientEmailClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// NotificationRecipientEmailClientListByNotificationOptions contains the optional parameters for the NotificationRecipientEmailClient.ListByNotification
// method.
type NotificationRecipientEmailClientListByNotificationOptions struct {
	// placeholder for future optional parameters
}

// NotificationRecipientUserClientCheckEntityExistsOptions contains the optional parameters for the NotificationRecipientUserClient.CheckEntityExists
// method.
type NotificationRecipientUserClientCheckEntityExistsOptions struct {
	// placeholder for future optional parameters
}

// NotificationRecipientUserClientCreateOrUpdateOptions contains the optional parameters for the NotificationRecipientUserClient.CreateOrUpdate
// method.
type NotificationRecipientUserClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// NotificationRecipientUserClientDeleteOptions contains the optional parameters for the NotificationRecipientUserClient.Delete
// method.
type NotificationRecipientUserClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// NotificationRecipientUserClientListByNotificationOptions contains the optional parameters for the NotificationRecipientUserClient.ListByNotification
// method.
type NotificationRecipientUserClientListByNotificationOptions struct {
	// placeholder for future optional parameters
}

// OpenIDConnectProviderClientCreateOrUpdateOptions contains the optional parameters for the OpenIDConnectProviderClient.CreateOrUpdate
// method.
type OpenIDConnectProviderClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// OpenIDConnectProviderClientDeleteOptions contains the optional parameters for the OpenIDConnectProviderClient.Delete method.
type OpenIDConnectProviderClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// OpenIDConnectProviderClientGetEntityTagOptions contains the optional parameters for the OpenIDConnectProviderClient.GetEntityTag
// method.
type OpenIDConnectProviderClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// OpenIDConnectProviderClientGetOptions contains the optional parameters for the OpenIDConnectProviderClient.Get method.
type OpenIDConnectProviderClientGetOptions struct {
	// placeholder for future optional parameters
}

// OpenIDConnectProviderClientListByServiceOptions contains the optional parameters for the OpenIDConnectProviderClient.NewListByServicePager
// method.
type OpenIDConnectProviderClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// OpenIDConnectProviderClientListSecretsOptions contains the optional parameters for the OpenIDConnectProviderClient.ListSecrets
// method.
type OpenIDConnectProviderClientListSecretsOptions struct {
	// placeholder for future optional parameters
}

// OpenIDConnectProviderClientUpdateOptions contains the optional parameters for the OpenIDConnectProviderClient.Update method.
type OpenIDConnectProviderClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// OperationClientListByTagsOptions contains the optional parameters for the OperationClient.NewListByTagsPager method.
type OperationClientListByTagsOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | apiName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | method | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | urlTemplate | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Include not tagged Operations.
	IncludeNotTaggedOperations *bool

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.NewListPager method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OutboundNetworkDependenciesEndpointsClientListByServiceOptions contains the optional parameters for the OutboundNetworkDependenciesEndpointsClient.ListByService
// method.
type OutboundNetworkDependenciesEndpointsClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// PolicyClientCreateOrUpdateOptions contains the optional parameters for the PolicyClient.CreateOrUpdate method.
type PolicyClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// PolicyClientDeleteOptions contains the optional parameters for the PolicyClient.Delete method.
type PolicyClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// PolicyClientGetEntityTagOptions contains the optional parameters for the PolicyClient.GetEntityTag method.
type PolicyClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// PolicyClientGetOptions contains the optional parameters for the PolicyClient.Get method.
type PolicyClientGetOptions struct {
	// Policy Export Format.
	Format *PolicyExportFormat
}

// PolicyClientListByServiceOptions contains the optional parameters for the PolicyClient.ListByService method.
type PolicyClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// PolicyDescriptionClientListByServiceOptions contains the optional parameters for the PolicyDescriptionClient.ListByService
// method.
type PolicyDescriptionClientListByServiceOptions struct {
	// Policy scope.
	Scope *PolicyScopeContract
}

// PolicyFragmentClientBeginCreateOrUpdateOptions contains the optional parameters for the PolicyFragmentClient.BeginCreateOrUpdate
// method.
type PolicyFragmentClientBeginCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string

	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PolicyFragmentClientDeleteOptions contains the optional parameters for the PolicyFragmentClient.Delete method.
type PolicyFragmentClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// PolicyFragmentClientGetEntityTagOptions contains the optional parameters for the PolicyFragmentClient.GetEntityTag method.
type PolicyFragmentClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// PolicyFragmentClientGetOptions contains the optional parameters for the PolicyFragmentClient.Get method.
type PolicyFragmentClientGetOptions struct {
	// Policy fragment content format.
	Format *PolicyFragmentContentFormat
}

// PolicyFragmentClientListByServiceOptions contains the optional parameters for the PolicyFragmentClient.ListByService method.
type PolicyFragmentClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter, orderBy | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | value | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// OData order by query option.
	Orderby *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// PolicyFragmentClientListReferencesOptions contains the optional parameters for the PolicyFragmentClient.ListReferences
// method.
type PolicyFragmentClientListReferencesOptions struct {
	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// PortalConfigClientCreateOrUpdateOptions contains the optional parameters for the PortalConfigClient.CreateOrUpdate method.
type PortalConfigClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// PortalConfigClientGetEntityTagOptions contains the optional parameters for the PortalConfigClient.GetEntityTag method.
type PortalConfigClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// PortalConfigClientGetOptions contains the optional parameters for the PortalConfigClient.Get method.
type PortalConfigClientGetOptions struct {
	// placeholder for future optional parameters
}

// PortalConfigClientListByServiceOptions contains the optional parameters for the PortalConfigClient.ListByService method.
type PortalConfigClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// PortalConfigClientUpdateOptions contains the optional parameters for the PortalConfigClient.Update method.
type PortalConfigClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// PortalRevisionClientBeginCreateOrUpdateOptions contains the optional parameters for the PortalRevisionClient.BeginCreateOrUpdate
// method.
type PortalRevisionClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PortalRevisionClientBeginUpdateOptions contains the optional parameters for the PortalRevisionClient.BeginUpdate method.
type PortalRevisionClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PortalRevisionClientGetEntityTagOptions contains the optional parameters for the PortalRevisionClient.GetEntityTag method.
type PortalRevisionClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// PortalRevisionClientGetOptions contains the optional parameters for the PortalRevisionClient.Get method.
type PortalRevisionClientGetOptions struct {
	// placeholder for future optional parameters
}

// PortalRevisionClientListByServiceOptions contains the optional parameters for the PortalRevisionClient.NewListByServicePager
// method.
type PortalRevisionClientListByServiceOptions struct {
	// FIELD SUPPORTED OPERATORS SUPPORTED FUNCTIONS
	// |name | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith| |description | ge, le, eq, ne, gt, lt | substringof,
	// contains, startswith, endswith| |isCurrent | eq, ne | |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// PortalSettingsClientListByServiceOptions contains the optional parameters for the PortalSettingsClient.ListByService method.
type PortalSettingsClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionClient.BeginCreateOrUpdate
// method.
type PrivateEndpointConnectionClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionClient.BeginDelete
// method.
type PrivateEndpointConnectionClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionClientGetByNameOptions contains the optional parameters for the PrivateEndpointConnectionClient.GetByName
// method.
type PrivateEndpointConnectionClientGetByNameOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionClientGetPrivateLinkResourceOptions contains the optional parameters for the PrivateEndpointConnectionClient.GetPrivateLinkResource
// method.
type PrivateEndpointConnectionClientGetPrivateLinkResourceOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionClientListByServiceOptions contains the optional parameters for the PrivateEndpointConnectionClient.NewListByServicePager
// method.
type PrivateEndpointConnectionClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionClientListPrivateLinkResourcesOptions contains the optional parameters for the PrivateEndpointConnectionClient.ListPrivateLinkResources
// method.
type PrivateEndpointConnectionClientListPrivateLinkResourcesOptions struct {
	// placeholder for future optional parameters
}

// ProductAPIClientCheckEntityExistsOptions contains the optional parameters for the ProductAPIClient.CheckEntityExists method.
type ProductAPIClientCheckEntityExistsOptions struct {
	// placeholder for future optional parameters
}

// ProductAPIClientCreateOrUpdateOptions contains the optional parameters for the ProductAPIClient.CreateOrUpdate method.
type ProductAPIClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProductAPIClientDeleteOptions contains the optional parameters for the ProductAPIClient.Delete method.
type ProductAPIClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ProductAPIClientListByProductOptions contains the optional parameters for the ProductAPIClient.NewListByProductPager method.
type ProductAPIClientListByProductOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | serviceUrl | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | path | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// ProductClientCreateOrUpdateOptions contains the optional parameters for the ProductClient.CreateOrUpdate method.
type ProductClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// ProductClientDeleteOptions contains the optional parameters for the ProductClient.Delete method.
type ProductClientDeleteOptions struct {
	// Delete existing subscriptions associated with the product or not.
	DeleteSubscriptions *bool
}

// ProductClientGetEntityTagOptions contains the optional parameters for the ProductClient.GetEntityTag method.
type ProductClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// ProductClientGetOptions contains the optional parameters for the ProductClient.Get method.
type ProductClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProductClientListByServiceOptions contains the optional parameters for the ProductClient.NewListByServicePager method.
type ProductClientListByServiceOptions struct {
	// When set to true, the response contains an array of groups that have visibility to the product. The default is false.
	ExpandGroups *bool

	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | terms | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | state | filter | eq | |
	// | groups | expand | | |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Products which are part of a specific tag.
	Tags *string

	// Number of records to return.
	Top *int32
}

// ProductClientListByTagsOptions contains the optional parameters for the ProductClient.NewListByTagsPager method.
type ProductClientListByTagsOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | terms | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | state | filter | eq | substringof, contains, startswith, endswith |
	Filter *string

	// Include not tagged Products.
	IncludeNotTaggedProducts *bool

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// ProductClientUpdateOptions contains the optional parameters for the ProductClient.Update method.
type ProductClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProductGroupClientCheckEntityExistsOptions contains the optional parameters for the ProductGroupClient.CheckEntityExists
// method.
type ProductGroupClientCheckEntityExistsOptions struct {
	// placeholder for future optional parameters
}

// ProductGroupClientCreateOrUpdateOptions contains the optional parameters for the ProductGroupClient.CreateOrUpdate method.
type ProductGroupClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProductGroupClientDeleteOptions contains the optional parameters for the ProductGroupClient.Delete method.
type ProductGroupClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ProductGroupClientListByProductOptions contains the optional parameters for the ProductGroupClient.NewListByProductPager
// method.
type ProductGroupClientListByProductOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | |
	// | displayName | filter | eq, ne | |
	// | description | filter | eq, ne | |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// ProductPolicyClientCreateOrUpdateOptions contains the optional parameters for the ProductPolicyClient.CreateOrUpdate method.
type ProductPolicyClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// ProductPolicyClientDeleteOptions contains the optional parameters for the ProductPolicyClient.Delete method.
type ProductPolicyClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ProductPolicyClientGetEntityTagOptions contains the optional parameters for the ProductPolicyClient.GetEntityTag method.
type ProductPolicyClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// ProductPolicyClientGetOptions contains the optional parameters for the ProductPolicyClient.Get method.
type ProductPolicyClientGetOptions struct {
	// Policy Export Format.
	Format *PolicyExportFormat
}

// ProductPolicyClientListByProductOptions contains the optional parameters for the ProductPolicyClient.ListByProduct method.
type ProductPolicyClientListByProductOptions struct {
	// placeholder for future optional parameters
}

// ProductSubscriptionsClientListOptions contains the optional parameters for the ProductSubscriptionsClient.NewListPager
// method.
type ProductSubscriptionsClientListOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | stateComment | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | ownerId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | scope | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | userId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | productId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | state | filter | eq | |
	// | user | expand | | |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// ProductWikiClientCreateOrUpdateOptions contains the optional parameters for the ProductWikiClient.CreateOrUpdate method.
type ProductWikiClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// ProductWikiClientDeleteOptions contains the optional parameters for the ProductWikiClient.Delete method.
type ProductWikiClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ProductWikiClientGetEntityTagOptions contains the optional parameters for the ProductWikiClient.GetEntityTag method.
type ProductWikiClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// ProductWikiClientGetOptions contains the optional parameters for the ProductWikiClient.Get method.
type ProductWikiClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProductWikiClientUpdateOptions contains the optional parameters for the ProductWikiClient.Update method.
type ProductWikiClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProductWikisClientListOptions contains the optional parameters for the ProductWikisClient.NewListPager method.
type ProductWikisClientListOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | eq | contains |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// QuotaByCounterKeysClientListByServiceOptions contains the optional parameters for the QuotaByCounterKeysClient.ListByService
// method.
type QuotaByCounterKeysClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// QuotaByCounterKeysClientUpdateOptions contains the optional parameters for the QuotaByCounterKeysClient.Update method.
type QuotaByCounterKeysClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// QuotaByPeriodKeysClientGetOptions contains the optional parameters for the QuotaByPeriodKeysClient.Get method.
type QuotaByPeriodKeysClientGetOptions struct {
	// placeholder for future optional parameters
}

// QuotaByPeriodKeysClientUpdateOptions contains the optional parameters for the QuotaByPeriodKeysClient.Update method.
type QuotaByPeriodKeysClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// RegionClientListByServiceOptions contains the optional parameters for the RegionClient.NewListByServicePager method.
type RegionClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// ReportsClientListByAPIOptions contains the optional parameters for the ReportsClient.NewListByAPIPager method.
type ReportsClientListByAPIOptions struct {
	// OData order by query option.
	Orderby *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// ReportsClientListByGeoOptions contains the optional parameters for the ReportsClient.NewListByGeoPager method.
type ReportsClientListByGeoOptions struct {
	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// ReportsClientListByOperationOptions contains the optional parameters for the ReportsClient.NewListByOperationPager method.
type ReportsClientListByOperationOptions struct {
	// OData order by query option.
	Orderby *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// ReportsClientListByProductOptions contains the optional parameters for the ReportsClient.NewListByProductPager method.
type ReportsClientListByProductOptions struct {
	// OData order by query option.
	Orderby *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// ReportsClientListByRequestOptions contains the optional parameters for the ReportsClient.NewListByRequestPager method.
type ReportsClientListByRequestOptions struct {
	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// ReportsClientListBySubscriptionOptions contains the optional parameters for the ReportsClient.NewListBySubscriptionPager
// method.
type ReportsClientListBySubscriptionOptions struct {
	// OData order by query option.
	Orderby *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// ReportsClientListByTimeOptions contains the optional parameters for the ReportsClient.NewListByTimePager method.
type ReportsClientListByTimeOptions struct {
	// OData order by query option.
	Orderby *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// ReportsClientListByUserOptions contains the optional parameters for the ReportsClient.NewListByUserPager method.
type ReportsClientListByUserOptions struct {
	// OData order by query option.
	Orderby *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// SKUsClientListOptions contains the optional parameters for the SKUsClient.NewListPager method.
type SKUsClientListOptions struct {
	// placeholder for future optional parameters
}

// ServiceClientBeginApplyNetworkConfigurationUpdatesOptions contains the optional parameters for the ServiceClient.BeginApplyNetworkConfigurationUpdates
// method.
type ServiceClientBeginApplyNetworkConfigurationUpdatesOptions struct {
	// Parameters supplied to the Apply Network Configuration operation. If the parameters are empty, all the regions in which
	// the Api Management service is deployed will be updated sequentially without
	// incurring downtime in the region.
	Parameters *ServiceApplyNetworkConfigurationParameters

	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceClientBeginBackupOptions contains the optional parameters for the ServiceClient.BeginBackup method.
type ServiceClientBeginBackupOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceClientBeginCreateOrUpdateOptions contains the optional parameters for the ServiceClient.BeginCreateOrUpdate method.
type ServiceClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceClientBeginDeleteOptions contains the optional parameters for the ServiceClient.BeginDelete method.
type ServiceClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceClientBeginMigrateToStv2Options contains the optional parameters for the ServiceClient.BeginMigrateToStv2 method.
type ServiceClientBeginMigrateToStv2Options struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceClientBeginRestoreOptions contains the optional parameters for the ServiceClient.BeginRestore method.
type ServiceClientBeginRestoreOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceClientBeginUpdateOptions contains the optional parameters for the ServiceClient.BeginUpdate method.
type ServiceClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceClientCheckNameAvailabilityOptions contains the optional parameters for the ServiceClient.CheckNameAvailability
// method.
type ServiceClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ServiceClientGetDomainOwnershipIdentifierOptions contains the optional parameters for the ServiceClient.GetDomainOwnershipIdentifier
// method.
type ServiceClientGetDomainOwnershipIdentifierOptions struct {
	// placeholder for future optional parameters
}

// ServiceClientGetOptions contains the optional parameters for the ServiceClient.Get method.
type ServiceClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServiceClientGetSsoTokenOptions contains the optional parameters for the ServiceClient.GetSsoToken method.
type ServiceClientGetSsoTokenOptions struct {
	// placeholder for future optional parameters
}

// ServiceClientListByResourceGroupOptions contains the optional parameters for the ServiceClient.NewListByResourceGroupPager
// method.
type ServiceClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ServiceClientListOptions contains the optional parameters for the ServiceClient.NewListPager method.
type ServiceClientListOptions struct {
	// placeholder for future optional parameters
}

// ServiceSKUsClientListAvailableServiceSKUsOptions contains the optional parameters for the ServiceSKUsClient.NewListAvailableServiceSKUsPager
// method.
type ServiceSKUsClientListAvailableServiceSKUsOptions struct {
	// placeholder for future optional parameters
}

// SignInSettingsClientCreateOrUpdateOptions contains the optional parameters for the SignInSettingsClient.CreateOrUpdate
// method.
type SignInSettingsClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// SignInSettingsClientGetEntityTagOptions contains the optional parameters for the SignInSettingsClient.GetEntityTag method.
type SignInSettingsClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// SignInSettingsClientGetOptions contains the optional parameters for the SignInSettingsClient.Get method.
type SignInSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SignInSettingsClientUpdateOptions contains the optional parameters for the SignInSettingsClient.Update method.
type SignInSettingsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// SignUpSettingsClientCreateOrUpdateOptions contains the optional parameters for the SignUpSettingsClient.CreateOrUpdate
// method.
type SignUpSettingsClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// SignUpSettingsClientGetEntityTagOptions contains the optional parameters for the SignUpSettingsClient.GetEntityTag method.
type SignUpSettingsClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// SignUpSettingsClientGetOptions contains the optional parameters for the SignUpSettingsClient.Get method.
type SignUpSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SignUpSettingsClientUpdateOptions contains the optional parameters for the SignUpSettingsClient.Update method.
type SignUpSettingsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionClientCreateOrUpdateOptions contains the optional parameters for the SubscriptionClient.CreateOrUpdate method.
type SubscriptionClientCreateOrUpdateOptions struct {
	// Determines the type of application which send the create user request. Default is legacy publisher portal.
	AppType *AppType

	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string

	// Notify change in Subscription State.
	// * If false, do not send any email notification for change of state of subscription
	// * If true, send email notification of change of state of subscription
	Notify *bool
}

// SubscriptionClientDeleteOptions contains the optional parameters for the SubscriptionClient.Delete method.
type SubscriptionClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionClientGetEntityTagOptions contains the optional parameters for the SubscriptionClient.GetEntityTag method.
type SubscriptionClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionClientGetOptions contains the optional parameters for the SubscriptionClient.Get method.
type SubscriptionClientGetOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionClientListOptions contains the optional parameters for the SubscriptionClient.NewListPager method.
type SubscriptionClientListOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | stateComment | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | ownerId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | scope | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | userId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | productId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | state | filter | eq | |
	// | user | expand | | |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// SubscriptionClientListSecretsOptions contains the optional parameters for the SubscriptionClient.ListSecrets method.
type SubscriptionClientListSecretsOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionClientRegeneratePrimaryKeyOptions contains the optional parameters for the SubscriptionClient.RegeneratePrimaryKey
// method.
type SubscriptionClientRegeneratePrimaryKeyOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionClientRegenerateSecondaryKeyOptions contains the optional parameters for the SubscriptionClient.RegenerateSecondaryKey
// method.
type SubscriptionClientRegenerateSecondaryKeyOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionClientUpdateOptions contains the optional parameters for the SubscriptionClient.Update method.
type SubscriptionClientUpdateOptions struct {
	// Determines the type of application which send the create user request. Default is legacy publisher portal.
	AppType *AppType

	// Notify change in Subscription State.
	// * If false, do not send any email notification for change of state of subscription
	// * If true, send email notification of change of state of subscription
	Notify *bool
}

// TagClientAssignToAPIOptions contains the optional parameters for the TagClient.AssignToAPI method.
type TagClientAssignToAPIOptions struct {
	// placeholder for future optional parameters
}

// TagClientAssignToOperationOptions contains the optional parameters for the TagClient.AssignToOperation method.
type TagClientAssignToOperationOptions struct {
	// placeholder for future optional parameters
}

// TagClientAssignToProductOptions contains the optional parameters for the TagClient.AssignToProduct method.
type TagClientAssignToProductOptions struct {
	// placeholder for future optional parameters
}

// TagClientCreateOrUpdateOptions contains the optional parameters for the TagClient.CreateOrUpdate method.
type TagClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string
}

// TagClientDeleteOptions contains the optional parameters for the TagClient.Delete method.
type TagClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// TagClientDetachFromAPIOptions contains the optional parameters for the TagClient.DetachFromAPI method.
type TagClientDetachFromAPIOptions struct {
	// placeholder for future optional parameters
}

// TagClientDetachFromOperationOptions contains the optional parameters for the TagClient.DetachFromOperation method.
type TagClientDetachFromOperationOptions struct {
	// placeholder for future optional parameters
}

// TagClientDetachFromProductOptions contains the optional parameters for the TagClient.DetachFromProduct method.
type TagClientDetachFromProductOptions struct {
	// placeholder for future optional parameters
}

// TagClientGetByAPIOptions contains the optional parameters for the TagClient.GetByAPI method.
type TagClientGetByAPIOptions struct {
	// placeholder for future optional parameters
}

// TagClientGetByOperationOptions contains the optional parameters for the TagClient.GetByOperation method.
type TagClientGetByOperationOptions struct {
	// placeholder for future optional parameters
}

// TagClientGetByProductOptions contains the optional parameters for the TagClient.GetByProduct method.
type TagClientGetByProductOptions struct {
	// placeholder for future optional parameters
}

// TagClientGetEntityStateByAPIOptions contains the optional parameters for the TagClient.GetEntityStateByAPI method.
type TagClientGetEntityStateByAPIOptions struct {
	// placeholder for future optional parameters
}

// TagClientGetEntityStateByOperationOptions contains the optional parameters for the TagClient.GetEntityStateByOperation
// method.
type TagClientGetEntityStateByOperationOptions struct {
	// placeholder for future optional parameters
}

// TagClientGetEntityStateByProductOptions contains the optional parameters for the TagClient.GetEntityStateByProduct method.
type TagClientGetEntityStateByProductOptions struct {
	// placeholder for future optional parameters
}

// TagClientGetEntityStateOptions contains the optional parameters for the TagClient.GetEntityState method.
type TagClientGetEntityStateOptions struct {
	// placeholder for future optional parameters
}

// TagClientGetOptions contains the optional parameters for the TagClient.Get method.
type TagClientGetOptions struct {
	// placeholder for future optional parameters
}

// TagClientListByAPIOptions contains the optional parameters for the TagClient.NewListByAPIPager method.
type TagClientListByAPIOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// TagClientListByOperationOptions contains the optional parameters for the TagClient.NewListByOperationPager method.
type TagClientListByOperationOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// TagClientListByProductOptions contains the optional parameters for the TagClient.NewListByProductPager method.
type TagClientListByProductOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// TagClientListByServiceOptions contains the optional parameters for the TagClient.NewListByServicePager method.
type TagClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Scope like 'apis', 'products' or 'apis/{apiId}
	Scope *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// TagClientUpdateOptions contains the optional parameters for the TagClient.Update method.
type TagClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// TagResourceClientListByServiceOptions contains the optional parameters for the TagResourceClient.NewListByServicePager
// method.
type TagResourceClientListByServiceOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | aid | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | apiName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | apiRevision | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | path | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | serviceUrl | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | method | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | urlTemplate | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | terms | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | state | filter | eq | |
	// | isCurrent | filter | eq | |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// TenantAccessClientCreateOptions contains the optional parameters for the TenantAccessClient.Create method.
type TenantAccessClientCreateOptions struct {
	// placeholder for future optional parameters
}

// TenantAccessClientGetEntityTagOptions contains the optional parameters for the TenantAccessClient.GetEntityTag method.
type TenantAccessClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// TenantAccessClientGetOptions contains the optional parameters for the TenantAccessClient.Get method.
type TenantAccessClientGetOptions struct {
	// placeholder for future optional parameters
}

// TenantAccessClientListByServiceOptions contains the optional parameters for the TenantAccessClient.NewListByServicePager
// method.
type TenantAccessClientListByServiceOptions struct {
	// Not used
	Filter *string
}

// TenantAccessClientListSecretsOptions contains the optional parameters for the TenantAccessClient.ListSecrets method.
type TenantAccessClientListSecretsOptions struct {
	// placeholder for future optional parameters
}

// TenantAccessClientRegeneratePrimaryKeyOptions contains the optional parameters for the TenantAccessClient.RegeneratePrimaryKey
// method.
type TenantAccessClientRegeneratePrimaryKeyOptions struct {
	// placeholder for future optional parameters
}

// TenantAccessClientRegenerateSecondaryKeyOptions contains the optional parameters for the TenantAccessClient.RegenerateSecondaryKey
// method.
type TenantAccessClientRegenerateSecondaryKeyOptions struct {
	// placeholder for future optional parameters
}

// TenantAccessClientUpdateOptions contains the optional parameters for the TenantAccessClient.Update method.
type TenantAccessClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// TenantAccessGitClientRegeneratePrimaryKeyOptions contains the optional parameters for the TenantAccessGitClient.RegeneratePrimaryKey
// method.
type TenantAccessGitClientRegeneratePrimaryKeyOptions struct {
	// placeholder for future optional parameters
}

// TenantAccessGitClientRegenerateSecondaryKeyOptions contains the optional parameters for the TenantAccessGitClient.RegenerateSecondaryKey
// method.
type TenantAccessGitClientRegenerateSecondaryKeyOptions struct {
	// placeholder for future optional parameters
}

// TenantConfigurationClientBeginDeployOptions contains the optional parameters for the TenantConfigurationClient.BeginDeploy
// method.
type TenantConfigurationClientBeginDeployOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TenantConfigurationClientBeginSaveOptions contains the optional parameters for the TenantConfigurationClient.BeginSave
// method.
type TenantConfigurationClientBeginSaveOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TenantConfigurationClientBeginValidateOptions contains the optional parameters for the TenantConfigurationClient.BeginValidate
// method.
type TenantConfigurationClientBeginValidateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TenantConfigurationClientGetSyncStateOptions contains the optional parameters for the TenantConfigurationClient.GetSyncState
// method.
type TenantConfigurationClientGetSyncStateOptions struct {
	// placeholder for future optional parameters
}

// TenantSettingsClientGetOptions contains the optional parameters for the TenantSettingsClient.Get method.
type TenantSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// TenantSettingsClientListByServiceOptions contains the optional parameters for the TenantSettingsClient.NewListByServicePager
// method.
type TenantSettingsClientListByServiceOptions struct {
	// Not used
	Filter *string
}

// UserClientCreateOrUpdateOptions contains the optional parameters for the UserClient.CreateOrUpdate method.
type UserClientCreateOrUpdateOptions struct {
	// ETag of the Entity. Not required when creating an entity, but required when updating an entity.
	IfMatch *string

	// Send an Email notification to the User.
	Notify *bool
}

// UserClientDeleteOptions contains the optional parameters for the UserClient.Delete method.
type UserClientDeleteOptions struct {
	// Determines the type of application which send the create user request. Default is legacy publisher portal.
	AppType *AppType

	// Whether to delete user's subscription or not.
	DeleteSubscriptions *bool

	// Send an Account Closed Email notification to the User.
	Notify *bool
}

// UserClientGenerateSsoURLOptions contains the optional parameters for the UserClient.GenerateSsoURL method.
type UserClientGenerateSsoURLOptions struct {
	// placeholder for future optional parameters
}

// UserClientGetEntityTagOptions contains the optional parameters for the UserClient.GetEntityTag method.
type UserClientGetEntityTagOptions struct {
	// placeholder for future optional parameters
}

// UserClientGetOptions contains the optional parameters for the UserClient.Get method.
type UserClientGetOptions struct {
	// placeholder for future optional parameters
}

// UserClientGetSharedAccessTokenOptions contains the optional parameters for the UserClient.GetSharedAccessToken method.
type UserClientGetSharedAccessTokenOptions struct {
	// placeholder for future optional parameters
}

// UserClientListByServiceOptions contains the optional parameters for the UserClient.NewListByServicePager method.
type UserClientListByServiceOptions struct {
	// Detailed Group in response.
	ExpandGroups *bool

	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|-------------|-------------|-------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | firstName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | lastName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | email | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | state | filter | eq | |
	// | registrationDate | filter | ge, le, eq, ne, gt, lt | |
	// | note | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | groups | expand | | |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// UserClientUpdateOptions contains the optional parameters for the UserClient.Update method.
type UserClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// UserConfirmationPasswordClientSendOptions contains the optional parameters for the UserConfirmationPasswordClient.Send
// method.
type UserConfirmationPasswordClientSendOptions struct {
	// Determines the type of application which send the create user request. Default is legacy publisher portal.
	AppType *AppType
}

// UserGroupClientListOptions contains the optional parameters for the UserGroupClient.NewListPager method.
type UserGroupClientListOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|------------------------|-----------------------------------|
	// | name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// | description | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}

// UserIdentitiesClientListOptions contains the optional parameters for the UserIdentitiesClient.NewListPager method.
type UserIdentitiesClientListOptions struct {
	// placeholder for future optional parameters
}

// UserSubscriptionClientGetOptions contains the optional parameters for the UserSubscriptionClient.Get method.
type UserSubscriptionClientGetOptions struct {
	// placeholder for future optional parameters
}

// UserSubscriptionClientListOptions contains the optional parameters for the UserSubscriptionClient.NewListPager method.
type UserSubscriptionClientListOptions struct {
	// | Field | Usage | Supported operators | Supported functions |
	// |-------------|------------------------|-----------------------------------|
	// |name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// |displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// |stateComment | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// |ownerId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// |scope | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// |userId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	// |productId | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |
	Filter *string

	// Number of records to skip.
	Skip *int32

	// Number of records to return.
	Top *int32
}
