//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armpostgresql_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/postgresql/armpostgresql"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c767823fdfd9d5e96bad245e3ea4d14d94a716bb/specification/postgresql/resource-manager/Microsoft.DBforPostgreSQL/stable/2017-12-01/examples/ConfigurationsUpdateByServer.json
func ExampleServerParametersClient_BeginListUpdateConfigurations() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServerParametersClient().BeginListUpdateConfigurations(ctx, "TestGroup", "testserver", armpostgresql.ConfigurationListResult{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ConfigurationListResult = armpostgresql.ConfigurationListResult{
	// 	Value: []*armpostgresql.Configuration{
	// 		{
	// 			Name: to.Ptr("array_nulls"),
	// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
	// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/array_nulls"),
	// 			Properties: &armpostgresql.ConfigurationProperties{
	// 				Description: to.Ptr("Enable input of NULL elements in arrays."),
	// 				AllowedValues: to.Ptr("on,off"),
	// 				DataType: to.Ptr("Boolean"),
	// 				DefaultValue: to.Ptr("on"),
	// 				Source: to.Ptr("system-default"),
	// 				Value: to.Ptr("on"),
	// 			},
	// 		},
	// 		{
	// 			Name: to.Ptr("backslash_quote"),
	// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
	// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/backslash_quote"),
	// 			Properties: &armpostgresql.ConfigurationProperties{
	// 				Description: to.Ptr("Sets whether \"\\'\" is allowed in string literals."),
	// 				AllowedValues: to.Ptr("safe_encoding,on,off"),
	// 				DataType: to.Ptr("Enumeration"),
	// 				DefaultValue: to.Ptr("safe_encoding"),
	// 				Source: to.Ptr("system-default"),
	// 				Value: to.Ptr("safe_encoding"),
	// 			},
	// 	}},
	// }
}
