//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armvmwarecloudsimple

import "time"

// AvailableOperation - Resource provider available operation model
type AvailableOperation struct {
	// The list of operations
	Display *AvailableOperationDisplay

	// Indicating whether the operation is a data action or not
	IsDataAction *bool

	// {resourceProviderNamespace}/{resourceType}/{read|write|delete|action}
	Name *string

	// The origin of operation
	Origin *OperationOrigin

	// The list of operation properties
	Properties *AvailableOperationDisplayPropertyServiceSpecification
}

// AvailableOperationDisplay - Resource provider available operation display model
type AvailableOperationDisplay struct {
	// Description of the operation for display purposes
	Description *string

	// Name of the operation for display purposes
	Operation *string

	// Name of the provider for display purposes
	Provider *string

	// Name of the resource type for display purposes
	Resource *string
}

// AvailableOperationDisplayPropertyServiceSpecification - Available operation display property service specification model
type AvailableOperationDisplayPropertyServiceSpecification struct {
	// The list of specification's service metrics
	ServiceSpecification *AvailableOperationDisplayPropertyServiceSpecificationMetricsList
}

// AvailableOperationDisplayPropertyServiceSpecificationMetricsItem - Available operation display property service specification
// metrics item
type AvailableOperationDisplayPropertyServiceSpecificationMetricsItem struct {
	// REQUIRED; Metric's aggregation type for e.g. (Average, Total)
	AggregationType *AggregationType

	// REQUIRED; Metric's description
	DisplayDescription *string

	// REQUIRED; Human readable metric's name
	DisplayName *string

	// REQUIRED; Metric's name/id
	Name *string

	// REQUIRED; Metric's unit
	Unit *string
}

// AvailableOperationDisplayPropertyServiceSpecificationMetricsList - List of available operation display property service
// specification metrics
type AvailableOperationDisplayPropertyServiceSpecificationMetricsList struct {
	// Metric specifications of operation
	MetricSpecifications []*AvailableOperationDisplayPropertyServiceSpecificationMetricsItem
}

// AvailableOperationsListResponse - List of available operations
type AvailableOperationsListResponse struct {
	// Link for next list of available operations
	NextLink *string

	// Returns a list of available operations
	Value []*AvailableOperation
}

// CSRPError - General error model
type CSRPError struct {
	// Error's body
	Error *CSRPErrorBody
}

// CSRPErrorBody - Error properties
type CSRPErrorBody struct {
	// Error's target
	Target *string

	// READ-ONLY; Error's code
	Code *string

	// READ-ONLY; Error's details
	Details []*CSRPErrorBody

	// READ-ONLY; Error's message
	Message *string
}

// CustomizationHostName - Host name model
type CustomizationHostName struct {
	// Hostname
	Name *string

	// Type of host name
	Type *CustomizationHostNameType
}

type CustomizationIPAddress struct {
	// Argument when Custom ip type is selected
	Argument *string

	// Defined Ip Address when Fixed ip type is selected
	IPAddress *string

	// Customization Specification ip type
	Type *CustomizationIPAddressType
}

type CustomizationIPSettings struct {
	// The list of gateways
	Gateway []*string

	// Ip address customization settings
	IP *CustomizationIPAddress

	// Adapter subnet mask
	SubnetMask *string
}

type CustomizationIdentity struct {
	// Windows Text Identity. Prepared data
	Data *string

	// Virtual machine host name settings
	HostName *CustomizationHostName

	// Identity type
	Type *CustomizationIdentityType

	// Windows Identity. User data customization
	UserData *CustomizationIdentityUserData
}

// CustomizationIdentityUserData - Windows Identity. User data customization
type CustomizationIdentityUserData struct {
	// Is password predefined in customization policy
	IsPasswordPredefined *bool
}

type CustomizationNicSetting struct {
	// The list of adapters' settings
	Adapter *CustomizationIPSettings

	// NIC mac address
	MacAddress *string
}

// CustomizationPoliciesListResponse - List of customization polices response model
type CustomizationPoliciesListResponse struct {
	// Link for next list of the Customization policy
	NextLink *string

	// List of the customization policies
	Value []*CustomizationPolicy
}

// CustomizationPolicy - The virtual machine customization policy
type CustomizationPolicy struct {
	// Customization policy azure id
	ID *string

	// Azure region
	Location *string

	// Customization Policy properties
	Properties *CustomizationPolicyProperties

	// READ-ONLY; Customization policy name
	Name *string

	// READ-ONLY
	Type *string
}

// CustomizationPolicyProperties - The properties of Customization policy
type CustomizationPolicyProperties struct {
	// Policy description
	Description *string

	// The Private cloud id
	PrivateCloudID *string

	// Detailed customization policy specification
	Specification *CustomizationSpecification

	// The type of customization (Linux or Windows)
	Type *CustomizationPolicyPropertiesType

	// Policy version
	Version *string
}

// CustomizationSpecification - The specification for Customization Policy
type CustomizationSpecification struct {
	// Customization Identity. It contains data about user and hostname
	Identity *CustomizationIdentity

	// Network interface settings
	NicSettings []*CustomizationNicSetting
}

// DedicatedCloudNode - Dedicated cloud node model
type DedicatedCloudNode struct {
	// REQUIRED; Azure region
	Location *string

	// Dedicated Cloud Nodes properties
	Properties *DedicatedCloudNodeProperties

	// Dedicated Cloud Nodes SKU
	SKU *SKU

	// Dedicated Cloud Nodes tags
	Tags map[string]*string

	// READ-ONLY; /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/dedicatedCloudNodes/{dedicatedCloudNodeName}
	ID *string

	// READ-ONLY; {dedicatedCloudNodeName}
	Name *string

	// READ-ONLY; {resourceProviderNamespace}/{resourceType}
	Type *string
}

// DedicatedCloudNodeListResponse - List of dedicated nodes response model
type DedicatedCloudNodeListResponse struct {
	// Link for next list of DedicatedCloudNode
	NextLink *string

	// Results of the DedicatedCloudNode list
	Value []*DedicatedCloudNode
}

// DedicatedCloudNodeProperties - Properties of dedicated cloud node
type DedicatedCloudNodeProperties struct {
	// REQUIRED; Availability Zone id, e.g. "az1"
	AvailabilityZoneID *string

	// REQUIRED; count of nodes to create
	NodesCount *int32

	// REQUIRED; Placement Group id, e.g. "n1"
	PlacementGroupID *string

	// REQUIRED; purchase id
	PurchaseID *string

	// Dedicated Cloud Nodes SKU's description
	SKUDescription *SKUDescription

	// READ-ONLY; Availability Zone name, e.g. "Availability Zone 1"
	AvailabilityZoneName *string

	// READ-ONLY; VMWare Cloud Rack Name
	CloudRackName *string

	// READ-ONLY; date time the resource was created
	Created *time.Time

	// READ-ONLY; Placement Name, e.g. "Placement Group 1"
	PlacementGroupName *string

	// READ-ONLY; Private Cloud Id
	PrivateCloudID *string

	// READ-ONLY; Resource Pool Name
	PrivateCloudName *string

	// READ-ONLY; The provisioning status of the resource
	ProvisioningState *string

	// READ-ONLY; Node status, indicates is private cloud set up on this node or not
	Status *NodeStatus

	// READ-ONLY; VMWare Cluster Name
	VmwareClusterName *string
}

// DedicatedCloudService - Dedicated cloud service model
type DedicatedCloudService struct {
	// REQUIRED; Azure region
	Location *string

	// The properties of Dedicated Node Service
	Properties *DedicatedCloudServiceProperties

	// The list of tags
	Tags map[string]*string

	// READ-ONLY; /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/dedicatedCloudServices/{dedicatedCloudServiceName}
	ID *string

	// READ-ONLY; {dedicatedCloudServiceName}
	Name *string

	// READ-ONLY; {resourceProviderNamespace}/{resourceType}
	Type *string
}

// DedicatedCloudServiceListResponse - List of dedicated cloud services
type DedicatedCloudServiceListResponse struct {
	// Link for next list of DedicatedCloudNode
	NextLink *string

	// Results of the DedicatedCloudService list
	Value []*DedicatedCloudService
}

// DedicatedCloudServiceProperties - Properties of dedicated cloud service
type DedicatedCloudServiceProperties struct {
	// REQUIRED; gateway Subnet for the account. It will collect the subnet address and always treat it as /28
	GatewaySubnet *string

	// READ-ONLY; indicates whether account onboarded or not in a given region
	IsAccountOnboarded *OnboardingStatus

	// READ-ONLY; total nodes purchased
	Nodes *int32

	// READ-ONLY; link to a service management web portal
	ServiceURL *string
}

// GuestOSCustomization - Guest OS Customization properties
type GuestOSCustomization struct {
	// List of dns servers to use
	DNSServers []*string

	// Virtual Machine hostname
	HostName *string

	// Password for login
	Password *string

	// id of customization policy
	PolicyID *string

	// Username for login
	Username *string
}

// GuestOSNICCustomization - Guest OS nic customization
type GuestOSNICCustomization struct {
	// IP address allocation method
	Allocation *GuestOSNICCustomizationAllocation

	// List of dns servers to use
	DNSServers []*string

	// Gateway addresses assigned to nic
	Gateway []*string

	// Static ip address for nic
	IPAddress *string

	// Network mask for nic
	Mask *string

	// primary WINS server for Windows
	PrimaryWinsServer *string

	// secondary WINS server for Windows
	SecondaryWinsServer *string
}

// OperationError - Operation error model
type OperationError struct {
	// Error's code
	Code *string

	// Error's message
	Message *string
}

// OperationResource - Operation status response
type OperationResource struct {
	// Error Message if operation failed
	Error *OperationError

	// READ-ONLY; End time of the operation
	EndTime *time.Time

	// READ-ONLY; Operation Id
	ID *string

	// READ-ONLY; Operation ID
	Name *string

	// READ-ONLY; Start time of the operation
	StartTime *time.Time

	// READ-ONLY; Operation status
	Status *string
}

// PatchPayload - General patch payload modal
type PatchPayload struct {
	// The tags key:value pairs
	Tags map[string]*string
}

// PrivateCloud - Private cloud model
type PrivateCloud struct {
	// Azure Id, e.g. "/subscriptions/4da99247-a172-4ed6-8ae9-ebed2d12f839/providers/Microsoft.VMwareCloudSimple/privateClouds/cloud123"
	ID *string

	// Location where private cloud created, e.g "westus"
	Location *string

	// Private cloud name
	Name *string

	// Private cloud properties
	Properties *PrivateCloudProperties

	// Azure Resource type
	Type *string
}

// PrivateCloudList - List of private clouds
type PrivateCloudList struct {
	// Link for next list of Private Clouds
	NextLink *string

	// the list of private clouds
	Value []*PrivateCloud
}

// PrivateCloudProperties - Properties of private
type PrivateCloudProperties struct {
	// Availability Zone id, e.g. "az1"
	AvailabilityZoneID *string

	// Availability Zone name, e.g. "Availability Zone 1"
	AvailabilityZoneName *string

	// Number of clusters
	ClustersNumber *int32

	// User's emails who created cloud
	CreatedBy *string

	// When private cloud was created
	CreatedOn *time.Time

	// Array of DNS servers
	DNSServers []*string

	// Expiration date of PC
	Expires *string

	// Nsx Type, e.g. "Advanced"
	NsxType *string

	// Placement Group id, e.g. "n1"
	PlacementGroupID *string

	// Placement Group name
	PlacementGroupName *string

	// Id of a private cloud
	PrivateCloudID *string

	// The list of Resource Pools
	ResourcePools []*ResourcePool

	// Private Cloud state, e.g. "operational"
	State *string

	// Number of cores
	TotalCPUCores *int32

	// Number of nodes
	TotalNodes *int32

	// Memory size
	TotalRAM *int32

	// Disk space in TB
	TotalStorage *float32

	// Virtualization type e.g. "vSphere"
	Type *string

	// e.g. "6.5u2"
	VSphereVersion *string

	// FQDN for vcenter access
	VcenterFqdn *string

	// Vcenter ip address
	VcenterRefid *string

	// The list of Virtual Machine Templates
	VirtualMachineTemplates []*VirtualMachineTemplate

	// The list of Virtual Networks
	VirtualNetworks []*VirtualNetwork

	// Is Vrops enabled/disabled
	VrOpsEnabled *bool
}

// ResourcePool - Resource pool model
type ResourcePool struct {
	// REQUIRED; resource pool id (privateCloudId:vsphereId)
	ID *string

	// Resource pool properties
	Properties *ResourcePoolProperties

	// READ-ONLY; Azure region
	Location *string

	// READ-ONLY; {ResourcePoolName}
	Name *string

	// READ-ONLY; The Private Cloud Id
	PrivateCloudID *string

	// READ-ONLY; {resourceProviderNamespace}/{resourceType}
	Type *string
}

// ResourcePoolProperties - Properties of resource pool
type ResourcePoolProperties struct {
	// READ-ONLY; Hierarchical resource pool name
	FullName *string
}

// ResourcePoolsListResponse - List of resource pools response model
type ResourcePoolsListResponse struct {
	// Link for next list of ResourcePoolsList
	NextLink *string

	// Results of the Resource pools list
	Value []*ResourcePool
}

// SKU - The purchase SKU for CloudSimple paid resources
type SKU struct {
	// REQUIRED; The name of the SKU for VMWare CloudSimple Node
	Name *string

	// The capacity of the SKU
	Capacity *string

	// dedicatedCloudNode example: 8 x Ten-Core Intel® Xeon® Processor E5-2640 v4 2.40GHz 25MB Cache (90W); 12 x 64GB PC4-19200
	// 2400MHz DDR4 ECC Registered DIMM, …
	Description *string

	// If the service has different generations of hardware, for the same SKU, then that can be captured here
	Family *string

	// The tier of the SKU
	Tier *string
}

// SKUAvailability - SKU availability model
type SKUAvailability struct {
	// REQUIRED; indicates how many resources of a given SKU is available in a AZ->PG
	Limit *int32

	// CloudSimple Availability Zone id
	DedicatedAvailabilityZoneID *string

	// CloudSimple Availability Zone Name
	DedicatedAvailabilityZoneName *string

	// CloudSimple Placement Group Id
	DedicatedPlacementGroupID *string

	// CloudSimple Placement Group name
	DedicatedPlacementGroupName *string

	// resource type e.g. DedicatedCloudNodes
	ResourceType *string

	// sku id
	SKUID *string

	// sku name
	SKUName *string
}

// SKUAvailabilityListResponse - List of SKU availabilities
type SKUAvailabilityListResponse struct {
	// Link for next list of DedicatedCloudNode
	NextLink *string

	// Results of the DedicatedPlacementGroupSkuAvailability list
	Value []*SKUAvailability
}

// SKUDescription - The purchase SKU for CloudSimple paid resources
type SKUDescription struct {
	// REQUIRED; SKU's id
	ID *string

	// REQUIRED; SKU's name
	Name *string
}

// Usage model
type Usage struct {
	// REQUIRED; The current usage value
	CurrentValue *int32

	// REQUIRED; limit of a given sku in a region for a subscription. The maximum permitted value for the usage quota. If there
	// is no limit, this value will be -1
	Limit *int32

	// Usage name value and localized name
	Name *UsageName

	// The usages' unit
	Unit *UsageCount
}

// UsageListResponse - List of usages
type UsageListResponse struct {
	// Link for next list of DedicatedCloudNode
	NextLink *string

	// READ-ONLY; The list of usages
	Value []*Usage
}

// UsageName - User name model
type UsageName struct {
	// e.g. "Virtual Machines"
	LocalizedValue *string

	// resource type or resource type sku name, e.g. virtualMachines
	Value *string
}

// VirtualDisk - Virtual disk model
type VirtualDisk struct {
	// REQUIRED; Disk's Controller id
	ControllerID *string

	// REQUIRED; Disk's independence mode type
	IndependenceMode *DiskIndependenceMode

	// REQUIRED; Disk's total size
	TotalSize *int32

	// Disk's id
	VirtualDiskID *string

	// READ-ONLY; Disk's display name
	VirtualDiskName *string
}

// VirtualDiskController - Virtual disk controller model
type VirtualDiskController struct {
	// READ-ONLY; Controller's id
	ID *string

	// READ-ONLY; The display name of Controller
	Name *string

	// READ-ONLY; dik controller subtype (VMWAREPARAVIRTUAL, BUSPARALLEL, LSIPARALLEL, LSISAS)
	SubType *string

	// READ-ONLY; disk controller type (SCSI)
	Type *string
}

// VirtualMachine - Virtual machine model
type VirtualMachine struct {
	// REQUIRED; Azure region
	Location *string

	// Virtual machine properties
	Properties *VirtualMachineProperties

	// The list of tags
	Tags map[string]*string

	// READ-ONLY; /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/virtualMachines/{virtualMachineName}
	ID *string

	// READ-ONLY; {virtualMachineName}
	Name *string

	// READ-ONLY; {resourceProviderNamespace}/{resourceType}
	Type *string
}

// VirtualMachineListResponse - List of virtual machines
type VirtualMachineListResponse struct {
	// Link for next list of VirtualMachines
	NextLink *string

	// Results of the VirtualMachine list
	Value []*VirtualMachine
}

// VirtualMachineProperties - Properties of virtual machine
type VirtualMachineProperties struct {
	// REQUIRED; The amount of memory
	AmountOfRAM *int32

	// REQUIRED; The number of CPU cores
	NumberOfCores *int32

	// REQUIRED; Private Cloud Id
	PrivateCloudID *string

	// Virtual machine properties
	Customization *GuestOSCustomization

	// The list of Virtual Disks
	Disks []*VirtualDisk

	// Expose Guest OS or not
	ExposeToGuestVM *bool

	// The list of Virtual NICs
	Nics []*VirtualNic

	// Password for login. Deprecated - use customization property
	Password *string

	// Virtual Machines Resource Pool
	ResourcePool *ResourcePool

	// Virtual Machine Template Id
	TemplateID *string

	// Username for login. Deprecated - use customization property
	Username *string

	// The list of Virtual VSphere Networks
	VSphereNetworks []*string

	// READ-ONLY; The list of Virtual Disks' Controllers
	Controllers []*VirtualDiskController

	// READ-ONLY; The DNS name of Virtual Machine in VCenter
	Dnsname *string

	// READ-ONLY; The path to virtual machine folder in VCenter
	Folder *string

	// READ-ONLY; The name of Guest OS
	GuestOS *string

	// READ-ONLY; The Guest OS type
	GuestOSType *GuestOSType

	// READ-ONLY; The provisioning status of the resource
	ProvisioningState *string

	// READ-ONLY; The public ip of Virtual Machine
	PublicIP *string

	// READ-ONLY; The status of Virtual machine
	Status *VirtualMachineStatus

	// READ-ONLY; The internal id of Virtual Machine in VCenter
	VMID *string

	// READ-ONLY; VMware tools version
	Vmwaretools *string
}

// VirtualMachineStopMode - List of virtual machine stop modes
type VirtualMachineStopMode struct {
	// mode indicates a type of stop operation - reboot, suspend, shutdown or power-off
	Mode *StopMode
}

// VirtualMachineTemplate - Virtual machine template model
type VirtualMachineTemplate struct {
	// Azure region
	Location *string

	// The Virtual Machine Template properties
	Properties *VirtualMachineTemplateProperties

	// READ-ONLY; virtual machine template id (privateCloudId:vsphereId)
	ID *string

	// READ-ONLY; {virtualMachineTemplateName}
	Name *string

	// READ-ONLY; {resourceProviderNamespace}/{resourceType}
	Type *string
}

// VirtualMachineTemplateListResponse - List of virtual machine templates
type VirtualMachineTemplateListResponse struct {
	// Link for next list of VirtualMachineTemplate
	NextLink *string

	// Results of the VM template list
	Value []*VirtualMachineTemplate
}

// VirtualMachineTemplateProperties - Properties of virtual machine template
type VirtualMachineTemplateProperties struct {
	// REQUIRED; The Private Cloud Id
	PrivateCloudID *string

	// The amount of memory
	AmountOfRAM *int32

	// The list of Virtual Disk Controllers
	Controllers []*VirtualDiskController

	// The description of Virtual Machine Template
	Description *string

	// The list of Virtual Disks
	Disks []*VirtualDisk

	// Expose Guest OS or not
	ExposeToGuestVM *bool

	// The list of Virtual NICs
	Nics []*VirtualNic

	// The number of CPU cores
	NumberOfCores *int32

	// path to folder
	Path *string

	// The list of VSphere networks
	VSphereNetworks []*string

	// The tags from VSphere
	VSphereTags []*string

	// READ-ONLY; The Guest OS
	GuestOS *string

	// READ-ONLY; The Guest OS types
	GuestOSType *string

	// READ-ONLY; The VMware tools version
	Vmwaretools *string
}

// VirtualNetwork - Virtual network model
type VirtualNetwork struct {
	// REQUIRED; virtual network id (privateCloudId:vsphereId)
	ID *string

	// Virtual Network properties
	Properties *VirtualNetworkProperties

	// READ-ONLY; can be used in vm creation/deletion
	Assignable *bool

	// READ-ONLY; Azure region
	Location *string

	// READ-ONLY; {VirtualNetworkName}
	Name *string

	// READ-ONLY; {resourceProviderNamespace}/{resourceType}
	Type *string
}

// VirtualNetworkListResponse - List of virtual networks
type VirtualNetworkListResponse struct {
	// Link for next list of VirtualNetwork
	NextLink *string

	// Results of the VirtualNetwork list
	Value []*VirtualNetwork
}

// VirtualNetworkProperties - Properties of virtual network
type VirtualNetworkProperties struct {
	// READ-ONLY; The Private Cloud id
	PrivateCloudID *string
}

// VirtualNic - Virtual NIC model
type VirtualNic struct {
	// REQUIRED; Virtual Network
	Network *VirtualNetwork

	// REQUIRED; NIC type
	NicType *NICType

	// guest OS customization for nic
	Customization *GuestOSNICCustomization

	// NIC ip address
	IPAddresses []*string

	// NIC MAC address
	MacAddress *string

	// Is NIC powered on/off on boot
	PowerOnBoot *bool

	// NIC id
	VirtualNicID *string

	// READ-ONLY; NIC name
	VirtualNicName *string
}
