#ifndef __SOUND_JACK_H
#define __SOUND_JACK_H

/*
 *  Jack abstraction layer
 *
 *  Copyright 2008 Wolfson Microelectronics plc
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */

#include <sound/core.h>

struct input_dev;

/**
 * Jack types which can be reported.  These values are used as a
 * bitmask.
 */
enum snd_jack_types {
	SND_JACK_HEADPHONE	= 0x0001,
	SND_JACK_MICROPHONE	= 0x0002,
	SND_JACK_HEADSET	= SND_JACK_HEADPHONE | SND_JACK_MICROPHONE,
	SND_JACK_LINEOUT	= 0x0004,
	SND_JACK_MECHANICAL	= 0x0008, /* If detected separately */
};

struct snd_jack {
	struct input_dev *input_dev;
	int registered;
	int type;
	const char *id;
	char name[100];
};

#ifdef CONFIG_SND_JACK

int snd_jack_new(struct snd_card *card, const char *id, int type,
		 struct snd_jack **jack);
void snd_jack_set_parent(struct snd_jack *jack, struct device *parent);

void snd_jack_report(struct snd_jack *jack, int status);

#else

static inline int snd_jack_new(struct snd_card *card, const char *id, int type,
			       struct snd_jack **jack)
{
	return 0;
}

static inline void snd_jack_set_parent(struct snd_jack *jack,
				       struct device *parent)
{
}

static inline void snd_jack_report(struct snd_jack *jack, int status)
{
}

#endif

#endif
