set(CMAKE_SYSTEM_NAME Windows)
set(CMAKE_C_COMPILER_FRONTEND_VARIANT GNU)
set(CMAKE_CROSSCOMPILING TRUE)
set(CMAKE_CROSSCOMPILING_EMULATOR wine)

set(CMAKE_C_COMPILER_TARGET armv7-w64-mingw32)
set(CMAKE_CXX_COMPILER_TARGET armv7-w64-mingw32)
set(CMAKE_RC_COMPILER_TARGET armv7-w64-mingw32)
set(CMAKE_SYSTEM_PROCESSOR armv7)

# Required to propagate 'LLVM_MINGW_ROOT' variables to C compiler feature test.
set(CMAKE_TRY_COMPILE_PLATFORM_VARIABLES LLVM_MINGW_ROOT)

if(NOT LLVM_MINGW_ROOT)
    set(LLVM_MINGW_ROOT $ENV{LLVM_MINGW_ROOT})
endif()
cmake_path(CONVERT "${LLVM_MINGW_ROOT}" TO_CMAKE_PATH_LIST LLVM_MINGW_ROOT)

set(CMAKE_FIND_ROOT_PATH ${LLVM_MINGW_ROOT} ${LLVM_MINGW_ROOT}/armv7-w64-mingw32)
set(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM NEVER)
set(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ALWAYS)
set(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)

find_program(C_COMPILER_FULL_PATH ${CMAKE_C_COMPILER_TARGET}-clang HINTS ${LLVM_MINGW_ROOT}/bin)
if(NOT C_COMPILER_FULL_PATH)
message(FATAL_ERROR "Compiler for ${CMAKE_C_COMPILER_TARGET} not found. Try setting llvm-mingw root path to LLVM_MINGW_ROOT variable!")
endif()
set(CMAKE_C_COMPILER ${C_COMPILER_FULL_PATH})

find_program(CXX_COMPILER_FULL_PATH ${CMAKE_CXX_COMPILER_TARGET}-clang++ HINTS ${LLVM_MINGW_ROOT}/bin)
if(CXX_COMPILER_FULL_PATH)
    set(CMAKE_CXX_COMPILER ${CXX_COMPILER_FULL_PATH})
endif()

find_program(RC_COMPILER_FULL_PATH ${CMAKE_RC_COMPILER_TARGET}-windres HINTS ${LLVM_MINGW_ROOT}/bin)
if(RC_COMPILER_FULL_PATH)
    set(CMAKE_RC_COMPILER ${RC_COMPILER_FULL_PATH})
endif()

add_compile_options($<$<COMPILE_LANGUAGE:C,CXX>:-gcodeview>)
add_link_options(-Wl,-pdb=)
