/**
 * \file pappsomspp/processing/cbor/psm/psmfilescanprocess.h
 * \date 12/07/2025
 * \author Olivier Langella
 * \brief PSM file reader designed to parallelize scan process
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/
#pragma once

#include "psmfilereaderbase.h"
#include <QTemporaryDir>
#include <QCborMap>
#include "cborscanmapbase.h"
#include "pappsomspp/export-import-config.h"

namespace pappso
{
namespace cbor
{
namespace psm
{


/**
 * @brief Basic PSM file reader to process scan (parallelized scan processing)
 */
class PMSPP_LIB_DECL PsmFileScanProcess : public PsmFileReaderBase

{
  friend CborScanMapBase;

  public:
  /**
   * Default constructor
   */
  PsmFileScanProcess(std::size_t buffer_scan_size);

  /**
   * Destructor
   */
  virtual ~PsmFileScanProcess();

  protected:
  void readScan(pappso::UiMonitorInterface &monitor) override;
  void scanFinished(pappso::UiMonitorInterface &monitor) override;
  void sampleFinished(pappso::UiMonitorInterface &monitor) override;
  virtual void processBufferScan(pappso::UiMonitorInterface &monitor);
  virtual void processBufferScanDone(pappso::UiMonitorInterface &monitor);
  virtual CborScanMapBase *newCborScanMap() = 0;
  void clearScanBuffer();


  protected:
  std::size_t m_bufferScanSize = 1000;
  std::vector<CborScanMapBase *> m_cborScanList;
};

} // namespace psm
} // namespace cbor
} // namespace pappso
