# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the current operation."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    PROVISIONING = "Provisioning"
    """The resource is being provisioned"""
    UPDATING = "Updating"
    """The resource is updating"""
    DELETING = "Deleting"
    """The resource is being deleted"""
    ACCEPTED = "Accepted"
    """The resource create request has been accepted"""


class PurgeableOrchestrationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Purgeable orchestration state to be used in retention policies."""

    COMPLETED = "Completed"
    """The orchestration is completed"""
    FAILED = "Failed"
    """The orchestration is failed"""
    TERMINATED = "Terminated"
    """The orchestration is terminated"""
    CANCELED = "Canceled"
    """The orchestration is canceled"""


class RedundancyState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the resource redundancy."""

    NONE = "None"
    """The resource is not redundant"""
    ZONE = "Zone"
    """The resource is zone redundant"""


class SchedulerSkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The name of the Stock Keeping Unit (SKU) of a Durable Task Scheduler."""

    DEDICATED = "Dedicated"
    """Dedicated SKU"""
    CONSUMPTION = "Consumption"
    """Consumption SKU"""
