# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.kubernetesconfiguration.privatelinkscopes.aio import KubernetesConfigurationPrivateLinkScopesMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestKubernetesConfigurationPrivateLinkScopesMgmtPrivateLinkScopesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(KubernetesConfigurationPrivateLinkScopesMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_private_link_scopes_list(self, resource_group):
        response = self.client.private_link_scopes.list(
            api_version="2024-11-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_private_link_scopes_list_by_resource_group(self, resource_group):
        response = self.client.private_link_scopes.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-11-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_private_link_scopes_delete(self, resource_group):
        response = await self.client.private_link_scopes.delete(
            resource_group_name=resource_group.name,
            scope_name="str",
            api_version="2024-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_private_link_scopes_get(self, resource_group):
        response = await self.client.private_link_scopes.get(
            resource_group_name=resource_group.name,
            scope_name="str",
            api_version="2024-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_private_link_scopes_create_or_update(self, resource_group):
        response = await self.client.private_link_scopes.create_or_update(
            resource_group_name=resource_group.name,
            scope_name="str",
            parameters={
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "clusterResourceId": "str",
                    "privateEndpointConnections": [
                        {
                            "id": "str",
                            "name": "str",
                            "privateEndpoint": {"id": "str"},
                            "privateLinkServiceConnectionState": {
                                "actionsRequired": "str",
                                "description": "str",
                                "status": "str",
                            },
                            "provisioningState": "str",
                            "systemData": {
                                "createdAt": "2020-02-20 00:00:00",
                                "createdBy": "str",
                                "createdByType": "str",
                                "lastModifiedAt": "2020-02-20 00:00:00",
                                "lastModifiedBy": "str",
                                "lastModifiedByType": "str",
                            },
                            "type": "str",
                        }
                    ],
                    "privateLinkScopeId": "str",
                    "provisioningState": "str",
                    "publicNetworkAccess": "Disabled",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2024-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_private_link_scopes_update_tags(self, resource_group):
        response = await self.client.private_link_scopes.update_tags(
            resource_group_name=resource_group.name,
            scope_name="str",
            private_link_scope_tags={"tags": {"str": "str"}},
            api_version="2024-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...
