% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_3comp.R
\name{simulate_3comp}
\alias{simulate_3comp}
\title{Function to simulate three-component mixed cell line test data}
\usage{
simulate_3comp(
  G1 = 675,
  G2 = 25,
  My = 20,
  M1 = 100,
  M2 = 100,
  output.more.info = FALSE
)
}
\arguments{
\item{G1}{Number of genes, where \eqn{\mu_{N1}} is close to \eqn{\mu_{N2}}.}

\item{G2}{Number of genes, where \eqn{\mu_{N1}} is not close to \eqn{\mu_{N2}}.}

\item{My}{Number of mixture tumor samples for simulation.}

\item{M1}{Number of first known reference for simulation.}

\item{M2}{Number of second known reference for simulation.}

\item{output.more.info}{The logical flag indicating wheter to show True.data.T,
True.data.N1 and True.data.N2 in the output. The default is FALSE.}
}
\value{
\item{pi}{A matrix of estimated proportion. First row and second row 
corresponds to the proportion estimate for the known components and unkown 
component respectively for two or three component settings. Each column 
corresponds to one sample.}
\item{Mu}{Simulated \eqn{Mu} of log2-normal distribution for both known
(\eqn{MuN1, MuN2}) and unknown component (\eqn{MuT}).}
\item{Sigma}{Simulated \eqn{Sigma} of log2-normal distribution for both 
known (\eqn{SigmaN1, SigmaN2}) and unknown component
 (\eqn{SigmaT}).}
\item{data.Y}{A SummarizedExperiment object of simulated expression data 
from mixed tumor samples. It is a \eqn{G} by \eqn{My} matrix where \eqn{G}
is the number of genes and \eqn{My} is the number of mixed samples. 
Samples with the same tissue type should be placed together in columns.}
\item{data.N1}{A SummarizedExperiment object of simulated expression data 
from reference component 1 (e.g., normal). It is a \eqn{G} by \eqn{M1} matrix 
where \eqn{G} is the number of genes and \eqn{M1} is the number of samples 
for component 1.}
\item{data.N2}{A SummarizedExperiment object of expression data from
additional reference samples. It is a \eqn{G} by \eqn{M2} matrix where 
\eqn{G} is the number of genes and \eqn{M2} is the number of samples for
component 2.}
\item{True.data.T}{A SummarizedExperiment object of simulated tumor expression 
data. It is a \eqn{G} by \eqn{My} matrix, where \eqn{G} is the number of 
genes and \eqn{My} is the number of mixed samples.This is enabled only when 
output.more.info = TRUE.}
\item{True.data.N1}{A SummarizedExperiment object of simulated true 
expression data for reference component 1 (e.g., stroma). It is a \eqn{G} 
by \eqn{M1} matrix where \eqn{G} is the number of genes and \eqn{M1} is the 
number of samples for component 1. This is enabled only when 
output.more.info = TRUE.}
\item{True.data.N2}{A SummarizedExperiment object of simulated true 
expression data for reference component 2 (e.g., immue). It is a \eqn{G} 
by \eqn{M2} matrix where \eqn{G} is the number of genes and \eqn{M2} is the 
number of samples for component 2. This is enabled only when 
output.more.info = TRUE.}
}
\description{
Function to simulate three-component mixed cell line test 
data used in DeMixT function.
}
\examples{
test.data = simulate_3comp(G1 = 675, G2 = 25, My = 20, M1 = 100, M2 = 100)
test.data$pi
test.data$Mu
test.data$Sigma
}
\keyword{simulate_3comp}
