% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/SingleCellExperiment-methods.R
\docType{methods}
\name{norm_exprs}
\alias{norm_exprs}
\alias{norm_exprs<-}
\alias{stand_exprs}
\alias{stand_exprs<-}
\alias{fpkm}
\alias{fpkm<-}
\alias{exprs}
\alias{exprs,SingleCellExperiment-method,}
\alias{exprs<-,SingleCellExperiment,ANY-method}
\alias{norm_exprs,SingleCellExperiment-method}
\alias{norm_exprs<-,SingleCellExperiment,ANY-method}
\alias{stand_exprs,SingleCellExperiment-method,}
\alias{stand_exprs<-,SingleCellExperiment,ANY-method}
\alias{fpkm,SingleCellExperiment-method}
\alias{fpkm<-,SingleCellExperiment,ANY-method}
\title{Additional accessors for the typical elements of a SingleCellExperiment object.}
\usage{
norm_exprs(object)

norm_exprs(object) <- value

stand_exprs(object)

stand_exprs(object) <- value

fpkm(object)

fpkm(object) <- value
}
\arguments{
\item{object}{\code{SingleCellExperiment} class object from which to access or to 
which to assign assay values. Namely: "exprs", norm_exprs", "stand_exprs", "fpkm".
The following are imported from \code{\link{SingleCellExperiment}}: "counts",
"normcounts", "logcounts", "cpm", "tpm".}

\item{value}{a numeric matrix (e.g. for \code{exprs})}
}
\value{
a matrix of normalised expression data

a matrix of standardised expressiond data

a matrix of FPKM values

A matrix of numeric, integer or logical values.
}
\description{
Convenience functions to access commonly-used assays of the 
\code{\link{SingleCellExperiment}} object.
}
\examples{
example_sce <- mockSCE()
example_sce <- logNormCounts(example_sce)
head(logcounts(example_sce)[,1:10])
head(exprs(example_sce)[,1:10]) # identical to logcounts()

norm_exprs(example_sce) <- log2(calculateCPM(example_sce) + 1)

stand_exprs(example_sce) <- log2(calculateCPM(example_sce) + 1)

tpm(example_sce) <- calculateTPM(example_sce, lengths = 5e4)

cpm(example_sce) <- calculateCPM(example_sce)

fpkm(example_sce)
}
\author{
Davis McCarthy
}
