% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HoltWintersNew.R
\name{ses}
\alias{ses}
\alias{holt}
\alias{hw}
\title{Exponential smoothing forecasts}
\usage{
ses(
  y,
  h = 10,
  level = c(80, 95),
  fan = FALSE,
  initial = c("optimal", "simple"),
  alpha = NULL,
  lambda = NULL,
  biasadj = FALSE,
  x = y,
  ...
)

holt(
  y,
  h = 10,
  damped = FALSE,
  level = c(80, 95),
  fan = FALSE,
  initial = c("optimal", "simple"),
  exponential = FALSE,
  alpha = NULL,
  beta = NULL,
  phi = NULL,
  lambda = NULL,
  biasadj = FALSE,
  x = y,
  ...
)

hw(
  y,
  h = 2 * frequency(x),
  seasonal = c("additive", "multiplicative"),
  damped = FALSE,
  level = c(80, 95),
  fan = FALSE,
  initial = c("optimal", "simple"),
  exponential = FALSE,
  alpha = NULL,
  beta = NULL,
  gamma = NULL,
  phi = NULL,
  lambda = NULL,
  biasadj = FALSE,
  x = y,
  ...
)
}
\arguments{
\item{y}{a numeric vector or univariate time series of class \code{ts}}

\item{h}{Number of periods for forecasting. Default value is twice the
largest seasonal period (for seasonal data) or ten (for non-seasonal data).}

\item{level}{Confidence levels for prediction intervals.}

\item{fan}{If \code{TRUE}, \code{level} is set to \code{seq(51, 99, by = 3)}.
This is suitable for fan plots.}

\item{initial}{Method used for selecting initial state values. If
\code{optimal}, the initial values are optimized along with the smoothing
parameters using \code{\link[=ets]{ets()}}. If \code{simple}, the initial values are
set to values obtained using simple calculations on the first few
observations. See Hyndman & Athanasopoulos (2014) for details.}

\item{alpha}{Value of smoothing parameter for the level. If \code{NULL}, it
will be estimated.}

\item{lambda}{Box-Cox transformation parameter. If \code{lambda = "auto"},
then a transformation is automatically selected using \code{BoxCox.lambda}.
The transformation is ignored if NULL. Otherwise,
data transformed before model is estimated.}

\item{biasadj}{Use adjusted back-transformed mean for Box-Cox
transformations. If transformed data is used to produce forecasts and fitted
values, a regular back transformation will result in median forecasts. If
biasadj is \code{TRUE}, an adjustment will be made to produce mean forecasts
and fitted values.}

\item{x}{Deprecated. Included for backwards compatibility.}

\item{...}{Other arguments passed to \code{forecast.ets}.}

\item{damped}{If \code{TRUE}, use a damped trend.}

\item{exponential}{If \code{TRUE}, an exponential trend is fitted.
Otherwise, the trend is (locally) linear.}

\item{beta}{Value of smoothing parameter for the trend. If \code{NULL}, it
will be estimated.}

\item{phi}{Value of damping parameter if \code{damped = TRUE}. If \code{NULL},
it will be estimated.}

\item{seasonal}{Type of seasonality in \code{hw} model. \code{"additive"} or
\code{"multiplicative"}.}

\item{gamma}{Value of smoothing parameter for the seasonal component. If
\code{NULL}, it will be estimated.}
}
\value{
An object of class \code{forecast}.
}
\description{
Returns forecasts and other information for exponential smoothing forecasts
applied to \code{y}.
}
\details{
ses, holt and hw are simply convenient wrapper functions for
\code{forecast(ets(...))}.
}
\section{forecast class}{

An object of class \code{forecast} is a list usually containing at least
the following elements:
\describe{
\item{model}{A list containing information about the fitted model}
\item{method}{The name of the forecasting method as a character string}
\item{mean}{Point forecasts as a time series}
\item{lower}{Lower limits for prediction intervals}
\item{upper}{Upper limits for prediction intervals}
\item{level}{The confidence values associated with the prediction intervals}
\item{x}{The original time series.}
\item{residuals}{Residuals from the fitted model. For models with additive
errors, the residuals will be x minus the fitted values.}
\item{fitted}{Fitted values (one-step forecasts)}
}
The function \code{summary} can be used to obtain and print a summary of the
results, while the functions \code{plot} and \code{autoplot} produce plots of the forecasts and
prediction intervals. The generic accessors functions \code{fitted.values} and \code{residuals}
extract various useful features from the underlying model.
}

\examples{

fcast <- holt(airmiles)
plot(fcast)
deaths.fcast <- hw(USAccDeaths, h = 48)
plot(deaths.fcast)

}
\references{
Hyndman, R.J., Koehler, A.B., Ord, J.K., Snyder, R.D. (2008)
\emph{Forecasting with exponential smoothing: the state space approach},
Springer-Verlag: New York. \url{https://robjhyndman.com/expsmooth/}.

Hyndman and Athanasopoulos (2018) \emph{Forecasting: principles
and practice}, 2nd edition, OTexts: Melbourne, Australia.
\url{https://otexts.com/fpp2/}
}
\seealso{
\code{\link[=ets]{ets()}}, \code{\link[stats:HoltWinters]{stats::HoltWinters()}}, \code{\link[=rwf]{rwf()}}, \code{\link[stats:arima]{stats::arima()}}.
}
\author{
Rob J Hyndman
}
\keyword{ts}
