% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snptest_sample.R
\name{snptest_sample}
\alias{snptest_sample}
\title{A utility to generate SNPTEST sample file}
\usage{
snptest_sample(
  data,
  sample_file = "snptest.sample",
  ID_1 = "ID_1",
  ID_2 = "ID_2",
  missing = "missing",
  C = NULL,
  D = NULL,
  P = NULL
)
}
\arguments{
\item{data}{Data to be used.}

\item{sample_file}{Output filename.}

\item{ID_1}{ID_1 as in the sample file.}

\item{ID_2}{ID_2 as in the sample file.}

\item{missing}{Missing data column.}

\item{C}{Continuous variables.}

\item{D}{Discrete variables.}

\item{P}{Phenotypic variables.}
}
\value{
Output file in SNPTEST's sample format.
}
\description{
A utility to generate SNPTEST sample file
}
\examples{
\dontrun{
d <- data.frame(ID_1=1,ID_2=1,missing=0,PC1=1,PC2=2,D1=1,P1=10)
snptest_sample(d,C=paste0("PC",1:2),D=paste0("D",1:1),P=paste0("P",1:1))
}
}
