% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-summaries.R
\name{modal_category}
\alias{modal_category}
\alias{modal_category.default}
\alias{modal_category.rvar}
\title{Modal category}
\usage{
modal_category(x)

\method{modal_category}{default}(x)

\method{modal_category}{rvar}(x)
}
\arguments{
\item{x}{(multiple options) A vector to be interpreted as draws from
a categorical distribution, such as:
\itemize{
\item A \link{factor}
\item A \link{numeric} (should be \link{integer} or integer-like)
\item An \link{rvar}, \link{rvar_factor}, or \link{rvar_ordered}
}}
}
\value{
If \code{x} is a \link{factor} or \link{numeric}, returns a length-1 vector containing
the modal value.

If \code{x} is an \link{rvar}, returns an array of the same shape as \code{x}, where each
cell is the modal value of the draws in the corresponding cell of \code{x}.
}
\description{
Modal category of a vector.
}
\details{
Finds the modal category (i.e., most frequent value) in \code{x}. In the case of
ties, returns the first tie.
}
\examples{
x <- factor(c("a","b","b","c","d"))
modal_category(x)

# in the case of ties, the first tie is returned
y <- factor(c("a","c","c","d","d"))
modal_category(y)

# both together, as an rvar
xy <- c(rvar(x), rvar(y))
xy
modal_category(xy)
}
