% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvar-math.R
\name{rvar-matmult}
\alias{rvar-matmult}
\alias{\%**\%}
\alias{matrixOps.rvar}
\title{Matrix multiplication of random variables}
\usage{
x \%**\% y

\method{matrixOps}{rvar}(x, y)
}
\arguments{
\item{x}{(multiple options) The object to be postmultiplied by \code{y}:
\itemize{
\item An \code{\link{rvar}}
\item A \code{\link{numeric}} vector or matrix
\item A \code{\link{logical}} vector or matrix
}

If a vector is used, it is treated as a \emph{row} vector.}

\item{y}{(multiple options) The object to be premultiplied by \code{x}:
\itemize{
\item An \code{\link{rvar}}
\item A \code{\link{numeric}} vector or matrix
\item A \code{\link{logical}} vector or matrix
}

If a vector is used, it is treated as a \emph{column} vector.}
}
\value{
An \code{\link{rvar}} representing the matrix product of \code{x} and \code{y}.
}
\description{
Matrix multiplication of random variables.
}
\details{
If \code{x} or \code{y} are vectors, they are converted into matrices prior to multiplication, with \code{x}
converted to a row vector and \code{y} to a column vector. Numerics and logicals can be multiplied
by \code{\link{rvar}}s and are broadcasted across all draws of the \code{\link{rvar}} argument. Tensor multiplication
is used to efficiently multiply matrices across draws, so if either \code{x} or \code{y} is an \code{\link{rvar}},
\code{x \%**\% y} will be much faster than \code{rdo(x \%*\% y)}.

In R >= 4.3, you can also use \code{\%*\%} in place of \verb{\%**\%} for matrix multiplication
of \code{\link{rvar}}s. In R < 4.3, S3 classes cannot properly override \code{\%*\%}, so
you must use \verb{\%**\%} for matrix multiplication of \code{\link{rvar}}s.
}
\examples{

# d has mu (mean vector of length 3) and Sigma (3x3 covariance matrix)
d <- as_draws_rvars(example_draws("multi_normal"))
d$Sigma

# trivial example: multiplication by a non-random matrix
d$Sigma \%**\% diag(1:3)

# Decompose Sigma into R s.t. R'R = Sigma ...
R <- chol(d$Sigma)
# ... and recreate Sigma using matrix multiplication
t(R) \%**\% R

}
