# 2025-03-18 Triage Log

A relatively busy week with a large amount of regressions in rollups which made investigations more tricky. Luckily overall the week was an improvement due to some medium sized improvements through improving target feature computation and a type systems internals fix.

Triage done by **@rylev**.
Revision range: [9fb94b32..493c38ba](https://perf.rust-lang.org/?start=9fb94b32df38073bf63d009df77ed10cb1c989d0&end=493c38ba371929579fe136df26eccd9516347c7a&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.7%  | [0.2%, 3.0%]    | 18    |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.2%, 2.7%]    | 37    |
| Improvements ✅ <br /> (primary)   | -1.0% | [-10.3%, -0.2%] | 157   |
| Improvements ✅ <br /> (secondary) | -1.7% | [-8.8%, -0.2%]  | 158   |
| All ❌✅ (primary)                 | -0.8% | [-10.3%, 3.0%]  | 175   |


5 Regressions, 5 Improvements, 3 Mixed; 5 of them in rollups
44 artifact comparisons made in total

#### Regressions

Reduce formatting `width` and `precision` to 16 bits [#136932](https://github.com/rust-lang/rust/pull/136932) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=90384941aae4ea38de00e4702b50757e9b882a19&end=374ce1f90951b4dd1c8789c6a5905abe8ea99ef8&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.4%, 0.5%] | 3     |
| Regressions ❌ <br /> (secondary)  | 1.2% | [1.2%, 1.2%] | 1     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.4%, 0.5%] | 3     |
- Not sure the perf regression is necessarily worth investigating - this only impacts exa which I imagine does do quite a bit of formatting. If this were really an issue I'd expect it to show up in more crates given that it impacts the std lib directly.


Remove `NtItem` and `NtStmt` [#138083](https://github.com/rust-lang/rust/pull/138083) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0998d4095b0f11061f78a3f9c77a87838a4c1cb7&end=aaa2d47daebb02454fc7c08c04c3c603d5efeedb&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.2% | [0.2%, 3.1%] | 14    |
| Regressions ❌ <br /> (secondary)  | 0.2% | [0.2%, 0.2%] | 1     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 2.2% | [0.2%, 3.1%] | 14    |
- Author and reviewer [agree](https://github.com/rust-lang/rust/pull/138083#issuecomment-2706183798) to tackle perf once the full refactor is done.


Add a .bss-like scheme for encoded const allocs [#137152](https://github.com/rust-lang/rust/pull/137152) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=93257e2d20809d82d1bc0fcc1942480d1a66d7cd&end=52daa7d835e7ff51cb387340082bf9a59b949738&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 3.5% | [3.2%, 4.1%] | 3     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |
- Author and reviewer [agree](https://github.com/rust-lang/rust/pull/137152#issuecomment-2666907180) that the perf tradeoff is worth it.


Rollup of 16 pull requests [#138548](https://github.com/rust-lang/rust/pull/138548) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9f274ba3997030a2b7656755a6810fd26cb709f3&end=66678e68227913a42438afc7320a2849dffd4d51&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.2%, 1.0%] | 8     |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.2%, 0.9%] | 14    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.2%, 1.0%] | 8     |
- It's not clear to me which PR could be the culprit. Instead of wasting a bunch of perf time trying to find out, I think it's fine if we cut our losses.


Rollup of 7 pull requests [#138611](https://github.com/rust-lang/rust/pull/138611) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8279176ccdfd4eebd40a671f75b6d3024ae56b42&end=43a2e9d2c72db101f5fedac8b3acb78981b06bf2&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.3%, 0.3%] | 3     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.3%, 0.3%] | 3     |
- The regression is small enough that I don't think this is really worth looking into.


#### Improvements

Speed up target feature computation [#137586](https://github.com/rust-lang/rust/pull/137586) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=705421b52239d7393b4738764b192179d5c139c2&end=ebf0cf75d368c035f4c7e7246d203bd469ee4a51&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.3% | [-9.9%, -0.2%] | 55    |
| Improvements ✅ <br /> (secondary) | -1.8% | [-8.4%, -0.1%] | 122   |
| All ❌✅ (primary)                 | -1.3% | [-9.9%, -0.2%] | 55    |


Add `#[define_opaques]` attribute and require it for all type-alias-impl-trait sites that register a hidden type [#128440](https://github.com/rust-lang/rust/pull/128440) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f2d69d5a7c04617d122facd0a7a5bdde0af928ae&end=6650252439d4e03368b305c42a10006e36f1545e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.6%, -0.2%] | 58    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.4%, -0.4%] | 3     |
| All ❌✅ (primary)                 | -0.5% | [-1.6%, -0.2%] | 58    |


Do not register `Self: AutoTrait` when confirming auto trait (in old solver) [#138249](https://github.com/rust-lang/rust/pull/138249) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8536f201ffdb2c24925d7f9e87996d7dca93428b&end=961351c76c812e3aeb65bfb542742500a6436aed&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.8% | [-5.2%, -0.2%] | 21    |
| Improvements ✅ <br /> (secondary) | -1.5% | [-4.3%, -0.3%] | 4     |
| All ❌✅ (primary)                 | -1.8% | [-5.2%, -0.2%] | 21    |


Rollup of 9 pull requests [#138506](https://github.com/rust-lang/rust/pull/138506) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=cb50d4d8566b1ee97e9a5ef95a37a40936a62c30&end=ecade534c66478c51c5d3c1d3682dc4beb0ac972&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -2.1% | [-2.1%, -2.1%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary)                 | -2.1% | [-2.1%, -2.1%] | 1     |


Rollup of 7 pull requests [#138630](https://github.com/rust-lang/rust/pull/138630) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=493c38ba371929579fe136df26eccd9516347c7a&end=259fdb521200c9abba547302fc2c826479ef26b2&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.1% | [-0.2%, -0.1%] | 5     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.7%, -0.2%] | 4     |
| All ❌✅ (primary)                 | -0.1% | [-0.2%, -0.1%] | 5     |


#### Mixed

Allow bounds checks when enumerating `IndexSlice` to be elided [#137795](https://github.com/rust-lang/rust/pull/137795) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c6251023208f7e9789602376909af8aaf09483b7&end=d2b52c5c48ea024fc277feddcc92a60cc92be13c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.4%, 0.4%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.2%] | 8     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.2%] | 8     |
- As the [reviewer stated](https://github.com/rust-lang/rust/pull/137795#pullrequestreview-2667416001) this is more an improvement than a regression.


Rollup of 7 pull requests [#138414](https://github.com/rust-lang/rust/pull/138414) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=aaa2d47daebb02454fc7c08c04c3c603d5efeedb&end=249cb84316401daf040832cdbb8a45e0f5ab6af8&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 1.1%]   | 19    |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.2%, 1.1%]   | 32    |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.7%, -0.2%] | 24    |
| All ❌✅ (primary)                 | 0.4%  | [-0.2%, 1.1%]  | 21    |
- [#137701](https://github.com/rust-lang/rust/pull/137701) is responsible for the regression. The author and reviewer have been asked for next steps.


Allow more top-down inlining for single-BB callees [#138157](https://github.com/rust-lang/rust/pull/138157) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=addae0705c7cf5b2f2ed7faeec026c894f497b3d&end=523c507d260c6f4391a5041f084528f5fa670312&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0%  | [0.5%, 1.4%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-1.1%, -0.4%] | 5     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.7%, -0.6%] | 3     |
| All ❌✅ (primary)                 | -0.2% | [-1.1%, 1.4%]  | 7     |
- [Author notes](https://github.com/rust-lang/rust/pull/138157#issuecomment-2712124218) that the this does regress icount but walltime should be unaffected or even improved. 

