// generated by diplomat-tool
import { DataError } from "./DataError.mjs"
import { DataProvider } from "./DataProvider.mjs"
import { TimeZone } from "./TimeZone.mjs"
import { TimeZoneIterator } from "./TimeZoneIterator.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * A mapper between IANA time zone identifiers and BCP-47 time zone identifiers.
 *
 * This mapper supports two-way mapping, but it is optimized for the case of IANA to BCP-47.
 * It also supports normalizing and canonicalizing the IANA strings.
 *
 * See the [Rust documentation for `IanaParser`](https://docs.rs/icu/latest/icu/time/zone/iana/struct.IanaParser.html) for more information.
 */
const IanaParser_box_destroy_registry = new FinalizationRegistry((ptr) => {
    wasm.icu4x_IanaParser_destroy_mv1(ptr);
});

export class IanaParser {
    // Internal ptr reference:
    #ptr = null;

    // Lifetimes are only to keep dependencies alive.
    // Since JS won't garbage collect until there are no incoming edges.
    #selfEdge = [];

    #internalConstructor(symbol, ptr, selfEdge) {
        if (symbol !== diplomatRuntime.internalConstructor) {
            console.error("IanaParser is an Opaque type. You cannot call its constructor.");
            return;
        }
        this.#ptr = ptr;
        this.#selfEdge = selfEdge;

        // Are we being borrowed? If not, we can register.
        if (this.#selfEdge.length === 0) {
            IanaParser_box_destroy_registry.register(this, this.#ptr);
        }

        return this;
    }
    get ffiValue() {
        return this.#ptr;
    }


    /**
     * Create a new [`IanaParser`] using compiled data
     *
     * See the [Rust documentation for `new`](https://docs.rs/icu/latest/icu/time/zone/iana/struct.IanaParser.html#method.new) for more information.
     */
    #defaultConstructor() {

        const result = wasm.icu4x_IanaParser_create_mv1();

        try {
            return new IanaParser(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
        }
    }

    /**
     * Create a new [`IanaParser`] using a particular data source
     *
     * See the [Rust documentation for `new`](https://docs.rs/icu/latest/icu/time/zone/iana/struct.IanaParser.html#method.new) for more information.
     */
    static createWithProvider(provider) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_IanaParser_create_with_provider_mv1(diplomatReceive.buffer, provider.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DataError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DataError: ' + cause.value, { cause });
            }
            return new IanaParser(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * See the [Rust documentation for `parse`](https://docs.rs/icu/latest/icu/time/zone/iana/struct.IanaParserBorrowed.html#method.parse) for more information.
     */
    parse(value) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        const valueSlice = diplomatRuntime.DiplomatBuf.str8(wasm, value);

        const result = wasm.icu4x_IanaParser_parse_mv1(this.ffiValue, ...valueSlice.splat());

        try {
            return new TimeZone(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
            functionCleanupArena.free();

        }
    }

    /**
     * See the [Rust documentation for `iter`](https://docs.rs/icu/latest/icu/time/zone/iana/struct.IanaParserBorrowed.html#method.iter) for more information.
     */
    iter() {
        // This lifetime edge depends on lifetimes 'a
        let aEdges = [this];


        const result = wasm.icu4x_IanaParser_iter_mv1(this.ffiValue);

        try {
            return new TimeZoneIterator(diplomatRuntime.internalConstructor, result, [], aEdges);
        }

        finally {
        }
    }

    constructor() {
        if (arguments[0] === diplomatRuntime.exposeConstructor) {
            return this.#internalConstructor(...Array.prototype.slice.call(arguments, 1));
        } else if (arguments[0] === diplomatRuntime.internalConstructor) {
            return this.#internalConstructor(...arguments);
        } else {
            return this.#defaultConstructor(...arguments);
        }
    }
}