/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.api.Benchmark;
import com.google.caliper.runner.BenchmarkClass;
import com.google.caliper.runner.BenchmarkMethod;
import com.google.caliper.runner.CaliperRc;
import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.runner.InvalidInstrumentException;
import com.google.caliper.runner.UserCodeException;
import com.google.caliper.util.InvalidCommandException;
import com.google.caliper.util.ShortDuration;
import com.google.caliper.util.Util;
import com.google.caliper.worker.Worker;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;

public abstract class Instrument {
    protected ImmutableMap<String, String> options;

    static Instrument createInstrument(String instrumentName, CaliperRc rc) throws InvalidCommandException, UserCodeException {
        String instrumentClassName = rc.instrumentClassName(instrumentName);
        try {
            Class<?> someClass = Util.lenientClassForName(instrumentClassName);
            Class<Instrument> instrumentClass = someClass.asSubclass(Instrument.class);
            Constructor<Instrument> instrumentConstr = instrumentClass.getDeclaredConstructor(new Class[0]);
            instrumentConstr.setAccessible(true);
            Instrument instrument = instrumentConstr.newInstance(new Object[0]);
            instrument.setOptions((Map<String, String>)rc.instrumentOptions(instrumentName));
            return instrument;
        }
        catch (ClassNotFoundException e) {
            throw new InvalidCommandException("Invalid instrument '%s'; cannot find class '%s'", instrumentName, instrumentClassName);
        }
        catch (ClassCastException e) {
            throw new InvalidInstrumentException("Instrument class '%s' does not implement Instrument", instrumentClassName);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidInstrumentException("Instrument class '%s' has no parameterless constructor", instrumentClassName);
        }
        catch (InstantiationException e) {
            throw new InvalidInstrumentException("Instrument class '%s' couldn't be constructed", instrumentClassName);
        }
        catch (InvocationTargetException e) {
            throw new UserCodeException("An exception was thrown when constructing the instrument", e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected void setOptions(Map<String, String> options) {
        this.options = ImmutableMap.copyOf(options);
    }

    public ShortDuration estimateRuntimePerTrial() {
        throw new UnsupportedOperationException();
    }

    public abstract boolean isBenchmarkMethod(Method var1);

    public abstract BenchmarkMethod createBenchmarkMethod(BenchmarkClass var1, Method var2) throws InvalidBenchmarkException;

    public abstract void dryRun(Benchmark var1, BenchmarkMethod var2) throws UserCodeException;

    public Map<String, String> workerOptions() {
        return this.options;
    }

    public abstract Class<? extends Worker> workerClass();

    Iterable<String> getExtraCommandLineArgs() {
        return ImmutableList.of();
    }

    public static boolean isTimeMethod(Method method) {
        return method.getName().startsWith("time") && Util.isPublic(method);
    }

    public static BenchmarkMethod createBenchmarkMethodFromTimeMethod(BenchmarkClass benchmarkClass, Method timeMethod) throws InvalidBenchmarkException {
        Preconditions.checkArgument((boolean)Instrument.isTimeMethod(timeMethod));
        if (!Arrays.equals(timeMethod.getParameterTypes(), new Class[]{Integer.TYPE})) {
            throw new InvalidBenchmarkException("Microbenchmark methods must accept a single int parameter: " + timeMethod.getName(), new Object[0]);
        }
        if (Util.isStatic(timeMethod)) {
            throw new InvalidBenchmarkException("Microbenchmark methods must not be static: " + timeMethod.getName(), new Object[0]);
        }
        String methodName = timeMethod.getName();
        String shortName = methodName.substring("time".length());
        return new BenchmarkMethod(benchmarkClass, timeMethod, shortName);
    }
}

