% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExhaustiveParam.R
\docType{class}
\name{ExhaustiveParam}
\alias{ExhaustiveParam}
\alias{ExhaustiveParam-class}
\alias{ExhaustiveIndex}
\alias{ExhaustiveIndex-class}
\alias{defineBuilder,ExhaustiveParam-method}
\title{The ExhaustiveParam class}
\usage{
ExhaustiveParam(distance = c("Euclidean", "Manhattan", "Cosine"))

\S4method{defineBuilder}{ExhaustiveParam}(BNPARAM)
}
\arguments{
\item{distance}{String specifying the distance metric to use.
Cosine distances are implemented as Euclidean distances on L2-normalized coordinates.}

\item{BNPARAM}{An ExhaustiveParam instance.}
}
\value{
The \code{ExhaustiveParam} constructor returns an instance of the ExhaustiveParam class.

The \code{\link{defineBuilder}} method returns an external pointer that can be used in \code{\link{buildIndex}} to construct an exhaustive index.
}
\description{
A class to hold parameters for the exhaustive algorithm for exact nearest neighbor identification.
}
\details{
The exhaustive search computes all pairwise distances between data and query points to identify nearest neighbors of the latter.
It has quadratic complexity and is theoretically the worst-performing method;
however, it has effectively no overhead from constructing or querying indexing structures, 
making it faster for in situations where indexing provides little benefit.
This includes queries against datasets with few data points or very high dimensionality.

All that said, this algorithm is largely provided as a baseline for comparing against the other algorithms.
}
\examples{
(out <- ExhaustiveParam())

}
\seealso{
\linkS4class{BiocNeighborParam}, for the parent class and its available methods.
}
\author{
Allison Vuong
}
