% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMethods.R
\name{getFactors}
\alias{getFactors}
\title{getFactors}
\usage{
getFactors(object, factors = "all", as.data.frame = FALSE)
}
\arguments{
\item{object}{a trained \code{\link{MOFAmodel}} object.}

\item{factors}{character vector with the factor name(s), or numeric vector with the factor index(es).
Default is "all".}

\item{as.data.frame}{logical indicating whether to return a long data frame instead of a matrix.
Default is \code{FALSE}.}
}
\value{
By default it returns the latent factor matrix of dimensionality (N,K),
 where N is number of samples and K is number of factors. \cr
Alternatively, if \code{as.data.frame} is \code{TRUE},
 returns a long-formatted data frame with columns (sample,factor,value).
}
\description{
Extract the latent factors from the model.
}
\examples{
# load a trained MOFAmodel object
filepath <- system.file("extdata", "CLL_model.hdf5", package = "MOFAdata")
MOFAobject <- loadModel(filepath)
# get factors as matrix
getFactors(MOFAobject, factors = 1:3)
# get factors as data.frame
head(getFactors(MOFAobject, factors = 1:5, as.data.frame = TRUE))
}
