\name{ape-package}
\alias{ape-package}
\alias{ape}
\docType{package}
\title{
Analyses of Phylogenetics and Evolution
}
\description{
  \pkg{ape} provides functions for reading, writing, manipulating,
  analysing, and simulating phylogenetic trees and DNA sequences,
  computing DNA distances, translating into AA sequences, estimating
  trees with distance-based methods, and a range of methods for
  comparative analyses and analysis of diversification. Functionalities
  are also provided for programming new phylogenetic methods.

  The complete list of functions can be displayed with
  \code{library(help = ape)}.

  More information on \pkg{ape} can be found at
  \url{https://emmanuelparadis.github.io}.
}

\author{
  Emmanuel Paradis, Ben Bolker, Julien Claude, Hoa Sien Cuong, Richard
  Desper, Benoit Durand, Julien Dutheil, Olivier Gascuel, Christoph
  Heibl, Daniel Lawson, Vincent Lefort, Pierre Legendre, Jim Lemon,
  Yvonnick Noel, Johan Nylander, Rainer Opgen-Rhein, Andrei-Alin
  Popescu, Klaus Schliep, Korbinian Strimmer, Damien de Vienne

  Maintainer: Emmanuel Paradis <Emmanuel.Paradis@ird.fr>
}
\references{
  Paradis, E. (2012) \emph{Analysis of Phylogenetics and Evolution with
    R (Second Edition).} New York: Springer.

  Paradis, E., Claude, J. and Strimmer, K. (2004) APE: analyses of
  phylogenetics and evolution in R language. \emph{Bioinformatics},
  \bold{20}, 289--290.

  Popescu, A.-A., Huber, K. T. and Paradis, E. (2012) ape 3.0: new tools
  for distance based phylogenetics and evolutionary analysis in
  R. \emph{Bioinformatics}, \bold{28}, 1536--1537.

  Paradis, E. and Schliep, K. (2019) ape 5.0: an environment for modern
  phylogenetics and evolutionary analyses in R. \emph{Bioinformatics},
  \bold{35}, 526--528.
}
\keyword{package}
