% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution.R
\name{distribution}
\alias{distribution}
\alias{distribution_custom}
\alias{distribution_beta}
\alias{distribution_binomial}
\alias{distribution_binom}
\alias{distribution_cauchy}
\alias{distribution_chisquared}
\alias{distribution_chisq}
\alias{distribution_gamma}
\alias{distribution_mixture_normal}
\alias{distribution_normal}
\alias{distribution_gaussian}
\alias{distribution_nbinom}
\alias{distribution_poisson}
\alias{distribution_student}
\alias{distribution_t}
\alias{distribution_student_t}
\alias{distribution_tweedie}
\alias{distribution_uniform}
\alias{rnorm_perfect}
\title{Empirical Distributions}
\usage{
distribution(type = "normal", ...)

distribution_custom(n, type = "norm", ..., random = FALSE)

distribution_beta(n, shape1, shape2, ncp = 0, random = FALSE, ...)

distribution_binomial(n, size = 1, prob = 0.5, random = FALSE, ...)

distribution_binom(n, size = 1, prob = 0.5, random = FALSE, ...)

distribution_cauchy(n, location = 0, scale = 1, random = FALSE, ...)

distribution_chisquared(n, df, ncp = 0, random = FALSE, ...)

distribution_chisq(n, df, ncp = 0, random = FALSE, ...)

distribution_gamma(n, shape, scale = 1, random = FALSE, ...)

distribution_mixture_normal(n, mean = c(-3, 3), sd = 1, random = FALSE, ...)

distribution_normal(n, mean = 0, sd = 1, random = FALSE, ...)

distribution_gaussian(n, mean = 0, sd = 1, random = FALSE, ...)

distribution_nbinom(n, size, prob, mu, phi, random = FALSE, ...)

distribution_poisson(n, lambda = 1, random = FALSE, ...)

distribution_student(n, df, ncp, random = FALSE, ...)

distribution_t(n, df, ncp, random = FALSE, ...)

distribution_student_t(n, df, ncp, random = FALSE, ...)

distribution_tweedie(n, xi = NULL, mu, phi, power = NULL, random = FALSE, ...)

distribution_uniform(n, min = 0, max = 1, random = FALSE, ...)

rnorm_perfect(n, mean = 0, sd = 1)
}
\arguments{
\item{type}{Can be any of the names from base R's
\link[stats:Distributions]{Distributions}, like \code{"cauchy"}, \code{"pois"} or
\code{"beta"}.}

\item{...}{Arguments passed to or from other methods.}

\item{n}{the number of observations}

\item{random}{Generate near-perfect or random (simple wrappers for the base R
\verb{r*} functions) distributions.}

\item{shape1, shape2}{non-negative parameters of the Beta distribution.}

\item{ncp}{non-centrality parameter.}

\item{size}{number of trials (zero or more).}

\item{prob}{probability of success on each trial.}

\item{location, scale}{location and scale parameters.}

\item{df}{degrees of freedom (non-negative, but can be non-integer).}

\item{shape}{Shape parameter.}

\item{mean}{vector of means.}

\item{sd}{vector of standard deviations.}

\item{mu}{the mean}

\item{phi}{Corresponding to \code{glmmTMB}'s implementation of nbinom
distribution, where \code{size=mu/phi}.}

\item{lambda}{vector of (non-negative) means.}

\item{xi}{For tweedie distributions, the value of \code{xi} such that the variance
is \code{var(Y) = phi * mu^xi}.}

\item{power}{Alias for \code{xi}.}

\item{min, max}{lower and upper limits of the distribution.  Must be finite.}
}
\description{
Generate a sequence of n-quantiles, i.e., a sample of size \code{n} with a
near-perfect distribution.
}
\details{
When \code{random = FALSE}, these function return \verb{q*(ppoints(n), ...)}.
}
\examples{
library(bayestestR)
x <- distribution(n = 10)
plot(density(x))

x <- distribution(type = "gamma", n = 100, shape = 2)
plot(density(x))
}
