% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-time-series.R
\name{tidy.acf}
\alias{tidy.acf}
\title{Tidy a(n) acf object}
\usage{
\method{tidy}{acf}(x, ...)
}
\arguments{
\item{x}{An \code{acf} object created by \code{\link[stats:acf]{stats::acf()}}, \code{\link[stats:acf]{stats::pacf()}} or
\code{\link[stats:acf]{stats::ccf()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{

tidy(acf(lh, plot = FALSE))
tidy(ccf(mdeaths, fdeaths, plot = FALSE))
tidy(pacf(lh, plot = FALSE))
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[stats:acf]{stats::acf()}}, \code{\link[stats:acf]{stats::pacf()}}, \code{\link[stats:acf]{stats::ccf()}}

Other time series tidiers: 
\code{\link{tidy.spec}()},
\code{\link{tidy.ts}()},
\code{\link{tidy.zoo}()}
}
\concept{time series tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{acf}{Autocorrelation.}
  \item{lag}{Lag values.}

}
