% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guides.R
\name{guides}
\alias{guides}
\alias{guidesPrint,}
\alias{guidesStr,}
\alias{guidesChr,}
\alias{guidesDeparse}
\alias{guidesPrint}
\alias{guidesPrint,ANY,character-method}
\alias{guidesStr}
\alias{guidesStr,ANY,character-method}
\alias{guidesChr}
\alias{guidesChr,ANY,character-method}
\alias{guidesDeparse,ANY,character-method}
\alias{guidesFile}
\alias{guidesFile,ANY,character-method}
\title{Generic Methods to Implement Flexible Guide Line Computations}
\usage{
guidesPrint(obj, obj.as.chr)

\S4method{guidesPrint}{ANY,character}(obj, obj.as.chr)

guidesStr(obj, obj.as.chr)

\S4method{guidesStr}{ANY,character}(obj, obj.as.chr)

guidesChr(obj, obj.as.chr)

\S4method{guidesChr}{ANY,character}(obj, obj.as.chr)

guidesDeparse(obj, obj.as.chr)

\S4method{guidesDeparse}{ANY,character}(obj, obj.as.chr)

guidesFile(obj, obj.as.chr)

\S4method{guidesFile}{ANY,character}(obj, obj.as.chr)
}
\arguments{
\item{obj}{an R object}

\item{obj.as.chr}{the character representation of \code{obj} that is used
for computing the diffs}
}
\value{
integer containing values in \code{seq_along(obj.as.chr)}
}
\description{
Guides are context lines that would normally be omitted from the
diff because they are too far from any differences, but provide particularly
useful contextual information.  Column headers are a common example.
Modifying guide finding is an advanced feature intended for package
developers that want special treatment for the display output of their
objects.
}
\details{
\code{Diff} detects these important context lines by looking for patterns in
the text of the diff, and then displays these lines in addition to the
normal diff output.  Guides are marked by a tilde in the gutter, and
are typically styled differently than normal context lines, by default in
grey.  Guides may be far from the diff hunk they are juxtaposed to.  We
eschew the device of putting the guides in the hunk header as \code{git diff}
does because often the column alignment of the guide line is meaningful.

Guides are detected by the \code{guides*} methods documented here.
Each of the \code{diff*} methods (e.g. \code{\link{diffPrint}}) has a
corresponding \code{guides*} method (e.g.
\code{\link{guidesPrint}}), with the exception of \code{\link{diffCsv}}
since that method uses \code{diffPrint} internally.  The \code{guides*}
methods expect an R object as the first parameter and the captured display
representation of the object in a character vector as the second.  The
function should then identify which elements in the character representation
should be treated as guides, and should return the numeric indices for them.

The original object is passed as the first argument so that the generic can
dispatch on it, and so the methods may adjust their guide finding behavior
to data that is easily retrievable from the object, but less so from the
character representation thereof.

The default method for \code{guidesPrint} has special handling for 2D
objects (e.g. data frames, matrices), arrays, time series, tables, lists, and
S4 objects that use the default \code{show} method.  Guide finding is on a
best efforts basis and may fail if your objects contain \dQuote{pathological}
display representations.  Since the diff will still work with failed
\code{guides} finding we consider this an acceptable compromise.  Guide
finding is more likely to fail with nested recursive structures.  A known
issue is that list-like S3 objects without print methods [reset the tag
buffers](https://bugs.r-project.org/bugzilla/show_bug.cgi?id=17610) so the
guides become less useful for them.

\code{guidesStr} highlights top level objects.  The default methods for the
other \code{guide*} generics do not do anything and exist only as a mechanism
for providing custom guide line methods.

If you dislike the default handling you can also define your own methods for
matrices, arrays, etc., or alternatively you can pass a guide finding
function directly via the \code{guides} parameter to the \code{diff*}
methods.

If you have classed objects with special patterns you can define your own
methods for them (see examples), though if your objects are S3 you will need
to use \code{\link{setOldClass}} as the \code{guides*} generics are S4.
}
\note{
The mechanism for identifying guides will almost certainly change in
  the future to allow for better handling of nested guides, so if you do
  implement custom guideline methods do so with the understanding that they
  will likely be deprecated in one of the future releases.
}
\examples{
## Roundabout way of suppressing guides for matrices
setMethod("guidesPrint", c("matrix", "character"),
  function(obj, obj.as.chr) integer(0L)
)
## Special guides for "zulu" S3 objects that match lines
## starting in "zulu###" where ### is a nuber
setOldClass("zulu")
setMethod("guidesPrint", c("zulu", "character"),
  function(obj, obj.as.chr) {
    if(length(obj) > 20) grep("^zulu[0-9]*", obj.as.chr)
    else integer(0L)
} )
}
