% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowwise.R
\name{rowwise}
\alias{rowwise}
\title{Group input by rows}
\usage{
rowwise(data, ...)
}
\arguments{
\item{data}{Input data frame.}

\item{...}{<\code{\link[=dplyr_tidy_select]{tidy-select}}> Variables to be preserved
when calling \code{\link[=summarise]{summarise()}}. This is typically a set of variables whose
combination uniquely identify each row.

\strong{NB}: unlike \code{group_by()} you can not create new variables here but
instead you can select multiple variables with (e.g.) \code{everything()}.}
}
\value{
A row-wise data frame with class \code{rowwise_df}. Note that a
\code{rowwise_df} is implicitly grouped by row, but is not a \code{grouped_df}.
}
\description{
\code{rowwise()} allows you to compute on a data frame a row-at-a-time.
This is most useful when a vectorised function doesn't exist.

Most dplyr verbs preserve row-wise grouping. The exception is \code{\link[=summarise]{summarise()}},
which return a \link{grouped_df}. You can explicitly ungroup with \code{\link[=ungroup]{ungroup()}}
or \code{\link[=as_tibble]{as_tibble()}}, or convert to a \link{grouped_df} with \code{\link[=group_by]{group_by()}}.
}
\section{List-columns}{

Because a rowwise has exactly one row per group it offers a small
convenience for working with list-columns. Normally, \code{summarise()} and
\code{mutate()} extract a groups worth of data with \code{[}. But when you index
a list in this way, you get back another list. When you're working with
a \code{rowwise} tibble, then dplyr will use \code{[[} instead of \code{[} to make your
life a little easier.
}

\examples{
df <- tibble(x = runif(6), y = runif(6), z = runif(6))
# Compute the mean of x, y, z in each row
df \%>\% rowwise() \%>\% mutate(m = mean(c(x, y, z)))
# use c_across() to more easily select many variables
df \%>\% rowwise() \%>\% mutate(m = mean(c_across(x:z)))

# Compute the minimum of x and y in each row
df \%>\% rowwise() \%>\% mutate(m = min(c(x, y, z)))
# In this case you can use an existing vectorised function:
df \%>\% mutate(m = pmin(x, y, z))
# Where these functions exist they'll be much faster than rowwise
# so be on the lookout for them.

# rowwise() is also useful when doing simulations
params <- tribble(
 ~sim, ~n, ~mean, ~sd,
    1,  1,     1,   1,
    2,  2,     2,   4,
    3,  3,    -1,   2
)
# Here I supply variables to preserve after the computation
params \%>\%
  rowwise(sim) \%>\%
  reframe(z = rnorm(n, mean, sd))

# If you want one row per simulation, put the results in a list()
params \%>\%
  rowwise(sim) \%>\%
  summarise(z = list(rnorm(n, mean, sd)), .groups = "keep")
}
\seealso{
\code{\link[=nest_by]{nest_by()}} for a convenient way of creating rowwise data frames
with nested data.
}
