#include "ecos.h"
#include "minunit.h"

idxint udd_n = 20;
idxint udd_m = 40;
idxint udd_p = 5;
idxint udd_l = 40;
idxint udd_ncones = 0;
idxint *udd_q = NULL;

pfloat udd_c1[20] = {
    -0.335677,
    0.611341,
    0.047971,
    -0.829135,
    0.087710,
    1.000366,
    -0.381093,
    -0.375669,
    -0.074471,
    0.433496,
    1.278379,
    -0.634679,
    0.508396,
    0.216116,
    -1.858612,
    -0.419316,
    -0.132329,
    -0.039570,
    0.326003,
    -2.040323};

pfloat udd_c2[20] = {
    -0.325050,
    -0.560235,
    -0.902246,
    -0.590972,
    -0.276179,
    -0.516884,
    -0.698590,
    -0.928892,
    2.550438,
    -1.473173,
    -1.021415,
    0.432396,
    -0.323580,
    0.423825,
    0.799180,
    1.262614,
    0.751965,
    -0.993761,
    1.109143,
    -1.764918};

pfloat udd_b1[5] = {
    -0.416758,
    -0.056267,
    -2.136196,
    1.640271,
    -1.793436};

pfloat udd_b2[5] = {
    0.046256,
    -0.677676,
    -1.439439,
    0.524296,
    0.735280};

pfloat udd_h1[40] = {
    4.158253,
    5.502881,
    3.754712,
    3.942048,
    4.090992,
    5.551454,
    7.292208,
    5.041539,
    3.882075,
    5.539058,
    4.403840,
    4.980870,
    6.175001,
    4.252129,
    5.009025,
    4.121892,
    4.843566,
    5.256570,
    4.011221,
    4.661178,
    4.763816,
    4.362345,
    3.812388,
    3.578783,
    4.846505,
    4.730943,
    7.231367,
    2.565232,
    5.112727,
    5.370445,
    6.359634,
    5.501857,
    4.155786,
    5.000010,
    5.542353,
    4.686492,
    5.771012,
    3.131909,
    6.731185,
    6.467678};

pfloat udd_h2[40] = {
    4.346750,
    5.842456,
    4.618484,
    5.066489,
    3.901261,
    6.584487,
    2.340551,
    4.908547,
    5.695120,
    2.966533,
    4.810531,
    4.922781,
    5.824703,
    6.248213,
    4.596108,
    3.615481,
    6.367235,
    6.217886,
    4.537995,
    5.350888,
    5.381866,
    5.566275,
    5.204208,
    6.406696,
    3.262040,
    6.040824,
    5.380472,
    4.782865,
    6.173531,
    2.656397,
    6.161521,
    5.386078,
    3.866867,
    5.433093,
    4.695914,
    7.585295,
    6.835333,
    5.440690,
    4.280746,
    4.416585};

idxint udd_Ajc[21] = {
    0,
    4,
    7,
    8,
    10,
    11,
    12,
    14,
    18,
    19,
    22,
    26,
    27,
    30,
    33,
    35,
    37,
    38,
    39,
    43,
    48};

idxint udd_Air[48] = {
    0,
    1,
    2,
    3,
    0,
    2,
    4,
    0,
    0,
    3,
    4,
    0,
    1,
    4,
    0,
    1,
    3,
    4,
    2,
    0,
    2,
    4,
    1,
    2,
    3,
    4,
    3,
    0,
    1,
    3,
    0,
    3,
    4,
    0,
    1,
    0,
    1,
    4,
    1,
    0,
    2,
    3,
    4,
    0,
    1,
    2,
    3,
    4};

pfloat udd_A1pr[48] = {
    -1.850404,
    0.390296,
    -0.283520,
    -1.652200,
    0.330488,
    0.538424,
    -0.721880,
    -0.315693,
    -1.350002,
    -0.652931,
    -0.571382,
    0.239951,
    -2.505458,
    -1.195000,
    0.299527,
    1.825994,
    1.369016,
    -0.487931,
    0.335908,
    -0.840443,
    1.904376,
    -0.395346,
    -1.317567,
    0.085364,
    1.496952,
    0.870841,
    -1.531111,
    0.121106,
    -0.082245,
    -2.023364,
    -0.846829,
    0.267973,
    -0.681531,
    0.060462,
    -0.159724,
    -1.338589,
    0.548947,
    -0.787750,
    0.378794,
    1.085806,
    -0.174997,
    -1.156699,
    0.819885,
    0.902179,
    -0.334844,
    -1.437143,
    1.234035,
    -0.631119};

pfloat udd_A2pr[48] = {
    0.789060,
    0.712061,
    -0.603141,
    0.562669,
    -1.621674,
    0.041958,
    0.940176,
    -1.610499,
    0.499940,
    -0.152118,
    1.621093,
    -0.996960,
    0.786146,
    -0.208704,
    -0.677360,
    0.194169,
    -0.449329,
    0.137618,
    -1.369639,
    -1.455359,
    2.670337,
    0.848351,
    -0.414409,
    1.248450,
    0.837616,
    -0.883126,
    -0.131682,
    0.109951,
    0.631799,
    0.707593,
    -1.913523,
    0.114054,
    -0.400106,
    0.599820,
    1.615176,
    0.549384,
    0.425606,
    -0.834437,
    2.102229,
    -0.653541,
    -0.221321,
    -1.125904,
    0.820564,
    1.408834,
    0.535558,
    -1.173156,
    0.488497,
    -0.489157};

idxint udd_Gjc[21] = {
    0,
    20,
    42,
    65,
    85,
    109,
    135,
    157,
    176,
    195,
    213,
    236,
    261,
    282,
    299,
    323,
    341,
    367,
    391,
    412,
    433};

idxint udd_Gir[433] = {
    3,
    5,
    6,
    7,
    8,
    10,
    12,
    14,
    19,
    21,
    22,
    23,
    24,
    27,
    29,
    33,
    34,
    35,
    37,
    38,
    1,
    3,
    5,
    6,
    7,
    8,
    9,
    10,
    12,
    13,
    15,
    17,
    19,
    21,
    22,
    24,
    26,
    28,
    30,
    31,
    34,
    35,
    0,
    3,
    5,
    7,
    9,
    13,
    14,
    17,
    18,
    19,
    20,
    21,
    22,
    24,
    28,
    29,
    30,
    32,
    33,
    34,
    36,
    38,
    39,
    1,
    2,
    3,
    6,
    8,
    9,
    10,
    11,
    14,
    17,
    19,
    21,
    24,
    25,
    26,
    27,
    30,
    31,
    36,
    38,
    0,
    1,
    2,
    3,
    4,
    8,
    9,
    10,
    12,
    13,
    14,
    15,
    17,
    18,
    20,
    23,
    25,
    29,
    30,
    31,
    33,
    35,
    36,
    39,
    1,
    2,
    4,
    5,
    6,
    7,
    8,
    11,
    12,
    14,
    15,
    16,
    17,
    18,
    19,
    22,
    23,
    24,
    25,
    26,
    27,
    28,
    32,
    34,
    36,
    39,
    0,
    2,
    3,
    4,
    7,
    13,
    14,
    15,
    16,
    18,
    19,
    20,
    21,
    25,
    27,
    28,
    29,
    31,
    33,
    34,
    38,
    39,
    2,
    6,
    11,
    12,
    13,
    15,
    16,
    18,
    19,
    26,
    29,
    30,
    31,
    32,
    33,
    35,
    36,
    37,
    38,
    0,
    2,
    3,
    6,
    7,
    9,
    12,
    14,
    18,
    19,
    23,
    24,
    26,
    27,
    30,
    31,
    36,
    38,
    39,
    1,
    2,
    3,
    5,
    6,
    9,
    10,
    17,
    18,
    19,
    21,
    25,
    26,
    30,
    31,
    32,
    33,
    37,
    0,
    1,
    4,
    5,
    6,
    7,
    8,
    11,
    12,
    14,
    15,
    16,
    17,
    18,
    21,
    24,
    25,
    30,
    31,
    32,
    33,
    34,
    39,
    1,
    2,
    3,
    5,
    8,
    9,
    10,
    12,
    14,
    15,
    17,
    18,
    19,
    21,
    22,
    23,
    25,
    28,
    29,
    31,
    34,
    35,
    37,
    38,
    39,
    0,
    1,
    2,
    7,
    9,
    11,
    13,
    15,
    18,
    19,
    20,
    21,
    23,
    24,
    25,
    27,
    28,
    29,
    32,
    33,
    34,
    0,
    1,
    4,
    7,
    11,
    14,
    16,
    17,
    18,
    20,
    23,
    26,
    28,
    30,
    32,
    37,
    39,
    0,
    1,
    5,
    6,
    7,
    9,
    10,
    11,
    12,
    14,
    17,
    19,
    20,
    21,
    22,
    25,
    29,
    32,
    33,
    34,
    35,
    36,
    38,
    39,
    2,
    3,
    4,
    6,
    7,
    8,
    9,
    11,
    15,
    16,
    22,
    25,
    26,
    27,
    28,
    34,
    35,
    39,
    0,
    1,
    2,
    3,
    4,
    6,
    8,
    9,
    10,
    11,
    12,
    15,
    16,
    17,
    19,
    21,
    22,
    23,
    26,
    27,
    31,
    32,
    33,
    35,
    37,
    38,
    0,
    1,
    4,
    6,
    7,
    8,
    9,
    14,
    15,
    16,
    18,
    20,
    21,
    23,
    25,
    26,
    27,
    31,
    32,
    33,
    34,
    36,
    37,
    38,
    0,
    1,
    2,
    3,
    5,
    7,
    9,
    10,
    11,
    12,
    14,
    15,
    17,
    18,
    19,
    22,
    23,
    24,
    28,
    32,
    35,
    2,
    3,
    4,
    5,
    9,
    12,
    15,
    16,
    17,
    19,
    22,
    23,
    27,
    28,
    29,
    30,
    31,
    33,
    34,
    35,
    39};

pfloat udd_G1pr[433] = {
    -0.604458,
    -1.616535,
    1.284566,
    0.436472,
    -1.635406,
    1.013293,
    0.321506,
    1.534355,
    0.366968,
    -0.726032,
    0.087547,
    -0.785046,
    1.129848,
    0.318321,
    1.386577,
    0.274866,
    0.002027,
    -0.592454,
    0.517376,
    -1.622344,
    0.174284,
    0.115817,
    0.812154,
    -0.654576,
    0.943538,
    -0.528353,
    2.335438,
    1.757731,
    -0.306710,
    -0.627642,
    1.400522,
    0.697774,
    0.020714,
    0.326817,
    -0.504842,
    -0.117759,
    -0.422178,
    -0.638825,
    -1.729950,
    0.472260,
    -0.254233,
    -1.289933,
    -0.185306,
    0.392723,
    -0.656299,
    0.519106,
    -0.221180,
    0.429178,
    -1.226603,
    -0.468756,
    0.672765,
    -0.692898,
    1.689429,
    0.392173,
    0.195783,
    0.131833,
    1.282365,
    -1.828355,
    -1.689388,
    0.756558,
    1.239564,
    -0.528476,
    0.086169,
    0.445539,
    0.402079,
    -0.560999,
    1.584936,
    -0.137539,
    -0.232249,
    0.268012,
    1.187036,
    -0.218257,
    0.869421,
    0.356302,
    -0.017272,
    0.869400,
    0.578761,
    -0.859558,
    -0.157309,
    -1.550036,
    -0.390998,
    -0.693947,
    0.339348,
    1.140722,
    -0.323923,
    3.009431,
    0.175141,
    -0.146943,
    -1.071334,
    0.561164,
    -0.655807,
    -0.600098,
    -1.414579,
    0.453915,
    -0.759225,
    0.841614,
    0.176218,
    1.134876,
    -0.536744,
    -0.957559,
    0.514029,
    1.024996,
    -1.507732,
    1.971357,
    -0.363225,
    0.631319,
    1.469479,
    0.388984,
    -0.495026,
    0.646350,
    1.539413,
    -1.011075,
    0.394161,
    -1.065816,
    0.820371,
    0.635648,
    -1.079584,
    2.068711,
    0.444286,
    0.487578,
    0.875011,
    -0.508925,
    -1.232539,
    -1.770912,
    -0.923136,
    -0.012262,
    -0.943726,
    -1.164260,
    -1.321612,
    -0.729383,
    -1.602314,
    -2.953756,
    -0.018225,
    -0.626927,
    0.337515,
    -1.298238,
    0.899889,
    1.689881,
    -0.677101,
    -1.677021,
    -0.183357,
    0.636712,
    1.543877,
    0.932842,
    0.002887,
    -1.118161,
    -0.537494,
    -0.294323,
    0.264523,
    -0.373421,
    -0.097253,
    1.042805,
    0.781891,
    0.793202,
    -0.552991,
    0.720144,
    -0.617451,
    0.740252,
    1.004944,
    0.690742,
    0.630972,
    0.194336,
    -1.852759,
    0.439776,
    -2.996762,
    -0.070477,
    -0.675849,
    -0.842105,
    -0.820499,
    -0.418841,
    0.290407,
    -0.671775,
    -0.163683,
    0.250624,
    0.460009,
    1.195716,
    0.642954,
    -0.193204,
    0.020505,
    0.752270,
    -2.514379,
    2.079377,
    0.877512,
    1.007236,
    -1.678710,
    0.293658,
    -0.942035,
    -1.222779,
    -0.252668,
    -2.413138,
    -0.515622,
    0.492486,
    0.217430,
    0.133329,
    -0.279145,
    -1.551460,
    0.201998,
    -1.110493,
    0.799971,
    0.496797,
    -0.512494,
    -1.388168,
    -0.455945,
    1.121887,
    1.843957,
    0.017672,
    -0.771103,
    -0.328425,
    -0.237564,
    0.071280,
    0.902256,
    -0.552807,
    1.807653,
    0.326331,
    0.778366,
    0.366593,
    -0.370369,
    -1.057505,
    -0.752133,
    -0.076728,
    -1.507076,
    0.245142,
    -0.499859,
    0.874328,
    1.344860,
    -2.191908,
    -1.291149,
    1.286021,
    -0.582930,
    0.820560,
    1.194371,
    -0.009271,
    0.331844,
    -0.358372,
    -1.979875,
    -0.872105,
    0.122683,
    -2.000077,
    -0.915559,
    0.341522,
    0.251829,
    1.330418,
    1.865595,
    -1.553948,
    1.471232,
    -0.446667,
    -2.200022,
    2.040918,
    0.488540,
    1.647945,
    -0.219038,
    0.708528,
    -0.337854,
    0.734519,
    -0.243980,
    -0.516628,
    -2.299471,
    0.154258,
    0.953263,
    2.111304,
    -0.146455,
    0.471300,
    -0.836932,
    -0.698165,
    -1.064511,
    1.279321,
    0.412146,
    0.409262,
    0.010177,
    0.114107,
    0.985168,
    0.858199,
    1.091709,
    -0.218618,
    -0.284262,
    0.777865,
    -0.781799,
    -0.234930,
    -0.209376,
    -1.445675,
    0.816667,
    0.713835,
    -0.794150,
    -0.407456,
    1.656869,
    -0.255828,
    -0.056747,
    -1.598905,
    -0.442735,
    -1.311168,
    0.267248,
    -0.362256,
    -0.555780,
    -1.587296,
    -2.169850,
    -0.526466,
    0.108533,
    0.983320,
    -1.091572,
    -0.568612,
    -0.306069,
    -0.860096,
    0.334596,
    -0.813826,
    -0.014182,
    0.252924,
    -0.231419,
    0.208003,
    -0.391584,
    0.633083,
    0.262205,
    0.745905,
    -3.326870,
    -0.140030,
    -1.478163,
    0.643256,
    0.718677,
    0.427641,
    0.290008,
    -0.483160,
    0.611436,
    -0.558387,
    0.051528,
    0.600310,
    -0.725315,
    0.607953,
    -1.094167,
    -0.282296,
    -0.454538,
    0.998359,
    -0.126224,
    -0.061687,
    -0.320691,
    -1.352678,
    -0.002111,
    -1.733669,
    0.897460,
    0.079424,
    0.624276,
    0.031158,
    -0.042927,
    -0.446904,
    -0.179737,
    0.817851,
    0.798810,
    -0.522742,
    0.445127,
    -0.604132,
    1.218200,
    0.165448,
    -0.558316,
    1.942956,
    1.810532,
    -0.480685,
    -0.166071,
    -0.427351,
    0.466792,
    2.551138,
    -0.141523,
    2.083059,
    0.687336,
    1.199909,
    -0.875053,
    -0.838512,
    1.683744,
    2.114703,
    -0.537743,
    -0.590225,
    -0.403748,
    -0.517912,
    -0.352266,
    -2.255939,
    0.420163,
    -0.946169,
    -0.296672,
    1.273556,
    0.274700,
    -0.557115,
    -0.114895,
    -0.986960,
    -0.011856,
    -0.659016,
    -1.019133,
    -0.574313,
    0.019951,
    -1.832358,
    1.658153,
    1.986075,
    -1.720905,
    -0.141108,
    0.263227,
    1.363825,
    -1.460154,
    1.113416,
    1.200239,
    -1.794633,
    -0.140629,
    0.354671,
    -0.672464,
    -0.103649,
    1.055692,
    0.377759,
    1.404988,
    0.651916,
    -0.645833,
    0.140154,
    0.887589,
    -0.479614,
    -1.029072,
    0.399266,
    -0.599745,
    1.624626,
    -0.743297,
    0.296490,
    -0.887197,
    -0.734806,
    -2.216668,
    0.655032,
    -0.223101,
    -1.145355,
    1.359294,
    -0.071394,
    -2.311148,
    -1.562008,
    -0.258267,
    2.146890,
    0.573343,
    -1.960490,
    1.180488,
    0.234157,
    0.229035,
    0.625723,
    -1.611942};

pfloat udd_G2pr[433] = {
    0.846912,
    -0.459355,
    0.261504,
    -0.375520,
    0.010605,
    -0.771162,
    -1.064193,
    0.401054,
    0.200374,
    0.724468,
    0.138381,
    -0.820923,
    -0.664304,
    -1.744968,
    0.137875,
    0.711810,
    0.228499,
    -0.595541,
    1.221769,
    0.463560,
    0.980031,
    0.244432,
    0.377281,
    -1.742385,
    -0.455901,
    0.868513,
    -0.519781,
    -0.907602,
    -1.454372,
    0.849322,
    -0.520426,
    -2.131635,
    -1.110987,
    -0.538739,
    0.871389,
    -0.287105,
    0.264119,
    1.020269,
    -0.727471,
    -0.877869,
    -0.314186,
    -0.326867,
    -0.988778,
    1.546264,
    -1.507500,
    0.735721,
    1.759853,
    0.287918,
    -0.865313,
    0.368282,
    0.064167,
    0.176582,
    -0.590913,
    -1.620076,
    0.949636,
    1.170568,
    -0.731063,
    -0.088562,
    -0.117511,
    -0.946673,
    0.897579,
    -0.406328,
    0.736348,
    -0.427595,
    0.145711,
    1.187414,
    0.408800,
    0.909784,
    -1.625223,
    0.756222,
    -0.364509,
    0.730711,
    -0.341049,
    -0.640720,
    -0.828296,
    0.249115,
    0.158699,
    0.300534,
    -2.236047,
    0.664602,
    1.240630,
    0.241847,
    -0.368207,
    -0.339143,
    0.649882,
    0.856982,
    -1.699492,
    -0.069978,
    -0.330795,
    1.247595,
    1.039921,
    1.600010,
    1.020135,
    1.878755,
    -1.891002,
    0.281520,
    -0.636044,
    -0.991489,
    0.388278,
    -1.365283,
    0.228841,
    -0.495001,
    1.286138,
    1.098887,
    1.478652,
    1.348704,
    -1.135478,
    1.315693,
    -1.028395,
    -1.853289,
    -1.054240,
    1.586802,
    1.787898,
    -1.458138,
    -0.235634,
    1.480849,
    0.707983,
    0.865504,
    0.140740,
    0.761264,
    2.386157,
    -0.495210,
    -0.017396,
    -1.258666,
    1.318315,
    1.739550,
    -0.432227,
    -0.266923,
    -1.105823,
    -0.123907,
    0.256637,
    0.236224,
    -1.143605,
    0.979833,
    -1.582107,
    1.234982,
    1.162660,
    0.365959,
    -0.554211,
    1.285846,
    0.499183,
    -0.172943,
    0.281433,
    -1.467107,
    -0.617207,
    -0.620169,
    2.519570,
    1.899949,
    0.860916,
    0.585476,
    0.734615,
    -0.577768,
    -0.042568,
    -1.341871,
    1.027019,
    -0.546462,
    -0.329074,
    -0.938059,
    -0.792271,
    -1.682159,
    -0.403121,
    -0.334749,
    -0.322852,
    0.279373,
    0.213589,
    1.202307,
    1.344012,
    0.891728,
    -0.592955,
    0.310293,
    -0.597595,
    0.765785,
    0.277696,
    -0.492326,
    -0.916536,
    1.270065,
    1.446450,
    -0.789415,
    -0.663419,
    0.152710,
    0.586649,
    -0.072082,
    -0.115938,
    -1.584100,
    -2.676027,
    -0.612853,
    -0.246549,
    -0.876192,
    -1.642127,
    -0.732252,
    -1.592815,
    0.589395,
    0.225021,
    0.133395,
    -1.264452,
    -0.257193,
    -1.835686,
    -0.282887,
    0.606459,
    -0.270308,
    -0.082934,
    -0.617202,
    -0.131071,
    -0.962157,
    0.288241,
    -1.665909,
    0.541106,
    -1.153127,
    1.882160,
    -0.623940,
    -0.860513,
    0.289569,
    0.532088,
    0.418266,
    -0.688451,
    -2.431169,
    1.029574,
    -1.042159,
    -0.147407,
    0.606701,
    0.582945,
    -1.304144,
    0.643559,
    0.296483,
    -1.649375,
    1.127469,
    -0.168725,
    -2.629727,
    0.070469,
    -1.323964,
    0.160800,
    -0.603301,
    0.063059,
    0.273683,
    0.695690,
    0.762759,
    1.675608,
    0.125623,
    -0.749511,
    0.156563,
    0.205220,
    0.810094,
    -0.105932,
    -1.302717,
    0.030336,
    0.450938,
    1.677683,
    0.607747,
    1.288477,
    -1.078356,
    -1.478160,
    0.889983,
    -1.790702,
    -1.459029,
    -0.036894,
    0.213216,
    0.343181,
    1.015726,
    0.512940,
    -0.428509,
    1.009726,
    -1.468822,
    1.418628,
    -0.657417,
    0.845292,
    0.516526,
    1.829620,
    0.303971,
    -1.473014,
    0.571451,
    -1.357076,
    0.715088,
    -1.557563,
    0.449970,
    -0.274071,
    1.082497,
    0.475317,
    1.590660,
    0.409455,
    -1.944081,
    -0.212020,
    -0.310642,
    0.132924,
    -0.730200,
    -3.136547,
    0.063556,
    -0.443620,
    0.300174,
    -0.840610,
    -0.071843,
    1.277993,
    1.775172,
    0.723763,
    -1.071724,
    0.402628,
    2.266571,
    -0.270392,
    0.118290,
    -0.745375,
    0.097286,
    -0.064453,
    0.409077,
    1.237279,
    0.132501,
    -0.041927,
    1.249256,
    1.481769,
    -0.008749,
    3.491877,
    -1.672090,
    -0.827142,
    -0.695013,
    1.948588,
    -2.364899,
    1.004047,
    -1.678562,
    0.927809,
    0.273307,
    0.067911,
    0.026035,
    1.922029,
    0.926703,
    1.934326,
    -0.295239,
    -0.980078,
    -0.918960,
    -0.059167,
    -0.345992,
    0.653045,
    0.102547,
    -1.128919,
    2.033335,
    1.365129,
    -1.330854,
    0.054583,
    -0.366350,
    0.704772,
    1.001981,
    -0.489293,
    0.642624,
    0.595189,
    -0.603700,
    2.075227,
    -1.025429,
    -1.529383,
    1.286028,
    -2.699606,
    0.339474,
    0.846534,
    -0.069086,
    0.588053,
    0.641258,
    0.672523,
    0.180413,
    1.714184,
    0.080281,
    0.099046,
    -0.051320,
    1.656309,
    -1.546035,
    -0.585434,
    1.158246,
    1.276050,
    -0.708755,
    0.715776,
    0.397692,
    0.877891,
    0.755337,
    0.706246,
    0.788292,
    0.121778,
    0.366136,
    -0.155026,
    0.112635,
    -0.042929,
    -2.333543,
    -1.013977,
    0.540915,
    -1.201220,
    -0.718219,
    -0.207675,
    -1.962605,
    2.040695,
    -1.269941,
    -0.106467,
    -0.707511,
    1.929301,
    0.916927,
    0.685769,
    -0.078252,
    0.843905,
    -0.173213,
    1.123272,
    0.905845,
    0.209161,
    -0.299834,
    0.861961,
    -0.213952,
    1.153889,
    1.344567,
    0.424282,
    -0.555313,
    1.111228,
    -1.645416,
    -0.521446,
    1.636687,
    0.499839,
    -0.299306,
    0.326769,
    -0.152321,
    0.152398,
    0.012297,
    0.365941,
    0.344651,
    0.823994,
    -0.907183,
    0.526422,
    -0.445318,
    -1.644503,
    -0.836420,
    -1.032285,
    -1.543768,
    -0.105836,
    -0.056304,
    0.045737,
    0.055654,
    1.491390,
    1.287228,
    1.394766,
    -1.664939,
    0.843192,
    0.413345,
    -1.107255};

pfloat udd_optval1 = -36.250515;
pfloat udd_optval2 = -20.011586;

static char * test_update_data(){

    pwork *mywork;
    idxint exitflag;
    
    mywork = ECOS_setup(udd_n, udd_m, udd_p, udd_l, udd_ncones, udd_q, 0,
                        udd_G1pr, udd_Gjc, udd_Gir,
                        udd_A1pr, udd_Ajc, udd_Air,
                        udd_c1, udd_h1, udd_b1);

    if( mywork != NULL )
    {
        exitflag = ECOS_solve(mywork);
    }
    else
    {
        exitflag = ECOS_FATAL;
    }

    mu_assert("update_data: ECOS failed to produce outputflag OPTIMAL", exitflag == ECOS_OPTIMAL || exitflag == ECOS_OPTIMAL+ECOS_INACC_OFFSET);

    ECOS_updateData(mywork, udd_G2pr, udd_A2pr,
                                  udd_c2, udd_h2, udd_b2);

    exitflag = ECOS_solve(mywork);

    mu_assert("update_data: ECOS failed to produce correct updated solution.", exitflag == ECOS_OPTIMAL || exitflag == ECOS_OPTIMAL+ECOS_INACC_OFFSET);

    ECOS_cleanup(mywork, 0);
    
    return 0;
}
