% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-flow-jwt.R
\name{req_oauth_bearer_jwt}
\alias{req_oauth_bearer_jwt}
\title{OAuth authentication with a bearer JWT}
\usage{
req_oauth_bearer_jwt(
  req,
  client,
  claim,
  signature = "jwt_encode_sig",
  signature_params = list(),
  scope = NULL,
  token_params = list()
)
}
\arguments{
\item{req}{A \link{request}.}

\item{client}{An \code{\link[=oauth_client]{oauth_client()}}.}

\item{claim}{A list of claims. If all elements of the claim set are static
apart from \code{iat}, \code{nbf}, \code{exp}, or \code{jti}, provide a list and
\code{\link[=jwt_claim]{jwt_claim()}} will automatically fill in the dynamic components.
If other components need to vary, you can instead provide a zero-argument
callback function which should call \code{jwt_claim()}.}

\item{signature}{Function use to sign \code{claim}, e.g. \code{\link[=jwt_encode_sig]{jwt_encode_sig()}}.}

\item{signature_params}{Additional arguments passed to \code{signature}, e.g.
\code{size}, \code{header}.}

\item{scope}{Scopes to be requested from the resource owner.}

\item{token_params}{List containing additional parameters passed to the
\code{token_url}.}
}
\value{
A modified HTTP \link{request}.
}
\description{
This uses \code{\link[=oauth_flow_bearer_jwt]{oauth_flow_bearer_jwt()}} to generate an access token which is then
used to authenticate the request with \code{\link[=req_auth_bearer_token]{req_auth_bearer_token()}}.
The token is cached in memory.
}
\examples{
client <- oauth_client("example", "https://example.com/get_token")
claim <- jwt_claim()
req <- request("https://example.com")

req \%>\% req_oauth_bearer_jwt(client, claim)
}
