% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importQualtrics.R
\name{importQualtrics}
\alias{importQualtrics}
\title{Import Qualtrics survey files, apply clean column names}
\usage{
importQualtrics(file, namerow = 1, questionrow = 2, importidrow = 3,
  skip = 3, dropTEXT = TRUE, stringsAsFactors = FALSE)
}
\arguments{
\item{file}{file name (including path if in another directory) of
a CSV or XLSX file from Qualtrics.}

\item{namerow}{Row number for variable names.  Default 1, the
information to be used as column names (same as HEADER row in
R's read.table function)}

\item{questionrow}{Row number to be treated as the questions in the
survey. Default is 2. If questions do not seem to be present
in this row, there will be a warning.}

\item{importidrow}{Row number to be treated as Qualtrics meta
data. Default is 3. Many CSV created by Qualtrics will have
row 3 with a character string such as
\code{"{""ImportId"":""QID1303_4""}"}.  If importids are not
present in this row, there will be a warning.}

\item{skip}{Number of rows that are meta data. Current Qualtrics
CSV files will usually have 3 metadata rows, 1 = name, 2 =
question, 3 = ImportId. This function will try to guess how
many rows of metadata are present. skip should be at least
as large as \code{max(namerow, questions, and importids)}}

\item{dropTEXT}{Default TRUE, columns ending in "_TEXT" are
omitted.}

\item{stringsAsFactors}{Default FALSE, same meaning as R's
read.csv. Does not affect importation of Excel files.}
}
\value{
Data frame that has attribute "meta"
}
\description{
Defaults are based on most common format received from Qualtrics
downloads to CSV or XLSX (MS Excel) formats.  We assume that the
file has the column names in row 1 and that 3 rows are skipped
before the real data begins. If the parameter questrow is used, it
designates a row that is interpreted as the survey questions
themselves.  Often, this is in row 2.
}
\author{
Paul Johnson <pauljohn@ku.edu>
}
