% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{mixingmatrix}
\alias{mixingmatrix}
\alias{mixingmatrix.network}
\alias{[[.mixingmatrix}
\alias{$.mixingmatrix}
\alias{is.directed.mixingmatrix}
\alias{is.bipartite.mixingmatrix}
\alias{print.mixingmatrix}
\title{Mixing matrix}
\usage{
mixingmatrix(object, ...)

\method{mixingmatrix}{network}(object, attrname, useNA = "ifany", expand.bipartite = FALSE, ...)

\method{[[}{mixingmatrix}(x, ...)

\method{$}{mixingmatrix}(x, name)

\method{is.directed}{mixingmatrix}(x, ...)

\method{is.bipartite}{mixingmatrix}(x, ...)

\method{print}{mixingmatrix}(x, ...)
}
\arguments{
\item{object}{a network or some other data structure for which a mixing
matrix is meaningful.}

\item{...}{arguments passed to \code{\link{table}}.}

\item{attrname}{a vertex attribute name.}

\item{useNA}{one of "ifany", "no" or "always". Argument passed to
\code{\link{table}}. By default (\code{useNA = "ifany"}) if there are any
\code{NA}s on the attribute corresponding row \emph{and} column will be
contained in the result. See Details.}

\item{expand.bipartite}{logical; if \code{object} is bipartite, should we return
the \emph{square} mixing matrix representing every level of \code{attrname} against
every other level, or a \emph{rectangular} matrix considering only levels
present in each bipartition?}

\item{x}{mixingmatrix object}

\item{name}{name of the element to extract, one of "matrix" or "type"}
}
\value{
Function \code{mixingmatrix()} returns an object of class \code{mixingmatrix}
extending \code{table} with a cross-tabulation of edges in the \code{object}
according to the values of attribute \code{attrname} for the two incident
vertices. If \code{object} is a \emph{directed} network rows correspond to the "tie
sender" and columns to the "tie receiver". If \code{object} is an \emph{undirected}
network there is no such distinction and the matrix is symmetrized. In both
cases the matrix is square and all the observed values of the attribute
\code{attrname} are represented in rows and columns. If \code{object} is a
\emph{bipartite} network and \code{expand.bipartite} is \code{FALSE} the resulting matrix
does not have to be square as only the actually observed values of the
attribute are shown for each partition, if \code{expand.bipartite} is \code{TRUE} the
matrix will be square.

Functions \code{is.directed()} and \code{is.bipartite()} return \code{TRUE} or
\code{FALSE}. The values will be identical for the input network \code{object}.
}
\description{
Return the mixing matrix for a network, on a given attribute.
}
\details{
Handling of missing values on the attribute \code{attrname} almost
follows similar logic to \code{\link{table}}. If there are \code{NA}s on
the attribute and \code{useNA="ifany"} (default) the result will contain
both row and column for the missing values to ensure the resulting matrix
is square (essentially calling \code{\link{table}} with
\code{useNA="always"}). Also for that reason passing \code{exclude}
parameter with \code{NULL}, \code{NA} or \code{NaN} is ignored with a
warning as it may break the symmetry.
}
\note{
The \code{$} and \code{[[} methods are included only for backward-compatiblity
reason and will become defunct in future releases of the package.
}
\examples{
# Interaction ties between Lake Pomona SAR organizations by sponsorship type
# of tie sender and receiver (data from Drabek et al. 1981)
data(emon)
mixingmatrix(emon$LakePomona, "Sponsorship")
}
