/*
 * Copyright (C) 2015-2018 Apple Inc. All rights reserved.
 * Copyright (C) 2021 Igalia S.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "WasmValueLocation.h"

#if ENABLE(WEBASSEMBLY)

namespace JSC { namespace Wasm {

void ValueLocation::dump(PrintStream& out) const
{
    out.print(m_kind);
    switch (m_kind) {
    case GPRRegister:
        out.print("(", jsr(), ")");
        return;
    case FPRRegister:
        out.print("(", fpr(), ")");
        return;
    case Stack:
        out.print("(", offsetFromFP(), ")");
        return;
    case StackArgument:
        out.print("(", offsetFromSP(), ")");
        return;
    }
    RELEASE_ASSERT_NOT_REACHED();
}

} } // namespace JSC::Wasm

namespace WTF {

using namespace JSC::Wasm;

void printInternal(PrintStream& out, ValueLocation::Kind kind)
{
    switch (kind) {
    case ValueLocation::GPRRegister:
        out.print("GPRRegister");
        return;
    case ValueLocation::FPRRegister:
        out.print("FPRRegister");
        return;
    case ValueLocation::Stack:
        out.print("Stack");
        return;
    case ValueLocation::StackArgument:
        out.print("StackArgument");
        return;
    }
    RELEASE_ASSERT_NOT_REACHED();
}

} // namespace WTF

#endif // ENABLE(WEBASSEMBLY)
