// generated by ../../../../tools/tube_transfer.py
// tube: 12AT7
// plate current function: triode
// mu: 60
// kx: 1.35
// kg1: 460
// kg2: 0
// kp: 300
// kvb: 300
// Uin_min: -5
// Uin_max: 5
// Vp: 250
// Rp: 100000

table1d_imp<2001> tubetable_12AT7[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	223.48497105114055,223.38189845992403,223.2786068592581,223.17509643817309,223.07136738642214,
	222.9674198944693,222.8632541534779,222.75887035529922,222.6542686924603,222.54944935815303,
	222.44441254622248,222.33915845115538,222.23368726806927,222.12799919270088,222.0220944213952,
	221.91597315109416,221.80963557932594,221.7030819041937,221.59631232436487,221.48932703906033,
	221.38212624804362,221.27471015161018,221.167078950577,221.05923284627173,220.95117204052252,
	220.8428967356473,220.73440713444393,220.62570344017922,220.51678585657945,220.4076545878197,
	220.29830983851406,220.18875181370572,220.0789807188566,219.96899675983795,219.85880014292044,
	219.74839107476433,219.63776976240976,219.52693641326735,219.41589123510863,219.30463443605655,
	219.19316622457592,219.08148680946462,218.96959639984354,218.85749520514827,218.74518343511926,
	218.63266129979326,218.51992900949398,218.40698677482345,218.2938348066532,218.18047331611507,
	218.0669025145928,217.95312261371356,217.83913382533893,217.72493636155662,217.61053043467209,
	217.49591625719998,217.38109404185585,217.26606400154802,217.15082634936923,217.03538129858853,
	216.91972906264337,216.8038698551314,216.68780388980267,216.57153138055165,216.4550525414096,
	216.3383675865365,216.22147673021382,216.10438018683638,215.98707817090528,215.86957089702005,
	215.75185857987137,215.63394143423383,215.5158196749583,215.39749351696486,215.27896317523567,
	215.16022886480778,215.041290800766,214.92214919823604,214.80280427237747,214.68325623837677,
	214.56350531144065,214.44355170678918,214.32339563964916,214.20303732524744,214.08247697880427,
	213.96171481552685,213.84075105060285,213.71958589919387,213.5982195764292,213.4766522973996,
	213.35488427715097,213.23291573067795,213.11074687291824,212.9883779187459,212.86580908296608,
	212.74304058030845,212.62007262542147,212.49690543286687,212.37353921711323,212.2499741925306,
	212.12621057338484,212.00224857383193,211.87808840791226,211.7537302895452,211.62917443252363,
	211.50442105050845,211.37947035702337,211.25432256544926,211.1289778890191,211.00343654081286,
	210.87769873375214,210.75176468059493,210.62563459393093,210.49930868617622,210.3727871695683,
	210.24607025616143,210.11915815782132,209.9920510862206,209.8647492528342,209.73725286893415,
	209.60956214558527,209.48167729364036,209.35359852373574,209.2253260462867,209.09686007148272,
	208.96820080928336,208.8393484694139,208.71030326136048,208.58106539436642,208.45163507742754,
	208.322012519288,208.1921979284363,208.06219151310097,207.93199348124645,207.80160404056923,
	207.67102339849362,207.54025176216805,207.4092893384607,207.27813633395616,207.14679295495142,
	207.01525940745177,206.8835358971674,206.75162262950943,206.6195198095865,206.48722764220096,
	206.35474633184526,206.2220760826986,206.08921709862307,205.9561695831605,205.82293373952882,
	205.6895097706187,205.5558978789903,205.42209826686985,205.28811113614628,205.15393668836825,
	205.01957512474047,204.88502664612108,204.7502914530181,204.61536974558643,204.48026172362498,
	204.34496758657332,204.20948753350885,204.0738217631438,203.93797047382242,203.80193386351786,
	203.66571212982956,203.52930546998024,203.39271408081316,203.2559381587893,203.11897789998477,
	202.98183350008804,202.84450515439724,202.70699305781773,202.56929740485907,202.43141838963285,
	202.2933562058501,202.1551110468186,202.0166831054405,201.87807257420994,201.73927964521062,
	201.60030451011326,201.46114736017347,201.32180838622932,201.18228777869888,201.0425857275783,
	200.90270242243926,200.76263805242695,200.62239280625775,200.48196687221719,200.34136043815778,
	200.20057369149677,200.05960681921437,199.9184600078514,199.77713344350758,199.63562731183907,
	199.4939417980571,199.3520770869254,199.21003336275896,199.06781080942147,198.92540961032392,
	198.78282994842257,198.64007200621697,198.49713596574864,198.3540220085988,198.21073031588693,
	198.0672610682689,197.92361444593533,197.77979062860993,197.6357897955478,197.49161212553375,
	197.3472577968809,197.2027269874288,197.05801987454205,196.91313663510886,196.7680774455392,
	196.62284248176363,196.47743191923158,196.33184593291003,196.1860846972821,196.0401483863454,
	195.89403717361103,195.74775123210182,195.6012907343511,195.45465585240152,195.30784675780347,
	195.16086362161403,195.01370661439543,194.86637590621405,194.71887166663902,194.57119406474095,
	194.42334326909096,194.2753194477592,194.12712276831388,193.9787533978201,193.8302115028385,
	193.68149724942444,193.5326108031268,193.3835523289867,193.23432199153677,193.0849199547998,
	192.93534638228792,192.78560143700136,192.63568528142767,192.48559807754066,192.33533998679928,
	192.18491117014688,192.03431178801017,191.88354200029826,191.7326019664018,191.58149184519206,
	191.43021179502006,191.27876197371563,191.12714253858678,190.97535364641854,190.8233954534724,
	190.6712681154852,190.51897178766882,190.36650662470888,190.21387278076412,190.06107040946594,
	189.9080996639172,189.75496069669177,189.60165365983374,189.44817870485664,189.2945359827429,
	189.14072564394306,188.98674783837498,188.83260271542338,188.6782904239391,188.52381111223855,
	188.3691649281029,188.21435201877753,188.0593725309716,187.90422661085714,187.74891440406878,
	187.59343605570305,187.43779171031755,187.281981511931,187.12600560402208,186.9698641295292,
	186.81355723085008,186.6570850498409,186.50044772781615,186.34364540554782,186.18667822326523,
	186.02954632065422,185.87224983685695,185.71478891047127,185.5571636795505,185.39937428160272,
	185.24142085359037,185.08330353193014,184.92502245249204,184.7665777505995,184.6079695610286,
	184.4491980180079,184.29026325521792,184.131165405791,183.9719046023104,183.81248097681055,
	183.65289466077655,183.49314578514338,183.3332344802961,183.17316087606935,183.0129251017468,
	182.85252728606125,182.69196755719386,182.5312460427742,182.37036286987987,182.20931816503594,
	182.04811205421504,181.88674466283703,181.7252161157683,181.56352653732213,181.4016760512579,
	181.23966478078128,181.07749284854347,180.9151603766414,180.75266748661736,180.59001429945855,
	180.4272009355972,180.26422751491006,180.10109415671843,179.93780097978768,179.7743481023272,
	179.61073564199023,179.44696371587352,179.28303244051722,179.11894193190474,178.9546923054625,
	178.79028367605963,178.62571615800815,178.46098986506223,178.29610491041868,178.13106140671627,
	177.96585946603577,177.8004991998998,177.63498071927276,177.46930413456036,177.30346955560984,
	177.1374770917096,176.9713268515892,176.80501894341916,176.6385534748107,176.47193055281588,
	176.3051502839272,176.13821277407774,175.97111812864082,175.80386645242993,175.63645784969873,
	175.46889242414085,175.3011702788898,175.13329151651868,174.96525623904046,174.79706454790775,
	174.62871654401224,174.46021232768535,174.29155199869754,174.12273565625858,173.95376339901728,
	173.78463532506146,173.61535153191775,173.44591211655174,173.27631717536778,173.10656680420877,
	172.93666109835627,172.7666001525303,172.59638406088936,172.4260129170304,172.2554868139885,
	172.08480584423708,171.91397009968762,171.74297967168977,171.57183465103122,171.40053512793756,
	171.2290811920723,171.0574729325368,170.8857104378701,170.71379379604917,170.5417230944884,
	170.36949842003992,170.19711985899337,170.02458749707597,169.8519014194522,169.67906171072408,
	169.5060684549309,169.3329217355492,169.1596216354928,168.98616823711276,168.8125616221971,
	168.63880187197108,168.46488906709692,168.29082328767387,168.11660461323808,167.94223312276253,
	167.7677088946573,167.59303200676896,167.41820253638102,167.24322056021367,167.06808615442375,
	166.89279939460474,166.71736035578672,166.5417691124362,166.3660257384564,166.19013030718673,
	166.01408289140318,165.837883563318,165.66153239457992,165.48502945627374,165.30837481892067,
	165.13156855247806,164.9546107263393,164.77750140933398,164.60024066972787,164.42282857522252,
	164.24526519295563,164.06755058950083,163.8896848308676,163.71166798250113,163.5335001092827,
	163.35518127552922,163.17671154499328,162.99809098086314,162.81931964576273,162.6403976017516,
	162.46132491032483,162.28210163241297,162.10272782838192,161.9232035580333,161.74352888060366,
	161.56370385476532,161.38372853862552,161.20360298972693,161.02332726504733,160.8429014209996,
	160.6623255134318,160.48159959762688,160.300723728303,160.11969795961312,159.93852234514503,
	159.75719693792163,159.57572179040034,159.3940969544735,159.2123224814681,159.03039842214574,
	158.84832482670282,158.66610174477006,158.4837292254129,158.3012073171311,158.11853606785886,
	157.93571552496476,157.75274573525175,157.56962674495696,157.3863585997518,157.20294134474176,
	157.01937502446654,156.83565968289986,156.65179536344948,156.46778210895712,156.28361996169843,
	156.09930896338287,155.91484915515386,155.7302405775884,155.54548327069742,155.3605772739254,
	155.1755226261504,154.9903193656843,154.80496753027225,154.61946715709308,154.4338182827589,
	154.24802094331537,154.06207517424141,153.87598101044935,153.6897384862847,153.50334763552624,
	153.3168084913859,153.13012108650878,152.94328545297316,152.75630162229024,152.56916962540438,
	152.38188949269284,152.19446125396587,152.00688493846684,151.8191605748716,151.6312881912893,
	151.44326781526163,151.25509947376327,151.06678319320162,150.8783189994168,150.68970691768172,
	150.50094697270202,150.31203918861604,150.12298358899477,149.93378019684198,149.74442903459394,
	149.55493012411975,149.36528348672107,149.17548914313227,148.9855471135203,148.79545741748484,
	148.60522007405822,148.41483510170542,148.22430251832412,148.03362234124478,147.84279458723043,
	147.65181927247713,147.46069641261337,147.2694260227008,147.0780081172337,146.88644271013933,
	146.69472981477796,146.50286944394279,146.31086160986007,146.11870632418922,145.9264035980228,
	145.7339534418867,145.54135586574017,145.34861087897582,145.15571849041982,144.9626787083319,
	144.76949154040574,144.57615699376862,144.38267507498188,144.189045790041,143.9952691443756,
	143.80134514284984,143.60727378976213,143.41305508884585,143.21868904326917,143.0241756556351,
	142.82951492798216,142.63470686178414,142.43975145795045,142.2446487168265,142.04939863819357,
	141.85400122126947,141.65845646470856,141.46276436660193,141.2669249244779,141.07093813530219,
	140.87480399547826,140.67852250084752,140.48209364668986,140.28551742772385,140.08879383810725,
	139.891922871437,139.69490452075024,139.49773877852405,139.3004256366765,139.10296508656654,
	138.9053571189949,138.70760172420438,138.50969889188022,138.31164861115099,138.11345087058862,
	137.91510565820954,137.71661296147482,137.517972767291,137.3191850620106,137.12024983143291,
	136.9211670608045,136.72193673482013,136.52255883762336,136.3230333528073,136.12336026341544,
	135.92353955194235,135.72357120033493,135.5234551899927,135.3231915017692,135.12278011597263,
	134.92222101236703,134.7215141701733,134.52065956806985,134.31965718419437,134.11850699614442,
	133.91720898097878,133.71576311521875,133.5141693748491,133.31242773531983,133.1105381715472,
	132.90850065791497,132.70631516827635,132.50398167595503,132.3015001537469,132.09887057392166,
	131.89609290822438,131.69316712787727,131.49009320358164,131.28687110551917,131.08350080335438,
	130.87998226623637,130.67631546280083,130.47250036117208,130.26853692896532,130.06442513328878,
	129.86016494074622,129.65575631743909,129.45119922896913,129.24649364044092,129.04163951646458,
	128.8366368211583,128.63148551815144,128.42618557058725,128.22073694112603,128.01513959194818,
	127.80939348475745,127.60349858078426,127.39745484078925,127.19126222506682,126.98492069344873,
	126.77843020530797,126.57179071956288,126.36500219468103,126.1580645886835,125.95097785914923,
	125.74374196321976,125.53635685760358,125.32882249858112,125.12113884200977,124.91330584332906,
	124.7053234575659,124.49719163934024,124.28891034287074,124.08047952198054,123.87189913010373,
	123.66316912029129,123.45428944521785,123.24526005718843,123.03608090814544,122.82675194967587,
	122.61727313301886,122.40764440907338,122.1978657284064,121.98793704126092,121.77785829756476,
	121.56762944693942,121.3572504387093,121.14672122191101,120.93604174530347,120.72521195737788,
	120.51423180636847,120.30310124026319,120.09182020681513,119.8803886535542,119.6688065277991,
	119.45707377667007,119.24519034710157,119.03315618585589,118.82097123953695,118.60863545460468,
	118.39614877738998,118.18351115410996,117.97072253088403,117.75778285375044,117.54469206868323,
	117.33145012161015,117.1180569584308,116.9045125250358,116.69081676732634,116.47696963123465,
	116.26297106274502,116.04882100791582,115.83451941290194,115.62006622397845,115.40546138756476,
	115.19070485024996,114.97579655881877,114.76073646027865,114.5455245018878,114.33016063118427,
	114.11464479601587,113.89897694457153,113.68315702541346,113.46718498751082,113.25106078027426,
	113.03478435359195,112.81835565786692,112.60177464405567,112.38504126370822,112.16815546900976,
	111.95111721282365,111.73392644873591,111.51658313110192,111.29908721509402,111.08143865675152,
	110.86363741303215,110.6456834418659,110.42757670221003,110.2093171541071,109.99090475874432,
	109.77233947851582,109.55362127708648,109.33475011945883,109.11572597204201,108.8965488027234,
	108.67721858094318,108.45773527777109,108.23809886598683,108.0183093201627,107.79836661674996,
	107.57827073416809,107.35802165289739,107.1376193555753,106.91706382709607,106.69635505471436,
	106.47549302815267,106.25447773971283,106.03330918439163,105.811987360001,105.59051226729251,
	105.36888391008661,105.14710229540702,104.92516743361982,104.70307933857796,104.48083802777147,
	104.25844352248293,104.03589584794925,103.81319503352923,103.59034111287782,103.36733412412669,
	103.1441741100719,102.92086111836855,102.6973952017329,102.47377641815208,102.25000483110206,
	102.02608050977345,101.80200352930635,101.57777397103375,101.35339192273467,101.12885747889639,
	100.90417074098713,100.67933181773873,100.45434082544058,100.22919788824414,100.00390313847963,
	99.77845671698437,99.55285877344392,99.327109466746,99.101208965348,98.87515744765838,
	98.64895510243281,98.42260212918504,98.19609873861373,97.96944515304524,97.74264160689344,
	97.51568834713703,97.28858563381452,97.06133374053869,96.83393295503,96.60638357967052,
	96.37868593207864,96.15084034570563,95.92284717045473,95.69470677332367,95.46641953907127,
	95.23798587090927,95.00940619122026,94.78068094230252,94.55181058714268,94.3227956102177,
	94.09363651832658,93.86433384145313,93.63488813366138,93.4052999740236,93.17556996758354,
	92.94569874635502,92.71568697035765,92.48553532869069,92.25524454064657,92.0248153568656,
	91.7942485605326,91.56354496861765,91.33270543316196,91.10173084261068,90.87062212319388,
	90.63938024035751,90.40800620024594,90.17650105123776,89.9448658855365,89.71310184081784,
	89.48121010193557,89.24919190268747,89.01704852764367,88.78478131403847,88.55239165372862,
	88.31988099521885,88.08725084575761,87.8545027735042,87.62163840977071,87.38865945133523,
	87.15556766284152,86.92236487926986,86.68905300849418,86.45563403392185,86.22211001721973,
	85.98848310112777,85.75475551236256,85.520929564613,85.28700766162912,85.05299230040713,
	84.81888607447124,84.58469167725512,84.35041190558377,84.11604966325785,83.88160796474183,
	83.64708993895722,83.4124988331818,83.17783801705646,82.94311098670005,82.70832136893299,
	82.47347292560984,82.23856955806183,82.0036153116479,81.76861438041549,81.53357111186865,
	81.2984900118442,81.06337574949296,80.82823316236538,80.59306726159868,80.35788323720263,
	80.12268646344162,79.8874825043078,79.65227711908231,79.41707626797849,79.18188611786185,
	78.9467130480404,78.71156365611793,78.47644476390232,78.24136342336006,78.00632692260717,
	77.77134279192609,77.53641880979609,77.30156300892546,77.06678368227107,76.83208938903037,
	76.59748896059,76.3629915064135,76.12860641984946,75.89434338384092,75.66021237651378,
	75.426223676623,75.1923878688318,74.95871584879963,74.72521882805142,74.49190833860122,
	74.25879623730044,74.02589470988055,73.79321627465842,73.56077378587119,73.3285804366069,
	73.0966497612955,72.86499563772419,72.63363228854011,72.40257428220245,72.17183653334598,
	71.94143430251741,71.71138319524465,71.48169916040149,71.25239848782758,71.0234978051662,
	70.7950140738819,70.56696458442137,70.33936695048241,70.11223910235714,69.88559927931766,
	69.65946602101513,69.43385815786495,69.20879480039478,68.9842953275348,68.76037937383381,
	68.53706681558879,68.31437775587993,68.09233250850832,67.87095158083835,67.65025565555283,
	67.43026557133429,67.21100230249195,66.99248693756084,66.77474065690508,66.55778470936477,
	66.34164038799231,66.12632900493026,65.9118718654908,65.6982902415021,65.48560534399411,
	65.27383829530214,65.06301010067303,64.85314161946319,64.64425353602448,64.43636633037639,
	64.22950024876909,64.02367527424374,63.81891109729983,63.61522708678121,63.412642261093346,
	63.21117525986504,63.01084431616742,62.811667229400925,62.61366133896017,62.41684349878238,
	62.22123005288193,62.02683681196862,61.833679031242156,61.64177138944922,61.45112796928225,
	61.26176223919294,61.07368703668406,60.886914553136364,60.701456320217744,60.517323197913576,
	60.33452536420746,60.15307230643289,59.97297281430726,59.794234974649996,59.61686616777802,
	59.440873065563444,59.266261631129154,59.09303712015088,58.9212040837261,58.75076637276361,
	58.58172714384099,58.414088866471474,58.247853331715476,58.083021662069626,57.91959432255959,
	57.75757113296156,57.59695128107385,57.43773333695807,57.279915268068194,57.12349445518492,
	56.968467709072584,56.814831287776066,56.662580914476486,56.511711795825164,56.3622186406775,
	56.21409567915073,56.06733668193137,55.92193497976179,55.777883483037655,55.63517470145194,
	55.493800763623916,55.353753436656014,55.215024145564165,55.077603992531714,54.94148377594043,
	54.80665400913601,54.6731049388891,54.54082656351656,54.409808650631696,54.28004075449499,
	54.15151223294082,54.02421226385876,53.89812986121119,53.773253890571894,53.6495730841732,
	53.52707605545199,53.40575131308719,53.28558727452377,53.16657227898098,53.04869459994344,
	52.93194245713675,52.816304027990235,52.70176745859138,52.58832087413753,52.47595238889202,
	52.364650115653056,52.25440217474417,52.14519670253647,52.037021859513565,51.929865837890134,
	51.82371686879658,51.71856322904179,51.61439324746678,51.511195310902345,51.40895786974365,
	51.30766944315542,51.20731862392058,51.10789408294621,51.00938457343981,50.91177893476909,
	50.81506609601864,50.71923507925594,50.62427500251985,50.530175082543714,50.43692463722554,
	50.34451308785688,50.2529299611224,50.162164890881215,50.072207619741015,49.9830480004358,
	49.89467599701735,49.80708168587072,49.7202552565631,49.634187012535556,49.548867371646544,
	49.46428686657581,49.38043614509719,49.29730597022778,49.21488722026153,49.13317088869455,
	49.05214808404884,48.97181002960126,48.89214806302437,48.8131536359446,48.73481831342436,
	48.65713377337286,48.58009180587293,48.50368431254183,48.42790330564093,48.352740907335175,
	48.278189348801355,48.204240969314746,48.130888215296345,48.058123639324414,47.98593989911366,
	47.914329756465335,47.84328607619133,47.77280182501506,47.702870070451795,47.6334839796713,
	47.56463681834465,47.49632194947802,47.4285328322351,47.36126302075045,47.29450616293543,
	47.228255999278616,47.162506361642116,47.09725117205552,47.03248444150869,46.96820026874488,
	46.904392839055326,46.841056423076395,46.77818537559048,46.71577413433147,46.65381721879581,
	46.592309229059936,46.53124484460488,46.47061882314863,46.410425999487174,46.35066128434445,
	46.291319663232,46.23239619531889,46.1738860123119,46.11578431734698,46.058086383891876,
	46.00078755466041,45.94388324053891,45.88736891952444,45.831240135675834,45.77549249807717,
	45.720121679814014,45.66512341696255,45.61049350759191,45.556227810779326,45.50232224563885,
	45.4487727903629,45.39557548127745,45.34272641191021,45.29022173207239,45.238057646953415,
	45.186230416229165,45.134736353183285,45.08357182384165,45.03273324612001,44.982217088984456,
	44.93201987162511,44.882138162642434,44.832568579246356,44.7833077864681,44.73435249638445,
	44.685699467354496,44.63734550326872,44.58928745281011,44.54152220872748,44.49404670712059,
	44.446857926737074,44.39995288828101,44.353328653732916,44.30698232568119,44.260911046664695,
	44.21511199852634,44.169582401777674,44.12431951497411,44.079320634100874,44.03458309196929,
	43.99010425762344,43.94588153575693,43.901912366139655,43.858194223054404,43.81472461474322,
	43.771501082863146,43.72852120195159,43.68578257890065,43.6432828524409,43.60101969263367,
	43.558990800372555,43.51719390689337,43.475626773292596,43.43428719005429,43.393172976585205,
	43.35228198073728,43.31161207844384,43.27116117314725,43.23092719545586,43.190908102694905,
	43.151101878488134,43.111506532346816,43.072120099265604,43.03294063932597,42.993966237306026,
	42.95519500229746,42.916625067329015,42.87825458899656,42.840081747099624,42.802104744284115,
	42.76432180569144,42.726731178613576,42.68933113215416,42.65211995689554,42.61509596457139,
	42.57825748774527,42.5416028794945,42.505130513099616,42.46883878173918,42.432726098189846,
	42.39679089453151,42.361031621857734,42.325446749990896,42.29003476720242,42.25479417993767,
	42.21972351254576,42.184821307013664,42.150086122705176,42.115516536104124,42.081111140562065,
	42.04686854605019,42.01278737891556,41.978866281641324,41.94510391261109,41.911498945877305,
	41.87805007093347,41.84475599249021,41.811615430255195,41.77862711871662,41.745789806930446,
	41.713102258311125,41.680563250425855,41.64817157479226,41.61592603667942,41.583825454912294,
	41.551868661679286,41.520054502343,41.4883818352543,41.45684953156917,41.42545647506882,
	41.394201561982634,41.36308370081409,41.33210181216945,41.30125482858934,41.270541694383084,
	41.239961365465604,41.20951280919717,41.17919500422556,41.149006940330985,41.11894761827334,
	41.08901604964194,41.05921125670786,41.02953227227842,40.999978139554116,40.970547911987836,
	40.94124065314638,40.91205543657406,40.88299134565851,40.8540474734988,40.82522292277534,
	40.79651680562212,40.767928243500805,40.739456367076855,40.71110031609763,40.68285923927235,
	40.65473229415398,40.62671864702292,40.59881747277258,40.571027954796634,40.54334928487813,
	40.51578066308022,40.48832129763869,40.46097040485602,40.4337272089972,40.406590942187044,
	40.379560844309175,40.35263616290647,40.32581615308305,40.29910007740786,40.272487205819495,
	40.2459768155327,40.219568190946205,40.19326062355184,40.167053411845224,40.14094586123764,
	40.114937283969255,40.08902699902376,40.063214332044105,40.0374986152496,40.01187918735432,
	39.98635539348645,39.9609265851092,39.93559211994254,39.910351361886406,39.88520368094467,
	39.86014845315065,39.8351850604933,39.8103128908448,39.785531337889076,39.76083980105124,
	39.73623768542832,39.71172440172078,39.68729936616508,39.66296200044508,39.638711731717464,
	39.61454799240733,39.59047022024029,39.56647785815514,39.542570354242045,39.518747161681645,
	39.49500773868491,39.47135154843399,39.447778059023804,39.424286743404444,39.400877079324545,
	39.37754854927518,39.354300640434836,39.33113284461493,39.308044658206185,39.28503558212584,
	39.262105121765394,39.23925278693919,39.21647809183375,39.193780554957776,39.17115969909276,
	39.14861505124435,39.1261461425944,39.10375250845369,39.08143368821515,39.05918922530788,
	39.03701866715177,39.01492156511263,38.99289747445806,38.97094595431387,38.949066567620974,
	38.92725888109311,38.905522465174876,38.883856894000516,38.86226174535308,38.840736600624325,
	38.819281044775046,38.79789466629584,38.77657705716858,38.75532781282829,38.73414653212556,
	38.713032817289346,38.6919862738905,38.671006510805505,38.65009314018083,38.62924577739784,
	38.60846404103783,38.58774755284799,38.56709593770736,38.54650882359353,38.525985841549634,
	38.50552662565175,38.485130812976905,38.46479804357117,38.44452796041851,38.42432020940975,
	38.40417443931216,38.38409030173918,38.36406745112089,38.3441055446744,38.324204242375025,
	38.30436320692756,38.28458210373806,38.264860600885875,38.245198369096094,38.225595081712356,
	38.20605041466998,38.18656404646929,38.167135658149554,38.14776493326304,38.1284515578494,
	38.10919522041043,38.08999561188519,38.07085242562527,38.051765357370535,38.03273410522507,
	38.0137583696334,37.99483785335704,37.97597226145144,37.95716130124291,37.93840468230616,
	37.91970211644191,37.901053317654885,37.88245800213186,37.86391588822034,37.845426696407095,
	37.82699014929726,37.808605971593494,37.79027389007547,37.771993633579655,37.753764932979166,
	37.735587521164085,37.717461133021786,37.69938550541766,37.681360377176006,37.66338548906115,
	37.64546058375872,37.62758540585731,37.609759701830185,37.591983220017255,37.57425571060736,
	37.55657692562052,37.538946618890705,37.52136454604853,37.50383046450433,37.48634413343128,
	37.46890531374891,37.45151376810658,37.434169260867314,37.416871558091756,37.39962042752227,
	37.382415638567316,37.36525696228596,37.34814417137247,37.33107704014123,37.31405534451179,
	37.297078861994,37.280147371673394,37.26326065419667,37.24641849175746,37.229620668082106,
	37.21286696841568,37.196157179488935,37.17949108958364,37.162868488397045,37.146289167112286,
	37.129752918363565,37.113259536223026,37.09680881618783,37.08040055516736,37.06403455147053,
	37.04771060479325,37.0314285162061,37.01518808814198,36.998989124384096,36.98283143005392,
	36.96671481159928,36.95063907678275,36.934604034669945,36.918609495618114,36.9026552712647,
	36.8867411745162,36.870867019537044,36.85503262173849,36.839237797767915,36.82348236549793,
	36.80776614401578,36.79208895361283,36.7764506157741,36.76085095316803,36.74528978963618,
	36.72976695018322,36.71428226096686,36.69883554928811,36.68342664358134,36.66805537340468,
	36.6527215694305,36.637425063435764,36.622165688292874,36.606943277960205,36.591757667473075,
	36.57660869293449,36.561496191506315,36.546420001400264,36.53137996186912,36.51637591319801,
	36.501407696695836,36.48647515468662,36.47157813050116,36.456716468468585,36.441890013908115,
	36.42709861312085,36.41234211338165,36.39762036293111,36.382933210967586,36.36828050763935,
	36.35366210403678,36.33907785218469,36.32452760503461,36.3100112164573,36.29552854123521,
	36.281079435055105,36.26666375450074,36.252281357045575,36.23793210104552,36.223615845732,
	36.209332451204666,36.19508177842461,36.180863689207314,36.166678046215935,36.15252471295445,
	36.13840355376091,36.12431443380089,36.110257219060856,36.096231776341675,36.08223797325211,
	36.068275678202504,36.05434476039838,36.04044508983424,36.02657653728737,36.012738974311574,
	35.998932273231205,35.98515630713514,35.97141094987073,35.95769607601016,35.94401156096161,
	35.93035728077792,35.91673311228216,35.903138933026895,35.889574621288496,35.876040056061655,
	35.86253511705376,35.849059684679524,35.83561364005546,35.82219686499458,35.80880924200104,
	35.795450654264876,35.782120985656775,35.76882012072289,35.75554794467974,35.74230434340914,
	35.729089203453114,35.715902412008944,35.70274385692425,35.689613426692034,35.67651101044595,
	35.66343649795532,35.65038977962055,35.63737074646833,35.62437929014694,35.6114153029217,
	35.5984786776703,35.585569307878316,35.57268708763465,35.55983191162711,35.54700367512913,
	35.53420227403773,35.521427604789906,35.50867956442903,35.49595805080697,35.483262961412045,
	35.47059419570489,35.457951652777155,35.44533523250086,35.43274483532893,35.42018036224913,
	35.407641714802175,35.39512879507319,35.382641505687765,35.370179749808095,35.35774343112903,
	35.34533245387437,35.33294672279293,35.32058614315491,35.30825062074808,35.29594006187411,
	35.28365437334491,35.27139346247898,35.25915723709784,35.24694560552242,35.234758476569596,
	35.22259575954856,35.21045736425748,35.19834320097997,35.186253180481664,35.174187214006935,
	35.16214521327537,35.1501270904786,35.13813275827688,35.12616212979591,35.11421511862355,
	35.10229163880653,35.09039160484743,35.07851493170136,35.066661534772905,35.05483132991301,
	35.04302423345035,35.031240162058246,35.01947903293638,35.00774076369077,34.9960252723586,
	34.98433247740537,34.97266229772193,34.96101465262149,34.94938946183694,34.937786645517775,
	34.926206124227434,34.91464781894039,34.9031116510394,34.891597542312795,34.88010541495162,
	34.86863519154707,34.8571867950877,34.84576014895673,34.834355176929535,34.82297180317085,
	34.8116099522323,34.80026954904976,34.78895051894075,34.777652787602015,34.76637628110688,
	34.75512092590283,34.743886648809,34.73267337701372,34.721481038072085,34.710309559903536,
	34.69915887078943,34.68802889937075,34.67691957464561,34.665830825967035,34.65476258304058,
	34.64371477592202,34.63268733501511,34.62168019106928,34.610693275177404,34.59972651877353,
	34.58877985363074,34.577853211858915,34.56694652590256,34.55605972853861,34.54519275287438,
	34.534345532345306,34.52351800071298,34.512710092062946,34.5019217408027,34.49115288165956,
	34.48040344967869,34.46967338022104,34.45896260896131,34.44827107188602,34.4375987052915,
	34.426945445781875,34.41631123026719,34.405695995961466,34.39509968038071,34.38452222134113,
	34.373963556957136,34.36342362563951,34.35290236609359,34.34239971731734,34.33191561859958,
	34.321450009518124,34.31100282993803,34.300574020009826,34.290163520167575,34.279771271127366,
	34.269397213885334,34.25904128971608,34.248703440170864,34.23838360707592,34.22808173253078,
	34.21779775890659,34.207531628844386,34.19728328525355,34.18705267130999,34.176839730454695,
	34.166644406392024,34.15646664308806,34.146306384769105,34.13616357592001,34.12603816128269,
	34.11593008585452,34.10583929488674,34.09576573388299,34.08570934859778,34.07567008503494,
	34.06564788944612,34.055642708329316,34.045654488427395,34.03568317672665,34.02572872045524,
	34.01579106708187,34.00587016431424,33.995965960097756,33.98607840261392,33.976207440258776,
	33.96635302172093,33.95651509586353,33.94669361179901,33.93688851886912,33.92709976664346,
	33.91732730491824,33.90757108371495,33.89783105327899,33.888107164078356,33.87839936680237,
	33.86870761236028,33.859031851880154,33.84937203670742,33.839728118403706,33.8301000487456,
	33.820487779723216,33.81089126353921,33.80131045260739,33.79174529955146,33.78219575720397,
	33.772661778604935,33.76314331700073,33.75364032584288,33.74415275878693,33.73468056969113,
	33.725223712615424,33.71578214182022,33.70635581176527,33.69694467710848,33.68754869270486,
	33.67816781360531,33.668801995055574,33.659451192495126,33.65011536155598,33.64079445806178,
	33.631488438026466,33.62219725765348,33.612920873334424,33.6036592416482,33.594412319359876,
	33.5851800634196,33.57596243096163,33.566759379303285,33.55757086594389,33.54839684856376,
	33.53923728502325,33.53009213336162,33.520961351796245,33.51184489872139,33.50274273270737,
	33.49365481249955,33.48458109701735,33.47552154535332,33.466476116772085,33.45744477070956,
	33.448427466771854,33.439424164734376,33.43043482454097,33.42145940630288,33.41249787029794,
	33.40355017696956,33.39461628692588,33.3856961609389,33.37678975994347,33.36789704503655,
	33.35901797747618,33.35015251868076,33.341300630227984,33.33246227385421,33.32363741145339,
	33.31482600507633,33.30602801692982,33.29724340937581,33.28847214493053,33.279714186263654,
	33.270969496197566,33.262238037706446,33.253519773915485,33.24481466810008,33.23612268368504,
	33.22744378424378,33.21877793349749,33.210125095314446,33.201485233709114,33.19285831284145,
	33.18424429701607,33.17564315068156,33.167054838429635,33.15847932499441,33.14991657525169,
	33.14136655421815,33.13282922705065,33.12430455904544,33.11579251563754,33.10729306239983,
	33.09880616504255,33.090331789412346,33.081869901491736,33.07342046739837,33.0649834533842,
	33.05655882583498,33.048146551269355,33.03974659633837,33.03135892782465,33.022983512641744,
	33.01462031783351,33.006269310573344,32.997930458163594,32.98960372803484,32.981289087745246,
	32.972986504979964,32.964695947550375,32.95641738339351,32.948150780571396,32.93989610727039,
	32.931653331800625,32.92342242259522,32.91520334820985,32.90699607732192,32.898800578730146,
	32.89061682135374,32.88244477423198,32.874284406523465,32.86613568750556,32.85799858657386,
	32.84987307324145,32.841759117138416,32.833656688011274,32.82556575572227,32.817486290248965,
	32.80941826168344,32.801361640231924,32.793316396214124,32.78528250006266,32.77725992232249,
	32.76924863365043,32.76124860481449,32.75325980669338,32.74528221027596,32.73731578666065,
	32.72936050705494,32.721416342774816,32.713483265244236,32.70556124599457,32.69765025666413,
	32.689750268997564,32.68186125484538,32.673983186163426,32.66611603501237,32.65825977355714,
	32.65041437406647,32.642579808912394,32.63475605056968,32.62694307161536,32.61914084472827,
	32.61134934268849,32.60356853837691,32.59579840477466,32.58803891496271,32.58029004212132,
	32.57255175952962,32.56482404056508,32.55710685870301,32.5494001875162,32.5417040006743,
	32.53401827194351,32.52634297518597,32.51867808435938,32.51102357351655,32.503379416804876,
	32.495745588465965,32.488122062835124,32.480508814340965,32.472905817504866,32.46531304694065,
	32.4577304773541,32.4501580835424,32.442595840393935,32.43504372288768,32.42750170609278,
	32.41996976516822,32.41244787536231,32.404936012012314,32.39743415054398,32.3899422664712,
	32.3824603353955,32.37498833300571,32.36752623507746,32.36007401747294,32.35263165614028,
	32.34519912711329,32.33777640651104,32.3303634705374,32.322960295480705,32.315566857713364,
	32.308183133691415,32.30080909995417,32.293444733123856,32.28609000990513,32.2787449070603,
	32.27140940150567,32.26408347016784,32.2567670900777,32.24946023834676,32.24216289216671,
	32.234875028809164,32.227596625625175,32.220327660044966,32.21306810957752,32.20581795181021,
	32.198577164408476,32.19134572511543,32.18412361175152,32.17691080221417,32.16970727447746,
	32.1625130065917,32.155327976683175,32.14815216295375,32.14098554368049,32.133828097215435,
	32.12667980198512,32.11954063649033,32.112410579305724,32.10528960907955,32.098177704533256,
	32.09107484446116,32.08398100773016,32.076896173279415,32.069820320119966,32.06275342733444,
	32.05569547407675,32.04864643957174,32.04160630311491,32.03457504407205,32.027552641878955,
	32.0205390760411,32.013534326133396,32.00653837179971,31.999551192752786,31.99257276877375,
	31.985603079711908,31.978642105484422,31.97168982607599,31.96474622153856,31.95781127199103,
	31.950884957618978,31.94396725867432,31.937058155475054,31.930157628404977,31.923265657913333,
	31.916382224514603,31.909507308788182,31.902640891378084,31.895782952992697,31.888933474404443,
	31.882092436449565,31.875259820027818,31.86843560610216,31.86161977569851,31.85481230990551,
	31.848013189874184,31.841222396817685,31.834439912011067,31.827665716790968,31.820899792555362,
	31.814142120763318,31.807392682934672,31.800651460649835,31.793918435549504,31.78719358933438,
	31.78047690376494,31.77376836066117,31.767067941902308,31.76037562942661,31.753691405231052,
	31.747015251371128,31.740347149960556,31.73368708317106,31.727035033232134,31.720390982430747,
	31.713754913111128,31.707126807674534,31.700506648578994,31.693894418339074,31.687290099525608,
	31.680693674765497,31.674105126741477,31.667524438191837,31.660951591910216,31.654386570745373,
	31.64782935760097,31.641279935435236,31.634738287260934,31.62820439614493,31.62167824520808,
	31.61515981762498,31.608649096623758,31.602146065485766,31.595650707545484,31.589163006190212,
	31.582682944859883,31.5762105070468,31.56974567629549,31.5632884362024,31.556838770415805,
	31.55039666263545,31.543962096612425,31.537535056148926,31.531115525098063,31.52470348736362,
	31.518298926899856,31.511901827711323,31.505512173852615,31.499129949428184,31.492755138592145,
	31.486387725548056,31.480027694548717,31.473675029895993,31.467329715940554,31.460991737081734,
	31.454661077767305,31.448337722493267,31.442021655803714,31.435712862290554,31.429411326593357,
	31.42311703339915,31.41682996744227,31.410550113504062,31.404277456412807,31.39801198104351,
	31.391753672317602,31.38550251520289,31.379258494713316,31.373021595908735,31.366791803894778,
	31.36056910382268,31.354353480889,31.34814492033557,31.341943407449243,31.335748927561667,
	31.329561466049217,31.323381008332735,31.317207539877355,31.311041046192372,31.304881512831,
	31.2987289253903,31.29258326951087,31.28644453087676,31.28031269521531,31.2741877482969,
	31.268069675934864,31.261958463985255,31.25585409834673,31.249756564960343,31.24366584980935,
	31.23758193891915,31.23150481835698,31.225434474231864,31.21937089269438,31.21331405993654,
	31.20726396219157,31.201220585733807,31.19518391687852,31.189153941981736,31.183130647440073,
	31.177114019690606,31.171104045210708,31.165100710517873,31.159104002169553,31.153113906763064,
	31.147130410935304,31.141153501362776,31.135183164761276,31.12921938788581,31.123262157530426,
	31.11731146052809,31.111367283750518,31.105429614107976,31.099498438549244,31.09357374406135,
	31.087655517669482,31.081743746436842,31.07583841746449,31.069939517891182,31.06404703489325,
	31.05816095568442,31.05228126751578,31.04640795767542,31.04054101348853,31.034680422317113,
	31.028826171559867,31.022978248652105,31.017136641065502,31.011301336308055,31.005472321923943,
	30.999649585493312,30.9938331146322,30.988022896992398,30.98221892026128,30.976421172161693,
	30.97062964045185,30.96484431292514,30.959065177410015,30.953292221769836,30.947525433902836,
	30.94176480174186
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	223.48497105114055,223.38189845992403,223.27860685925808,223.1750964381731,223.0713673864221,
	222.9674198944693,222.86325415347793,222.75887035529922,222.65426869246036,222.54944935815303,
	222.44441254622248,222.33915845115538,222.23368726806933,222.1279991927009,222.0220944213952,
	221.91597315109422,221.80963557932594,221.7030819041937,221.59631232436487,221.48932703906038,
	221.38212624804362,221.27471015161018,221.167078950577,221.05923284627173,220.9511720405225,
	220.84289673564734,220.73440713444393,220.62570344017922,220.51678585657945,220.4076545878197,
	220.2983098385141,220.18875181370572,220.0789807188566,219.968996759838,219.85880014292044,
	219.74839107476433,219.63776976240973,219.52693641326735,219.41589123510863,219.30463443605655,
	219.19316622457592,219.08148680946462,218.96959639984354,218.8574952051483,218.74518343511923,
	218.63266129979326,218.51992900949395,218.4069867748235,218.29383480665322,218.18047331611507,
	218.0669025145928,217.95312261371356,217.83913382533896,217.7249363615567,217.6105304346721,
	217.4959162572,217.38109404185587,217.26606400154802,217.15082634936923,217.03538129858853,
	216.91972906264337,216.80386985513144,216.6878038898027,216.57153138055168,216.4550525414096,
	216.33836758653658,216.22147673021382,216.1043801868364,215.9870781709053,215.86957089702005,
	215.75185857987142,215.6339414342339,215.51581967495835,215.39749351696491,215.27896317523567,
	215.16022886480786,215.0412908007661,214.92214919823613,214.80280427237753,214.6832562383768,
	214.56350531144068,214.4435517067892,214.32339563964922,214.2030373252475,214.08247697880435,
	213.9617148155269,213.84075105060285,213.71958589919387,213.59821957642924,213.4766522973997,
	213.35488427715106,213.23291573067806,213.11074687291827,212.98837791874595,212.86580908296617,
	212.7430405803085,212.62007262542164,212.49690543286698,212.37353921711332,212.2499741925307,
	212.12621057338495,212.00224857383205,211.87808840791237,211.7537302895453,211.6291744325237,
	211.50442105050863,211.37947035702348,211.25432256544937,211.12897788901927,211.00343654081303,
	210.87769873375223,210.7517646805951,210.62563459393107,210.4993086861764,210.37278716956857,
	210.24607025616166,210.1191581578215,209.99205108622087,209.86474925283446,209.73725286893438,
	209.60956214558553,209.48167729364062,209.35359852373608,209.22532604628697,209.09686007148295,
	208.96820080928367,208.83934846941415,208.71030326136082,208.5810653943667,208.45163507742782,
	208.32201251928834,208.19219792843668,208.0621915131013,207.93199348124688,207.80160404056966,
	207.67102339849404,207.54025176216848,207.40928933846115,207.2781363339567,207.14679295495196,
	207.0152594074523,206.88353589716795,206.75162262950994,206.6195198095871,206.4872276422016,
	206.35474633184594,206.22207608269926,206.08921709862383,205.9561695831613,205.82293373952956,
	205.6895097706195,205.55589787899115,205.42209826687073,205.28811113614725,205.15393668836913,
	205.0195751247414,204.8850266461221,204.75029145301912,204.6153697455876,204.4802617236262,
	204.34496758657457,204.2094875335101,204.0738217631451,203.9379704738238,203.8019338635193,
	203.66571212983106,203.52930546998178,203.39271408081476,203.25593815879094,203.11897789998648,
	202.98183350008983,202.84450515439914,202.70699305781966,202.5692974048611,202.43141838963496,
	202.29335620585232,202.15511104682088,202.01668310544284,201.87807257421244,201.7392796452132,
	201.60030451011596,201.46114736017628,201.32180838623216,201.18228777870192,201.04258572758144,
	200.90270242244253,200.7626380524304,200.62239280626133,200.48196687222094,200.34136043816164,
	200.2005736915008,200.05960681921854,199.91846000785577,199.77713344351207,199.6356273118438,
	199.493941798062,199.35207708693054,199.2100333627643,199.06781080942702,198.9254096103297,
	198.78282994842857,198.64007200622325,198.49713596575518,198.35402200860557,198.21073031589395,
	198.06726106827628,197.923614445943,197.77979062861792,197.6357897955561,197.4916121255424,
	197.34725779688986,197.20272698743815,197.0580198745518,196.91313663511897,196.76807744554972,
	196.62284248177454,196.47743191924295,196.33184593292188,196.18608469729443,196.04014838635828,
	195.89403717362438,195.74775123211575,195.6012907343656,195.45465585241658,195.3078467578192,
	195.1608636216303,195.0137066144124,194.86637590623172,194.71887166665738,194.57119406476014,
	194.4233432691109,194.27531944777994,194.1271227683355,193.97875339784258,193.83021150286189,
	193.6814972494488,193.53261080315212,193.3835523290131,193.23432199156423,193.08491995482837,
	192.93534638231762,192.7856014370323,192.63568528145987,192.48559807757417,192.33533998683416,
	192.18491117018314,192.03431178804794,191.88354200033754,191.7326019664427,191.5814918452346,
	191.43021179506434,191.27876197376173,191.12714253863476,190.97535364646842,190.8233954535243,
	190.67126811553928,190.51897178772506,190.3665066247674,190.21387278082503,190.06107040952932,
	189.90809966398317,189.75496069676043,189.6016536599052,189.448178704931,189.2945359828203,
	189.14072564402355,188.98674783845874,188.83260271551055,188.67829042402983,188.52381111233296,
	188.36916492820114,188.21435201887977,188.05937253107794,187.90422661096784,187.748914404184,
	187.59343605582293,187.43779171044235,187.28198151206084,187.12600560415717,186.96986412966984,
	186.8135572309964,186.65708504999316,186.50044772797457,186.3436454057127,186.1866782234368,
	186.02954632083268,185.8722498370427,185.7147889106646,185.55716367975168,185.399374281812,
	185.24142085380822,185.08330353215683,184.92502245272792,184.76657775084493,184.60796956128402,
	184.44919801827368,184.2902632554945,184.1311654060787,183.97190460260978,183.8124809771222,
	183.65289466110076,183.49314578548078,183.33323448064718,183.17316087643465,183.01292510212693,
	182.85252728645682,182.6919675576055,182.5312460432025,182.3703628703255,182.20931816549958,
	182.0481120546976,181.8867446633391,181.72521611629077,181.56352653786578,181.4016760518236,
	181.2396647813699,181.077492849156,180.9151603772787,180.75266748728046,180.5900143001486,
	180.42720093631516,180.26422751565715,180.10109415749582,179.93780098059653,179.77434810316882,
	179.61073564286596,179.44696371678475,179.28303244146545,179.11894193289135,178.95469230648905,
	178.79028367712783,178.62571615911958,178.46098986621868,178.29610491162197,178.1310614079683,
	177.96585946733853,177.80049920125538,177.63498072068313,177.46930413602792,177.30346955713682,
	177.1374770932984,176.9713268532424,176.8050189451393,176.6385534766005,176.47193055467812,
	176.30515028586484,176.1382127760939,175.97111813073857,175.8038664546126,175.6364578519698,
	175.46889242650386,175.3011702813484,175.13329151907683,174.96525624170226,174.79706455067722,
	174.6287165468938,174.46021233068353,174.2915520018171,174.12273565950437,173.95376340239446,
	173.7846353285753,173.61535153557378,173.44591212035576,173.27631717932567,173.1065668083268,
	172.9366611026409,172.76660015698832,172.5963840655278,172.42601292185645,172.2554868190098,
	172.08480584946147,171.91397010512338,171.74297967734543,171.57183465691563,171.40053513405996,
	171.2290811984424,171.05747293916446,170.88571044476583,170.71379380322375,170.5417231019531,
	170.36949842780655,170.19711986707406,170.02458750548342,169.8519014281996,169.6790617198252,
	169.50606846440002,169.3329217454012,169.1596216457431,168.98616824777747,168.81256163329297,
	168.63880188351553,168.46488907910808,168.2908233001705,168.11660462623988,167.94223313628993,
	167.7677089087314,167.59303202141197,167.41820255161585,167.24322057606426,167.06808617091497,
	166.89279941176247,166.7173603736378,166.54176913100872,166.36602575777945,166.19013032729057,
	166.01408291231937,165.83788358507937,165.66153241722057,165.48502947982922,165.30837484342783,
	165.13156857797534,164.9546107528667,164.7775014369331,164.60024069844195,164.4228286050966,
	164.24526522403653,164.06755062183726,163.88968486451017,163.7116680175027,163.53350014569807,
	163.35518131341544,163.17671158440967,162.99809102187152,162.8193196884273,162.6403976461393,
	162.46132495650505,162.28210168045814,162.1027278783673,161.92320361003715,161.74352893470757,
	161.56370391105395,161.383728597187,161.20360305065302,161.02332732843337,160.84290148694492,
	160.66232558203959,160.48159966900465,160.3007238025625,160.11969803687057,159.93852242552143,
	159.75719702154274,159.5757218773971,159.39409704498206,159.21232257563017,159.03039852010878,
	158.84832492862006,158.66610185080108,158.4837293357236,158.30120743189408,158.11853618725377,
	157.9357156491784,157.75274586447853,157.56962687939898,157.38635873961948,157.20294149025392,
	157.01937517585085,156.83565984039313,156.6517955272981,156.4677822794174,156.28362013903697,
	156.09930914787708,155.9148493470923,155.73024077727126,155.545483478437,155.3605774900466,
	155.17552285099123,154.99031959959626,154.8049677736212,154.61946741025943,154.4338185461386,
	154.24802121732017,154.06207545929976,153.87598130700687,153.689738794805,153.50334795649167,
	153.31680882529815,153.13012143388988,152.94328581436602,152.75630199825974,152.56917001653818,
	152.38188989960224,152.1944616772869,152.00688537886091,151.81916103302711,151.63128866792212,
	151.4432683111166,151.25509998961522,151.06678372985655,150.8783195577132,150.68970749849197,
	150.50094757693347,150.3120398172127,150.12298424293877,149.93378087715482,149.74442974233838,
	149.55493086040136,149.36528425268997,149.1754899399849,148.98554794250128,148.79545827988898,
	148.60522097123246,148.4148360350509,148.2243034892985,148.0336233513644,147.84279563807283,
	147.6518203656832,147.46069754989023,147.26942720582426,147.07800934805115,146.88644399057253,
	146.69473114682611,146.5028708296856,146.31086305146104,146.118707823899,145.92640515818266,
	145.73395506493216,145.54135755420495,145.34861263549553,145.1557203177364,144.96268060929768,
	144.76949351798783,144.5761590510537,144.38267721518096,144.18904801649435,143.995271460558,
	143.80134755237603,143.60727629639254,143.41305769649213,143.2186917560006,143.0241784776849,
	142.82951786375392,142.6347099158588,142.4397546350935,142.24465202199517,142.0494020765449,
	141.85400479816806,141.65846018573498,141.46276823756156,141.26692895140985,141.07094232448873,
	140.87480835345457,140.67852703441204,140.4820983629147,140.28552233396593,140.08879894201957,
	139.8919281809809,139.6949100442074,139.49774452450976,139.30043161415284,139.10297130485654,
	138.90536358779684,138.707608453607,138.50970589237852,138.31165589366242,138.11345844647033,
	137.91511353927575,137.71662116001548,137.51798129609082,137.31919393436903,137.12025906118478,
	136.92117666234165,136.72194672311377,136.5225692282474,136.32304416196257,136.12337150795503,
	135.92355124939792,135.7235833689437,135.5234678487262,135.32320467036251,135.1227938149555,
	134.92223526309544,134.72152899486295,134.52067498983092,134.3196732270671,134.11852368513686,
	133.9172263421057,133.71578117554193,133.5141881625198,133.31244727962246,133.11055850294485,
	132.90852180809708,132.70633717020777,132.5040045639276,132.30152396343271,132.0988953424286,
	131.89611867415405,131.69319393138497,131.49012108643882,131.28690011117874,131.08353097701817,
	130.88001365492545,130.67634811542885,130.47253432862144,130.26857226416632,130.06446189130207,
	129.86020317884854,129.6557960952124,129.45124060839333,129.2465366859905,129.04168429520882,
	128.83668340286593,128.63153397539887,128.4262359788719,128.22078937898374,128.0151941410754,
	127.80945023013852,127.60355761082364,127.3975162474492,127.19132610401044,126.98498714418893,
	126.77849933136247,126.57186262861515,126.36507699874797,126.15814240428983,125.95105880750886,
	125.74382617042436,125.53644445481892,125.32891362225119,125.12123363406911,124.91340445142362,
	124.70542603528291,124.49729834644711,124.28902134556377,124.08059499314354,123.872019249577,
	123.66329407515146,123.4544194300691,123.24539527446512,123.03622156842725,122.82689827201533,
	122.61742534528223,122.40780274829517,122.19803044115804,121.98810838403456,121.77803653717213,
	121.56781486092699,121.35744331578994,121.14692186241321,120.93625046163838,120.72542907452537,
	120.5144576623825,120.30333618679767,120.09206460967073,119.88064289324737,119.66907100015376,
	119.45734889343314,119.24547653658328,119.0334538935957,118.82128092899643,118.60895760788803,
	118.39648389599343,118.18385975970165,117.97108516611483,117.75816008309748,117.5450844793274,
	117.33185832434859,117.11848158862631,116.90495424360422,116.6912762617636,116.47744761668507,
	116.26346828311243,116.04933823701936,115.83505745567825,115.62062591773196,115.4060436032684,
	115.19131049389779,114.97642657283309,114.76139182497344,114.54620623699091,114.33086979742043,
	114.1153824967537,113.899744327536,113.68395528446739,113.4680153645075,113.2519245669846,
	113.03568289370865,112.81929034908897,112.60274694025638,112.38605267719011,112.16920757284959,
	111.95221164331139,111.73506490791154,111.51776738939346,111.30031911406112,111.08272011193907,
	110.86497041693768,110.64707006702571,110.4290191044089,110.21081757571586,109.99246553219123,
	109.773963029896,109.55531012991622,109.33650689857865,109.1175534076766,108.89844973470292,
	108.6791959630929,108.45979218247619,108.24023848893876,108.02053498529499,107.80068178137023,
	107.58067899429449,107.36052674880722,107.14022517757424,106.91977442151682,106.6991746301535,
	106.4784259619551,106.25752858471354,106.0364826759251,105.81528842318805,105.59394602461607,
	105.37245568926744,105.15081763759096,104.92903210188874,104.70709932679704,104.48501956978582,
	104.26279310167709,104.04042020718339,103.81790118546698,103.5952363507204,103.37242603276924,
	103.14947057769817,102.92637034850051,102.70312572575304,102.47973710831609,102.25620491406072,
	102.03252958062308,101.80871156618775,101.58475135030052,101.36064943471197,101.13640634425302,
	100.91202262774308,100.68749885893273,100.46283563748173,100.23803358997317,100.01309337096605,
	99.7880156640867,99.56280118316096,99.3374506733881,99.11196491255825,98.88634471231455,
	98.66059091946175,98.43470441732268,98.20868612714412,97.98253700955377,97.75625806606999,
	97.52985034066609,97.30331492139057,97.0766529420454,96.84986558392411,96.62295407761141,
	96.39591970484607,96.16876380044933,95.94148775432052,95.71409301350181,95.48658108431398,
	95.25895353456562,95.03121199583717,94.80335816584228,94.57539381086816,94.34732076829732,
	94.11914094921204,93.89085634108477,93.66246901055474,93.43398110629452,93.20539486196712,
	92.97671259927624,92.74793673111115,92.51906976478828,92.29011430539082,92.06107305920843,
	91.8319488372781,91.60274455902798,91.37346325602508,91.14410807582824,90.91468228594756,
	90.68518927791015,90.4556325714341,90.22601581870988,89.99634280879033,89.76661747208779,
	89.53684388497953,89.30702627451927,89.0771690232548,88.84727667414906,88.61735393560616,
	88.38740568658706,88.15743698184102,87.92745305721267,87.69745933504778,87.46746142968222,
	87.2374651530111,87.0074765201323,86.77750175505749,86.54754729648386,86.3176198036177,
	86.08772616204168,85.85787348961529,85.62806914239806,85.39832072058333,85.1686360744302,
	84.93902331017935,84.70949079593774,84.48004716751619,84.25070133420215,84.02146248444919,
	83.7923400914634,83.56334391866497,83.33448402500323,83.10577077010079,82.87721481920177,
	82.64882714789773,82.4206190466032,82.19260212475223,81.96478831468531,81.73718987519466,
	81.50981939469622,81.28268979399341,81.05581432859832,80.82920659057471,80.60288050986577,
	80.37685035506979,80.15113073362596,79.9257365913722,79.70068321143657,79.47598621242453,
	79.25166154586405,79.02772549287104,78.80419465999894,78.58108597423683,78.35841667712235,
	78.13620431793693,77.91446674595323,77.69322210170706,77.47248880726877,77.25228555549198,
	77.03263129822182,76.81354523344736,76.59504679138868,76.37715561951241,76.15989156647476,
	75.94327466499709,75.72732511368346,75.51206325779606,75.2975095690104,75.08368462417842,
	74.87060908313376,74.65830366558055,74.44678912711308,74.23608623442033,74.02621573973657,
	73.81719835460457,73.60905472302477,73.40180539406971,73.19547079404845,72.99007119831042,
	72.78562670278448,72.58215719535066,72.37968232714829,72.17822148392531,71.97779375753684,
	71.778417917702,71.58011238412944,71.38289519912136,71.18678400076554,70.99179599682238,
	70.7979479394128,70.60525610060817,70.41373624902043,70.22340362748491,70.03427293192338,
	69.84635829146848,69.65967324992373,69.47423074862606,69.29004311077,69.10712202724439,
	68.92547854402407,68.7451230511501,68.56606527332323,68.38831426212644,68.21187838988385,
	68.03676534515343,67.86298212984387,67.69053505793644,67.51942975578544,67.3496711639629,
	67.1812635406065,67.01421046622247,66.84851484989024,66.68417893680919,66.52120431712325,
	66.35959193595573,66.19934210458227,66.04045451266683,65.88292824148463,65.72676177805238,
	65.57195303008707,65.41849934171246,65.26639750983335,65.11564380109823,64.96623396937179,
	64.81816327363985,64.67142649627245,64.52601796157118,64.38193155453139,64.23916073975113,
	64.09769858042281,63.95753775734589,63.818670587903675,63.68108904494896,63.54478477554868,
	63.409749119539995,63.275973127854606,63.143447580571795,63.01216300466364,62.88210969139991,
	62.7532777133838,62.62565694119219,62.49923705959829,62.3740075833569,62.24995787253616,
	62.12707714738153,62.005354502701884,61.884778921768316,61.765339289720224,61.64702440647454,
	61.52982299913623,61.413723733910004,61.29871522751528,61.184786058107406,61.07192477570997,
	60.96011991216465,60.84935999060504,60.739633534463515,60.63092907601976,60.52323516450106,
	60.41654037374481,60.31083330943486,60.20610261592273,60.102336982646285,59.999525150157766,
	59.89765591577424,59.796718138862744,59.696700745773335,59.5975927344326,59.49938317861067,
	59.40206123187461,59.305616131240505,59.21003720053719,59.11531385349368,59.02143559656274,
	58.92839203149212,58.836172857655534,58.74476787415451,58.654166981702254,58.56436018430032,
	58.47533759071884,58.387089415789966,58.29960598152485,58.21287771806333,58.126895164465886,
	58.041648969356345,57.95712989140479,57.8733287997768,57.7902366742556,57.707844605455534,
	57.62614379481871,57.545125554530934,57.46478130734154,57.38510258629345,57.30608103436954,
	57.22770840406089,57.14997655686285,57.07287746270359,56.99640319931051,56.92054595151929,
	56.8452980105297,56.77065177311271,56.696599740773,56.62313451887052,56.55024881570469,
	56.477935441565045,56.40618730775098,56.334997425564204,56.264358905276474,56.19426495507536,
	56.12470887999087,56.05568408080482,55.98718405294579,55.91920238537148,55.851732759440424,
	55.78476894777519,55.71830481311861,55.652334307184695,55.58685146950597,55.52185042627831,
	55.457325389205096,55.39327065434139,55.32968060093982,55.26654969029871,55.203872464614136,
	55.14164354583607,55.07985763453007,55.018509508744955,54.957594022887434,54.89710610660413,
	54.83704076367185,54.77739307089642,54.71815817702071,54.659331301642545,54.60090773414236,
	54.54288283262163,54.48525202285196,54.42801079723521,54.371154713775326,54.31467939506141,
	54.25858052726295,54.202853859136845,54.1474952010468,54.09250042399494,54.03786545866581,
	53.98358629448298,53.929658978678255,53.87607961537327,53.82284436467411,53.76994944177835,
	53.71739111609477,53.66516571037593,53.61326959986318,53.56169921144439,53.51045102282414,
	53.45952156170655,53.40890740499029,53.35860517797618,53.30861155358698,53.25892325159923,
	53.2095370378873,53.16044972367936,53.11165816482519,53.06315926107574,53.01494995537437,
	52.96702723315941,52.91938812167837,52.87202968931307,52.82494904491619,52.77814333715856,
	52.73160975388737,52.68534552149517,52.63934790429921,52.59361420393139,52.54814175873842,
	52.502927943192105,52.45797016730957,52.41326587608342,52.36881254892154,52.324607699096426,
	52.280648873204036,52.23693365063172,52.193459643035524,52.15022449382619,52.10722587766424,
	52.064461499963684,52.02192909640414,51.97962643245163,51.937551302887485,51.895701531345445,
	51.854074969856704,51.812669498403075,51.7714830244775,51.73051348265258,51.689758834156315,
	51.649217066434936,51.608886192826816,51.568764252031734,51.528849307803,51.48913944853643,
	51.449632786888436,51.41032745940069,51.37122162613149,51.332313470293265,51.29360119789662,
	51.2550830374003,51.21675723936741,51.17862207612745,51.14067584144427,51.10291685018972,
	51.065343438022936,51.02795396107514,50.99074679563996,50.953720337869,50.91687300347261,
	50.88020322742592,50.84370946367981,50.80739018487685,50.77124388207227,50.735269064459374,
	50.69946425910002,50.663828010659394,50.628358881145466,50.593055449652915,50.55791631211121,
	50.522940081037255,50.48812538529192,50.453470869840956,50.41897519551982,50.384637038802424,
	50.35045509157399,50.31642806090742,50.282554668843815,50.24883365217619,50.21526376223731,
	50.18184376469077,50.14857243932559,50.115448579854345,50.082470993714615,50.04963850187364,
	50.01694993863633,49.98440415145645,49.952000000750864,49.91973635971684,49.887612114152496,
	49.855626162279925,49.82377741457165,49.79206479357942,49.76048723376625,49.72904368134083,
	49.69773309409505,49.66655444124368,49.6355067032671,49.604588871756235,49.57379994926025,
	49.54313894913654,49.51260489540322,49.48219682259395,49.451913775615076,49.42175480960511,
	49.39171898979649,49.361805391379306,49.33201309936759,49.30234120846734,49.272788822946914,
	49.24335505650931,49.214039032166575,49.1848398821161,49.15575674761893,49.12678877887993,
	49.09793513492986,49.06919498350932,49.040567500954474,49.01205187208446,48.98364729009073,
	48.95535295642801,48.92716808070694,48.89909188058837,48.87112358167924,48.84326241743031,
	48.815507629035025,48.78785846533036,48.76031418269886,48.73287404497237,48.7055373233372,
	48.678303296240536,48.65117124929861,48.62414047520596,48.59721027364618,48.570379951203996,
	48.54364882127873,48.517016203998935,48.490481426138366,48.46404382103324,48.437702728500724,
	48.411457494758494,48.38530747234574,48.359252020045055,48.33329050280573,48.307422291668026,
	48.281646763688585,48.25596330186695,48.23037129507316,48.204870137976464,48.179459230974885,
	48.154137980126045,48.12890579707883,48.103762099006076,48.07870630853831,48.0537378536983,
	48.02885616783671,48.00406068956849,47.979350862710426,47.954726136219264,47.93018596413105,
	47.90572980550106,47.88135712434475,47.857067389579484,47.832860074967,47.80873465905695,
	47.784690625130864,47.76072746114722,47.73684465968713,47.71304171790077,47.68931813745466,
	47.66567342447958,47.64210708951925,47.61861864747969,47.59520761757942,47.57187352330005,
	47.548615892337914,47.525434256556046,47.50232815193705,47.479297118536465,47.45634070043685,
	47.43345844570248,47.41064990633455,47.38791463822721,47.365252201123965,47.34266215857482,
	47.320144077893865,47.297697530117624,47.275322089963744,47.25301733579038,47.2307828495561,
	47.20861821678025,47.18652302650396,47.164496871251586,47.142539346992656,47.120650053104406,
	47.09882859233469,47.07707457076548,47.055387597776786,47.03376728601107,47.01221325133811,
	46.990725112820364,46.96930249267873,46.94794501625872,46.92665231199725,46.90542401138965,
	46.88425974895717,46.86315916221498,46.84212189164046,46.82114758061851,46.80023587550608,
	46.77938642545645,46.75859888248745,46.73787290142693,46.7172081398834,46.69660425821701,
	46.67606091951112,46.65557778954404,46.63515453676108,46.61479083224721,46.59448634969976,
	46.57424076540171,46.55405375819511,46.53392500945495,46.51385420306338,46.49384102538415,
	46.473885165237384,46.453986313874786,46.434144164954965,46.41435841451918,46.39462876096747,
	46.374954905034755,46.35533654976762,46.33577340050117,46.3162651648361,46.29681155261628,
	46.27741227590636,46.258067048969814,46.238775588247194,46.21953761233461,46.20035284196255,
	46.1812209999749,46.16214181130815,46.143115002971044,46.12414030402425,46.10521744556042,
	46.086346160684386,46.06752618449373,46.04875725405942,46.03003910840673,46.01137148849652,
	45.99275413720652,45.97418679931293,45.955669221472306,45.937201152203535,45.918782341870084,
	45.90041254266247,45.88209150858091,45.863818995418114,45.8455947607424,45.82741856388093,
	45.8092901659031,45.7912093296042,45.77317581948926,45.755189401757,45.73724984428402,
	45.71935691660918,45.70151038991815,45.6837100370281,45.665955632372565,45.648246951986636,
	45.630583773492,45.61296587608246,45.595393040509485,45.577865049067896,45.56038168558175,
	45.542942735390405,45.52554798533468,45.50819722374325,45.490890240419105,45.4736268266262,
	45.4564067750763,45.43922987991584,45.4220959367131,45.40500474244538,45.387956095486366,
	45.37094979559368,45.35398564389648,45.337063442883256,45.320182996389775,45.30334410958705,
	45.286546588969564,45.269790242343575,45.253074878815546,45.236400308780624,45.21976634391141,
	45.203172797146756,45.1866194826806,45.170106215951044,45.153632813629535,45.13719909361014,
	45.12080487499883,45.10444997810313,45.08813422442155,45.07185743663349,45.055619438588906,
	45.03942005529834,45.023259112922936,45.00713643876456,44.99105186125606,44.975005209951675,
	44.95899631551735,44.94302500972144,44.92709112542524,44.91119449657379,44.8953349581867,
	44.87951234634911,44.863726498202674,44.84797725193671,44.832264446779426,44.81658792298919,
	44.80094752184597,44.78534308564275,44.76977445767719,44.754241482243145,44.73874400462258,
	44.72328187107721,44.70785492884058,44.69246302610991,44.67710601203823,44.661783736726555,
	44.646496051216026,44.631242807480305,44.61602385841795,44.600839057844794,44.585688260486556,
	44.57057132197143,44.555488098822785,44.54043844845186,44.5254222291507,44.51043930008492,
	44.49548952128678,44.480572753648204,44.46568885891385,44.45083769967429,44.436019139359296,
	44.42123304223112,44.40647927337786,44.391757698706904,44.3770681849384,44.36241059959896,
	44.347784811015075,44.333190688306985,44.31862810138232,44.30409692092995,44.289597018413886,
	44.275128266067185,44.2606905368859,44.246283704623174,44.231907643783366,44.21756222961612,
	44.203247338110685,44.188962845990076,44.17470863070554,44.16048457043079,44.14629054405652,
	44.132126431184865,44.11799211212397,44.103887467882544,44.08981238016448,44.07576673136359,
	44.06175040455835,44.04776328350667,44.03380525264064,44.01987619706162,44.005976002535014,
	43.99210455548529,43.978261742990995,43.96444745277988,43.95066157322396,43.93690399333472,
	43.923174602758294,43.90947329177073,43.89579995127331,43.88215447278783,43.868536748452065,
	43.85494667101508,43.84138413383284,43.827849030863575,43.81434125666347,43.80086070638209,
	43.78740727575818,43.773980861115206,43.76058135935712,43.74720866796409,43.733862684988296,
	43.720543309049766,43.707250439332185,43.69398397557884,43.68074381808852,43.66752986771157,
	43.65434202584577,43.64118019443243,43.62804427595253,43.614934173422775,43.6018497903917,
	43.588791030935916,43.57575779965634,43.56275000167437,43.549767542628196,43.536810328669176,
	43.52387826645806,43.51097126316149,43.4980892264483,43.48523206448606,43.47239968593749,
	43.45959199995694,43.446808916187024,43.43405034475502,43.421316196269636,43.4086063818175,
	43.395920812959936,43.3832594017295,43.37062206062679,43.358008702617155,43.34541924112749,
	43.33285359004295,43.32031166370386,43.30779337690254,43.2952986448801,43.28282738332344,
	43.270379508362176,43.25795493656552,43.245553584939294,43.233175370922964,43.22082021238665,
	43.20848802762816,43.19617873537008,43.18389225475692,43.17162850535221,43.15938740713559,
	43.147168880500146,43.13497284624944,43.122799225594825,43.11064794015271,43.09851891194177,
	43.08641206338023,43.074327317283284,43.062264596860324,43.050223825712315,43.03820492782925,
	43.02620782758745,43.0142324497471,43.002278719449556,42.99034656221497,42.97843590393959,
	42.966546670893514,42.95467878971795,42.94283218742299,42.93100679138497,42.919202529344254,
	42.907419329402735,42.89565712002144,42.88391583001826,42.872195388565565,42.860495725187896,
	42.84881676975959,42.8371584525027,42.82552070398454,42.8139034551155,42.802306637146856,
	42.79073018166856,42.77917402060698,42.76763808622284,42.75612231110894,42.74462662818811,
	42.73315097071111,42.72169527223174,42.710259466696414,42.698843488303375,42.68744727159395,
	42.67607075142708,42.66471386297718,42.653376541732136,42.64205872349142,42.63076034436396,
	42.61948134076626,42.608221649420535,42.59698120735263,42.58575995189021,42.574557820660836,
	42.56337475159004,42.552210682899535,42.54106555310527,42.52993930101565,42.51883186572974,
	42.50774318663532,42.49667320340725,42.485621856005544,42.474589084673724,42.463574829936945,
	42.45257903260034,42.44160163374724,42.43064257473748,42.41970179720569,42.40877924305959,
	42.397874854478346,42.386988573910834,42.37612034407407,42.36527010795151,42.354437808791474,
	42.34362339010546,42.3328267956666,42.32204796950806,42.31128685592141,42.3005433994551,
	42.28981754491297,42.279109237352515,42.268418422083556,42.2577450446666,42.247089050911356,
	42.23645038687525,42.22582899886193,42.215224833419775,42.204637837340464,42.19406795765747,
	42.18351514164464,42.17297933681483,42.1624604909183,42.15195855194151,42.14147346810561,
	42.131005187865036,42.12055365990616,42.11011883314594,42.0997006567305,42.089299080033825,
	42.07891405265641,42.06854552442389,42.05819344538578,42.047857765814136,42.03753843620221,
	42.027235407263206,42.01694862992903,42.00667805534887,41.99642363488813,41.98618532012699,
	41.97596306285926,41.965756815091154,41.955566529039956,41.94539215713292,41.935233652006005,
	41.925090966502594,41.91496405367249,41.904852866770526,41.89475735925551,41.884677484788966,
	41.87461319723411,41.86456445065456,41.85453119931326,41.84451339767126,41.83451100038674,
	41.824523962313755,41.81455223850117,41.804595784191555,41.79465455482006,41.78472850601339,
	41.774817593588615,41.76492177355224,41.75504100209898,41.7451752356108,41.735324430655886,
	41.72548854398747,41.71566753254296,41.70586135344276,41.6960699639893,41.686293321666106,
	41.67653138413663,41.66678410924337,41.65705145500682,41.64733337962453,41.63762984147,
	41.62794079909192,41.61826621121296,41.60860603672898,41.59896023470802,41.58932876438928,
	41.579711585182366,41.570108656666115,41.56051993858785,41.55094539086237,41.54138497357103,
	41.53183864696091,41.52230637144376,41.512788107595306,41.50328381615413,41.49379345802099,
	41.4843169942578,41.47485438608681,41.46540559488973,41.45597058220685,41.446549309736234,
	41.43714173933282,41.427747833007565,41.418367552926654,41.409000861410604,41.3996477209335,
	41.390308094122126,41.38098194375518,41.37166923276242,41.36236992422389,41.353083981369096,
	41.34381136757622,41.334552046371336,41.32530598142763,41.31607313656458,41.30685347574721,
	41.29764696308534,41.28845356283274,41.27927323938649,41.27010595728611,41.26095168121286,
	41.25181037598903,41.2426820065771,41.2335665380791,41.22446393573584,41.21537416492622,
	41.20629719116637,41.19723298010913,41.18818149754321,41.179142709392515,41.17011658171543,
	41.16110308070416,41.15210217268398,41.14311382411257,41.134138001579345,41.125174671804764,
	41.11622380163964,41.10728535806447,41.09835930818877,41.089445619250455,41.08054425861508,
	41.071655193775264,41.062778392350026,41.05391382208412,41.04506145084742,41.03622124663422,
	41.02739317756266,41.018577211874096,41.00977331793243,41.00098146422348,40.99220161935447,
	40.98343375205323,40.97467783116779,40.96593382566558,40.95720170463298,40.948481437274616,
	40.93977299291285,40.93107634098709,40.922391451053265,40.91371829278327,40.905056835964295,
	40.896407050498304,40.88776890640144,40.8791423738035,40.8705274229473,40.861924024188156,
	40.85333214799327,40.844751764941336,40.8361828457217,40.827625361134075,40.81907928208788,
	40.81054457960169,40.80202122480275,40.79350918892636,40.7850084433154,40.77651895941982,
	40.768040708796036,40.75957366310648,40.75111779411903,40.74267307370651,40.73423947384618,
	40.72581696661923,40.71740552421027,40.70900511890681,40.70061572309875,40.69223730927792,
	40.68386985003756,40.67551331807184,40.667167686175326,40.65883292724255,40.65050901426751,
	40.6421959203432,40.63389361866103,40.62560208251054,40.61732128527874,40.609051200449784,
	40.60079180160438,40.59254306241945,40.58430495666757,40.576077458216545,40.567860541028956,
	40.55965417916174,40.55145834676563,40.543273018084875,40.53509816745666,40.52693376931065,
	40.51877979816874,40.51063622864434,40.502503035442174,40.494380193357735,40.48626767727687,
	40.47816546217536,40.47007352311851,40.461991835260676,40.45392037384496,40.44585911420263,
	40.43780803175283,40.42976710200212,40.42173630054409,40.413715603058904,40.40570498531296,
	40.397704423158416,40.38971389253287,40.3817333694589,40.37376283004366,40.365802250478545,
	40.357851607038775,40.34991087608298,40.34198003405281,40.33405905747263,40.326147922949026,
	40.318246607170494,40.31035508690707,40.302473339009886,40.294601340410864,40.28673906812233,
	40.27888649923663,40.27104361092576,40.26321038044099,40.25538678511255,40.247572802349225,
	40.239768409637996,40.231973584543745,40.22418830470877,40.21641254785257,40.20864629177142,
	40.20088951433803,40.19314219350124,40.18540430728559,40.177675833791014,40.16995675119262,
	40.16224703774011,40.15454667175766,40.146855631643476,40.139173895869455,40.1315014429809,
	40.123838251596204,40.11618430040646,40.10853956817514,40.100904033737855,40.093277676001875,
	40.085660473946014,40.078052406620124,40.070453453144886,40.062863592711466,40.05528280458116,
	40.047711068085185,40.040148362624244,40.03259466766831,40.02504996275625,40.017514227495596,
	40.009987441562174,40.00246958469985,39.9949606367202,39.9874605775022,39.97996938699195,
	39.97248704520239,39.965013532213035,39.95754882816953,39.95009291328357,39.94264576783247,
	39.935207372158914,39.92777770667072,39.9203567518404,39.912944488205135,39.90554089636621,
	39.89814595698896,39.890759650802345,39.88338195859874,39.876012861233676,39.868652339625505,
	39.86130037475517,39.85395694766597,39.84662203946314,39.8392956313138,39.83197770444651,
	39.82466824015111,39.81736721977837,39.810074624739826,39.80279043650745,39.7955146366134,
	39.78824720664979,39.78098812826837,39.7737373831804,39.76649495315623,39.759260820025155,
	39.75203496567514,39.74481737205257,39.737608021162,39.73040689506591,39.7232139758844,
	39.716029245795085,39.70885268703271,39.70168428188899,39.694524012712314,39.687371861907565,
	39.68022781193586,39.67309184531423,39.665963944615555,39.65884409246817,39.65173227155572,
	39.64462846461688,39.63753265444517,39.63044482388865,39.62336495584984,39.6162930332853,
	39.60922903920553,39.60217295667471,39.59512476881049,39.588084458783754,39.58105200981839,
	39.574027405191096,39.56701062823111,39.560001662320076,39.55300049089174,39.54600709743176,
	39.53902146547757,39.532043578618,39.525073420493264,39.51811097479455,39.51115622526399,
	39.504209155694326,39.49726974992871,39.490337991860606,39.48341386543342,39.47649735464045,
	39.46958844352459,39.46268711617814,39.45579335674263,39.44890714938405,39.44202847839156,
	39.43515732802781,39.42829368262919,39.42143752658027,39.414588844313684,39.40774762030987,
	39.4009138390969,39.39408748525031,39.38726854339285,39.38045699819434,39.37365283437148,
	39.366856036687615,39.36006658995263,39.353284479022655,39.346509688800005,39.33974220423284,
	39.33298201031514,39.32622909208639,39.3194834346315,39.312745023080566,39.30601384260865,
	39.299289878435744,39.292573115826414,39.28586354008974,39.27916113657911,39.27246589069203,
	39.26577778786996,39.25909681359811,39.25242295340532,39.245756192863844,39.2390965175892,
	39.232443913240004,39.22579836551774,39.219159860166684,39.21252838297366,39.20590391976793,
	39.19928645642096,39.192675978846296,39.186072472999406,39.17947592487755,39.17288632051943,
	39.16630364600533,39.15972788745667,39.15315903103601,39.14659706294687,39.140041969433454,
	39.13349373678068,39.12695235131387,39.12041779939864,39.11389006744073,39.10736914188595,
	39.10085500921983,39.09434765596765,39.08784706869416,39.08135323400352,39.07486613853909,
	39.06838576898328,39.06191211205744,39.05544515452161,39.04898488317455,39.0425312848534,
	39.036084346433675,39.02964405482901,39.02321039699106,39.01678335990942,39.01036293061134,
	39.00394909616168,38.997541843662795,38.99114116025425,38.98474703311284,38.978359449452306,
	38.97197839652334,38.965603861613296,38.95923583204617,38.952874295182376,38.94651923841869,
	38.940170649188,38.93382851495928,38.92749282323742,38.921163561563034,38.914840717512384,
	38.908524278697264,38.902214232764784,38.89591056739727,38.88961327031224,38.883322329262064,
	38.877037732034026,38.87075946645007,38.864487520366716,38.85822188167498,38.85196253830007,
	38.845709478201535,38.83946268937287,38.83322215984154,38.826987877668785,38.82075983094956,
	38.81453800781237,38.80832239641912,38.80211298496503,38.79590976167849,38.78971271482095,
	38.78352183268679,38.77733710360323,38.77115851593015,38.76498605805997,38.75881971841762,
	38.75265948546033,38.74650534767751,38.740357293590705,38.734215311753395,38.72807939075092,
	38.721949519200415,38.715825685750524,38.709707879081485,38.703596087904884,38.6974903009636,
	38.69139050703167,38.68529669491416,38.679208853447044,38.673126971497155,38.667051037962054,
	38.66098104176983
	}}
};
table1d_imp<2001> tubetable2_12AT7[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	90778.31476672851,90453.6603779748,90130.68594112135,89809.38058511853,89489.73351904775,
	89171.73403150096,88855.37148995235,88540.63534012644,88227.51510538314,87916.00038610901,
	87606.0808591045,87297.74627698351,86990.98646756863,86685.7913333042,86382.15085066356,
	86080.0550695656,85779.49411280047,85480.45817544319,85182.93752429278,84886.92249730516,
	84592.40350303074,84299.37102006037,84007.81559646883,83717.72784927016,83429.09846387692,
	83141.91819356159,82856.17785891453,82571.86834732491,82288.98061244884,82007.50567368821,
	81727.43461567683,81448.75858776161,81171.46880350362,80895.55654016722,80621.01313821068,
	80347.83000081399,80075.99859336141,79805.51044296417,79536.35713797931,79268.53032752284,
	79002.0217209948,78736.8230876103,78472.9262559236,78210.32311337175,77949.00560580616,
	77688.96573703467,77430.19556837801,77172.68721820683,76916.43286150212,76661.4247294152,
	76407.65510881641,76155.11634187531,75903.80082561693,75653.70101150137,75404.80940499014,
	75157.11856512848,74910.6211041335,74665.30968697058,74421.17703094156,74178.2159052848,
	73936.4191307673,73695.77957927641,73456.29017343138,73217.94388617999,72980.73374041924,
	72744.65280858976,72509.69421230146,72275.85112195689,72043.11675635175,71811.48438232281,
	71580.94731435887,71351.49891423793,71123.13259065387,70895.84179885969,70669.62004031015,
	70444.46086228563,70220.35785755719,69997.30466402188,69775.29496436198,69554.32248568772,
	69334.38099920691,69115.46431987255,68897.56630605292,68680.68085918883,68464.80192346765,
	68249.92348549255,68036.03957394684,67823.14425928507,67611.23165339412,67400.29590928581,
	67190.33122077856,66981.33182217462,66773.29198796574,66566.2060324984,66360.06830969678,
	66154.8732127358,65950.61517375255,65747.28866353795,65544.88819125146,65343.40830411652,
	65142.84358713069,64943.18866278327,64744.43819075892,64546.58686766013,64349.62942671864,
	64153.560637518574,63958.375305721194,63764.068272782366,63570.634415687964,63378.06864667165,
	63186.36591295819,62995.52119648707,62805.52951365024,62616.38591503767,62428.085485160285,
	62240.62334220957,62053.9946377905,61868.194556670715,61683.218316527295,61499.061167699656,
	61315.71839293859,61133.185307160704,60951.45725721007,60770.529621604794,60590.39781030943,
	60411.05726448785,60232.503456271406,60054.731888527225,59877.738094616376,59701.517638174955,
	59526.066112878565,59351.379142217156,59177.45237926953,59004.2815064857,58831.86223545213,
	58660.19030669108,58489.26148942696,58319.07158137624,58149.616408538604,57980.89182497285,
	57812.893712598576,57645.61798097696,57479.060567110435,57313.21743523221,57148.08457660488,
	56983.6580093194,56819.93377809095,56656.90795405877,56494.576634598336,56332.9359431102,
	56171.98202883828,56011.711066673655,55852.11925695609,55693.20282529667,55534.95802238186,
	55377.38112378598,55220.468429792025,55064.216265200426,54908.62097915565,54753.6789449573,
	54599.38655988401,54445.7402450176,54292.73644506424,54140.371628181034,53988.642285800226,
	53837.54493245876,53687.0761056263,53537.23236553802,53388.01029502383,53239.40649934389,
	53091.417606019626,52944.0402646755,52797.27114687104,52651.10694594132,52505.54437683569,
	52360.58017596149,52216.211101024805,52072.43393087199,51929.245465338674,51786.64252509335,
	51644.62195148454,51503.18060638994,51362.31537206846,51222.02315100445,51082.300865769284,
	50943.14545886631,50804.55389259159,50666.52314888305,50529.05022918583,50392.1321543011,
	50255.76596425171,50119.948718138825,49984.67749400735,49849.949388702466,49715.761517735904,
	49582.11101515408,49448.995033397354,49316.41074317071,49184.35533331303,49052.82601065857,
	48921.81999991656,48791.334543534846,48661.366901575435,48531.91435158607,48402.974188473796,
	48274.54372438086,48146.6202885606,48019.201227254074,47892.28390356753,47765.865697350535,
	47639.94400507993,47514.51623973316,47389.579830677874,47265.13222354841,47141.17088013414,
	47017.69327825891,46894.69691167151,46772.17928992882,46650.137938282605,46528.570397569274,
	46407.4742240982,46286.84698954245,46166.68628082681,46046.98970002131,45927.75486423375,
	45808.979405502585,45690.66097069004,45572.797221377536,45455.38583376293,45338.42449855449,
	45221.91092086907,45105.84282013317,44990.217929974795,44875.03399813264,44760.28878634707,
	44645.98007027053,44532.105639360794,44418.6632967903,44305.65085934657,44193.0661573381,
	44080.907034497104,43969.17134788892,43857.85696781577,43746.96177772328,43636.483674112824,
	43526.42056644425,43416.77037705113,43307.53104104619,43198.7005062353,43090.27673302591,
	42982.25769434358,42874.6413755403,42767.4257743111,42660.60890060737,42554.18877655119,
	42448.163436349416,42342.53092621509,42237.28930427881,42132.436640509055,42027.971016628915,
	41923.8905260361,41820.19327372156,41716.87737618769,41613.94096137511,41511.38216857399,
	41409.19914835706,41307.39006249189,41205.953083871485,41104.8863964343,41004.188195087896,
	40903.85668563616,40803.89008470301,40704.286619658145,40605.044528545106,40506.1620600065,
	40407.63747321315,40309.4690377912,40211.65503375242,40114.19375142001,40017.083491362544,
	39920.322564322356,39823.909291146294,39727.842002717836,39632.1190398879,39536.73875340815,
	39441.69950386443,39346.9996616095,39252.63760669686,39158.61172881585,39064.920427226454,
	38971.562110694336,38878.53519742779,38785.838115013314,38693.469300352604,38601.42719959987,
	38509.710268101495,38418.316970332184,38327.24577983422,38236.49517915776,38146.06365979934,
	38055.94972214329,37966.15187540309,37876.66863755909,37787.49853530293,37698.64010398013,
	37610.09188753012,37521.85243842988,37433.92031763919,37346.29409454194,37258.97234689116,
	37171.953660753854,37085.2366304557,36998.819858527066,36912.70195564776,36826.88154059389,
	36741.357240185636,36656.12768923078,36571.19153047699,36486.54741455542,36402.193999931806,
	36318.12995285342,36234.35394729893,36150.86466492747,36067.660795027805,35984.74103446967,
	35902.10408765324,35819.748666460924,35737.673490208304,35655.8772855958,35574.35878665853,
	35493.116734723735,35412.149878356926,35331.45697332122,35251.03678252701,35170.88807598466,
	35091.00963076338,35011.40023094074,34932.05866756052,34852.9837385858,34774.17424885683,
	34695.62901004392,34617.34684060587,34539.326565744916,34461.5670173642,34384.067034025575,
	34306.82546090522,34229.8411497527,34153.112958848134,34076.63975296099,34000.42040331057,
	33924.45378752041,33848.73878958175,33773.27429981109,33698.05921481196,33623.0924374319,
	33548.37287672507,33473.89944791319,33399.671072346384,33325.68667746328,33251.9451967538,
	33178.445569720694,33105.18674184191,33032.16766453266,32959.38729510981,32886.844596750685,
	32814.538538461544,32742.468095038545,32670.632247030415,32599.02998070545,32527.660288013387,
	32456.522166551116,32385.614619527863,32314.93665572956,32244.487289483994,32174.265540628745,
	32104.27043447347,32034.50100176843,31964.95627867173,31895.63530671291,31826.537132762962,
	31757.660808999066,31689.005392873543,31620.56994708144,31552.353539526415,31484.355243292754,
	31416.57413660848,31349.009302818886,31281.659830351844,31214.524812689084,31147.60334833357,
	31080.89454078138,31014.397498487964,30948.111334842095,30882.035168132745,30816.16812152064,
	30750.50932300931,30685.05790541584,30619.813006340763,30554.77376814078,30489.939337898315,
	30425.30886739611,30360.881513085886,30296.656436061734,30232.632802033982,30168.809781298107,
	30105.186548711285,30041.76228366227,29978.536170046176,29915.50739623707,29852.675155062076,
	29790.038643772874,29727.597064023623,29665.349621840727,29603.2955276007,29541.433996001113,
	29479.76424603766,29418.285500979444,29356.996988340932,29295.89793986042,29234.987591472527,
	29174.265183287138,29113.72995956167,29053.38116867915,28993.21806312313,28933.23989945527,
	28873.445938290046,28813.83544427238,28754.4076860552,28695.161936273726,28636.097471526245,
	28577.213572348453,28518.50952319162,28459.984612400927,28401.638132193293,28343.469378634025,
	28285.477651615987,28227.66225483843,28170.022495783716,28112.55768569691,28055.267139565494,
	27998.150176095998,27941.20611769536,27884.43429044798,27827.834024097727,27771.40465202442,
	27715.145511226605,27659.05594229887,27603.13528941301,27547.38290029802,27491.79812622056,
	27436.38032196535,27381.128845814714,27326.043059530548,27271.122328335434,27216.366020892598,
	27161.77350928716,27107.344169007665,27053.077378928418,26998.97252128959,26945.028981679803,
	26891.246149017556,26837.62341553384,26784.16017675316,26730.85583147725,26677.709781766433,
	26624.721432921822,26571.89019346973,26519.215475142195,26466.696692861628,26414.333264723125,
	26362.124611977884,26310.07015901554,26258.169333350164,26206.421565600645,26154.826289476543,
	26103.382941760883,26052.09096229524,26000.949793962016,25949.958882669733,25899.117677337967,
	25848.42562988103,25797.88219519143,25747.486831126556,25697.23899849248,25647.138161028884,
	25597.18378539413,25547.375341150426,25497.71230074916,25448.194139516305,25398.820335637723,
	25349.590370144248,25300.50372689973,25251.559892583184,25202.7583566781,25154.09861145662,
	25105.58015196624,25057.20247601588,25008.965084162694,24960.86747969899,24912.90916863674,
	24865.089659696663,24817.408464294156,24769.86509652612,24722.459073157726,24675.189913610477,
	24628.05713994823,24581.060276865497,24534.19885167495,24487.472394293778,24440.88043723331,
	24394.422515584905,24348.098167008564,24301.906931721693,24255.848352485427,24209.9219745943,
	24164.12734586383,24118.46401661918,24072.931539683585,24027.52947036643,23982.257366452362,
	23937.114788190174,23892.101298281814,23847.21646187029,23802.459846529648,23757.831022253977,
	23713.32956144692,23668.955038909917,23624.70703183261,23580.585119782656,23536.58888469397,
	23492.717910857813,23448.971784911497,23405.350095829508,23361.852434912293,23318.478395776772,
	23275.22757434666,23232.0995688428,23189.09397977308,23146.21040992301,23103.448464346515,
	23060.80775035659,23018.28787751484,22975.888457623663,22933.60910471712,22891.449435050934,
	22849.40906709364,22807.487621518714,22765.684721194495,22723.99999117713,22682.43305869963,
	22640.983553165643,22599.65110613977,22558.435351339056,22517.335924625644,22476.352463997882,
	22435.484609582567,22394.732003625973,22354.094290487566,22313.571116630654,22273.16213061571,
	22232.866983091164,22192.685326787803,22152.61681650964,22112.661109127068,22072.81786356925,
	22033.086740817173,21993.467403896422,21953.95951786918,21914.56274982827,21875.276768889787,
	21836.101246186005,21797.0358548583,21758.08027005119,21719.23416890537,21680.49723055026,
	21641.869136098627,21603.349568640187,21564.9382132337,21526.634756902647,21488.438888627326,
	21450.350299340178,21412.3686819185,21374.49373117924,21336.725143872813,21299.062618676995,
	21261.5058561914,21224.054558932075,21186.708431325533,21149.46717970306,21112.3305122952,
	21075.29813922724,21038.3697725125,21001.545126048597,20964.823915610366,20928.2058588466,
	20891.690675273774,20855.27808627164,20818.967815078253,20782.759586784843,20746.65312833131,
	20710.648168501306,20674.744437917805,20638.941669038748,20603.239596151743,20567.637955370283,
	20532.13648462967,20496.734923681644,20461.43301409124,20426.23049923191,20391.127124281826,
	20356.122636219618,20321.216783820506,20286.409317652335,20251.699990071666,20217.088555220358,
	20182.5747690211,20148.158389174972,20113.839175156165,20079.616888210265,20045.491291349186,
	20011.462149349056,19977.529228745803,19943.692297832768,19909.95112665646,19876.305487014466,
	19842.755152451653,19809.299898257086,19775.93950146149,19742.67374083363,19709.50239687809,
	19676.425251831904,19643.44208966211,19610.55269606259,19577.75685845206,19545.054365970478,
	19512.44500947738,19479.928581549026,19447.504876475206,19415.17369025803,19382.934820608487,
	19350.78806694475,19318.733230389233,19286.77011376692,19254.898521602856,19223.11826011984,
	19191.42913723635,19159.830962564574,19128.32354740822,19096.90670476007,19065.58024930097,
	19034.34399739659,19003.197767096273,18972.14137813107,18941.17465191123,18910.29741152518,
	18879.509481737005,18848.810688984722,18818.20086137865,18787.679828699504,18757.24742239665,
	18726.90347558621,18696.647823049214,18666.480301230054,18636.4007482348,18606.409003828972,
	18576.504909436237,18546.688308136596,18516.959044664134,18487.31696540603,18457.76191840008,
	18428.293753333077,18398.912321539374,18369.617475998173,18340.409071332775,18311.28696380766,
	18282.251011326938,18253.30107343269,18224.437011302296,18195.658687746905,18166.965967209006,
	18138.35871576049,18109.836801100006,18081.400092551215,18053.048461059803,18024.781779191693,
	17996.59992112966,17968.502762671687,17940.490181227593,17912.562055816008,17884.71826706232,
	17856.958697194987,17829.283230042212,17801.69175102928,17774.184147174576,17746.760307086322,
	17719.420120958956,17692.16348056857,17664.990279269732,17637.9004119908,17610.893775229502,
	17583.97026704839,17557.129787070025,17530.372236472012,17503.69751798153,17477.105535869985,
	17450.596195947284,17424.169405555687,17397.82507356354,17371.56311035885,17345.38342784214,
	17319.28593941954,17293.27055999491,17267.337205962354,17241.485795197863,17215.716247050477,
	17190.028482333582,17164.422423315533,17138.897993709452,17113.455118663456,17088.093724749673,
	17062.813739953133,17037.615093659933,17012.49771664505,16987.461541059893,16962.50650041846,
	16937.632529584018,16912.83956475424,16888.127543445968,16863.496404479814,16838.946087963497,
	16814.476535274654,16790.087689042986,16765.779493131748,16741.551892618067,16717.40483377286,
	16693.33826403989,16669.352132013846,16645.446387416876,16621.62098107554,16597.875864896057,
	16574.210991838023,16550.626315888094,16527.121792032143,16503.69737622623,16480.35302536659,
	16457.088697258372,16433.904350583416,16410.7999448665,16387.77544044036,16364.83079840939,
	16341.965980612218,16319.180949582904,16296.475668510071,16273.850101195156,16251.304212009489,
	16228.837965848861,16206.451328087123,16184.144264528146,16161.916741356314,16139.76872508461,
	16117.70018250147,16095.711080616298,16073.801386602157,16051.97106773756,16030.220091345778,
	16008.548424732962,15986.956035123088,15965.442889592723,15944.008955001998,15922.65419792571,
	15901.378584579774,15880.182080748014,15859.06465170593,15838.02626214259,15817.066876080324,
	15796.186456792839,15775.384966720974,15754.662367386858,15734.01861930593,15713.453681897008,
	15692.967513390739,15672.560070736308,15652.231309506324,15631.981183799777,15611.809646144648,
	15591.716647397543,15571.702136643198,15551.766061092634,15531.908365980276,15512.128994459123,
	15492.427887498394,15472.804983777452,15453.260219581178,15433.79352869573,15414.404842304119,
	15395.094088882646,15375.861194098634,15356.706080709546,15337.6286684637,15318.628874004,
	15299.706610773776,15280.861788926002,15262.094315236876,15243.404093023262,15224.791022065767,
	15206.254998536659,15187.795914935448,15169.413660030397,15151.108118809212,15132.879172437597,
	15114.726698228029,15096.65056961931,15078.650656167345,15060.72682354903,15042.878933579324,
	15025.10684424391,15007.410409747317,14989.78948057825,14972.243903593695,14954.7735221225,
	14937.378176089787,14920.05770216397,14902.811933927369,14885.640702071376,14868.543834618371,
	14851.521157171379,14834.572493192163,14817.697664309968,14800.89649066203,14784.168791266467,
	14767.514384429222,14750.93308818571,14734.424720779349,14717.989101175684,14701.626049615303,
	14685.335388203846,14669.116941541488,14652.970537390564,14636.896007382878,14620.893187764632,
	14604.961920180334,14589.102052493676,14573.31343964493,14557.59594454378,14541.949438994228,
	14526.373804652314,14510.868934011118,14495.434731412448,14480.071114081205,14464.778013177947,
	14449.55537486688,14434.403161393646,14419.32135216845,14404.309944848746,14389.368956415738,
	14374.498424238522,14359.698407118869,14344.968986309848,14330.31026650076,14315.722376760832,
	14301.205471433172,14286.759730971868,14272.385362712934,14258.082601570975,14243.85171065389,
	14229.692981785636,14215.606735931338,14201.593323513867,14187.653124617296,14173.786549066943,
	14159.994036381922,14146.276055592529,14132.633104917115,14119.065711294534,14105.574429767554,
	14092.159842714198,14078.822558926144,14065.563212531979,14052.3824617663,14039.280987586339,
	14026.259492137322,14013.31869707231,14000.459341730011,13987.682181177033,13974.987984122357,
	13962.377530712716,13949.851610217236,13937.41101861382,13925.056556086822,13912.789024450336,
	13900.609224508727,13888.517953369392,13876.516001720785,13864.60415109207,13852.78317110736,
	13841.053816751806,13829.416825662462,13817.872915460106,13806.422781136416,13795.067092510242,
	13783.806491766722,13772.641591092353,13761.57297041796,13750.601175280342,13739.726714814202,
	13728.950059881683,13718.271641349167,13707.691848517497,13697.211027711655,13686.829481034143,
	13676.547465285963,13666.365191056666,13656.28282198458,13646.300474187678,13636.418215862366,
	13626.636067049452,13616.95399956243,13607.371937074735,13597.889755360484,13588.507282682669,
	13579.224300322378,13570.040543241512,13560.955700872028,13551.969418022643,13543.081295894941,
	13534.290893199977,13525.597727367423,13517.001275836217,13508.500977420254,13500.096233737926,
	13491.786410698036,13483.57084003307,13475.448820871057,13467.419621338655,13459.482480186329,
	13451.636608429852,13443.881190998889,13436.215388388306,13428.638338304094,13421.149157298114,
	13413.746942388036,13406.43077265481,13399.199710815416,13392.05280476518,13384.98908908746,
	13378.007586524891,13371.107309413392,13364.287261071844,13357.546437148321,13350.883826920832,
	13344.298414550043,13337.789180283135,13331.355101609304,13324.995154364644,13318.70831378701,
	13312.493555520761,13306.349856571502,13300.276196211304,13294.27155683453,13288.334924765239,
	13282.465291017415,13276.661652008454,13270.923010226827,13265.248374855459,13259.636762352713,
	13254.08719699,13248.598711351051,13243.170346790115,13237.801153853608,13232.490192665742,
	13227.236533278012,13222.039255987876,13216.897451622963,13211.810221796775,13206.776679135051,
	13201.795947473862,13196.867162032631,13191.989469562157,13187.162028468576,13182.384008916191,
	13177.65459290876,13172.97297435161,13168.33835909482,13163.749964959723,13159.207021748844,
	13154.708771241087,13150.254467173143,13145.843375202303,13141.474772870451,13137.147949542827,
	13132.8622063421,13128.616856073919,13124.411223141566,13120.244643453427,13116.116464322811,
	13112.026044360691,13107.972753363394,13103.955972193346,13099.97509265621,13096.02951737221,
	13092.118659644873,13088.241943325433,13084.398802674374,13080.58868222045,13076.81103661702,
	13073.065330497831,13069.35103832742,13065.667644262277,13062.014641988133,13058.391534580018,
	13054.797834350298,13051.233062697747,13047.696749958328,13044.18843525468,13040.707666347562,
	13037.253999485865,13033.826999260406,13030.426238454884,13027.051297901207,13023.701766333694,
	13020.377240246095,13017.0773237488,13013.801628428198,13010.549773207567,13007.321384208546,
	13004.116094616238,13000.933544543683,12997.773380900206,12994.635257259933,12991.51883373354,
	12988.423776840878,12985.349759385568,12982.296460331992,12979.263564684137,12976.25076336591,
	12973.257753104705,12970.284236314434,12967.329920983344,12964.39452056208,12961.4777538539,
	12958.579344908085,12955.699022912882,12952.83652209306,12949.991581607337,12947.163945449067,
	12944.35336234776,12941.559585673618,12938.782373342434,12936.021487723994,12933.276695551032,
	12930.54776783009,12927.834479755482,12925.136610623029,12922.453943746743,12919.786266376985,
	12917.133369620069,12914.495048360022,12911.871101181338,12909.261330293219,12906.665541456683,
	12904.083543911162,12901.515150304687,12898.960176623608,12896.418442126092,12893.889769273845,
	12891.373983669031,12888.870913989102,12886.380391925795,12883.90225212249,12881.436332116738,
	12878.98247227968,12876.540515760831,12874.110308430094,12871.691698825092,12869.284538096954,
	12866.888679956359,12864.50398062489,12862.130298782715,12859.76749552106,12857.415434292967,
	12855.07398086812,12852.743003281295,12850.422371796198,12848.111958855594,12845.811639038702,
	12843.52128902108,12841.240787530789,12838.970015310804,12836.708855076893,12834.457191481042,
	12832.21491107299,12829.981902262365,12827.75805528465,12825.543262163004,12823.337416675959,
	12821.140414322397,12818.952152288268,12816.772529414959,12814.60144616694,12812.438804600226,
	12810.284508330813,12808.13846251346,12806.000573798732,12803.870750312912,12801.748901629733,
	12799.634938741423,12797.52877403277,12795.430321253754,12793.3394954961,12791.256213166258,
	12789.180391961752,12787.111950846358,12785.050810028302,12782.996890934264,12780.950116191134,
	12778.910409599426,12776.877696114627,12774.851901823733,12772.832953928453,12770.820780720003,
	12768.815311562623,12766.81647687276,12764.824208100485,12762.8384377107,12760.859099164172,
	12758.886126901716,12756.91945632333,12754.959023775382,12753.004766528129,12751.056622765722,
	12749.114531563722,12747.17843287853,12745.248267528954,12743.323977181835,12741.40550433633,
	12739.492792310852,12737.58578522839,12735.684428000885,12733.788666318129,12731.898446631829,
	12730.013716144447,12728.134422794254,12726.260515245496,12724.391942872788,12722.528655751517,
	12720.670604644172,12718.8177409897,12716.970016892054,12715.127385107942,12713.28979903627,
	12711.45721270897,12709.629580778279,12707.806858506558,12705.98900175773,12704.175966984938,
	12702.367711222838,12700.564192078082,12698.765367717106,12696.971196860033,12695.181638770291,
	12693.396653245589,12691.616200610006,12689.840241703747,12688.068737877005,12686.30165098029,
	12684.538943356414,12682.780577832847,12681.02651771398,12679.276726774006,12677.531169247872,
	12675.789809825674,12674.052613644464,12672.319546281124,12670.590573746309,12668.865662476835,
	12667.144779328628,12665.427891570505,12663.714966880425,12662.005973332405,12660.300879398907,
	12658.599653937024,12656.902266187584,12655.20868576746,12653.5188826627,12651.832827226235,
	12650.150490167442,12648.471842551477,12646.796855790575,12645.125501639624,12643.45775219297,
	12641.793579876387,12640.132957443497,12638.475857970045,12636.822254851995,12635.172121796455,
	12633.525432819471,12631.882162241312,12630.242284681875,12628.605775058366,12626.972608572085,
	12625.34276071767,12623.71620726934,12622.092924279497,12620.472888074926,12618.856075252634,
	12617.24246267578,12615.632027469568,12614.024747018748,12612.42059896183,12610.819561189162,
	12609.221611838753,12607.626729293,12606.03489217432,12604.446079342628,12602.860269892693,
	12601.277443147825,12599.697578661357,12598.120656208199,12596.546655783808,12594.975557608634,
	12593.407342109598,12591.841989928633,12590.279481917763,12588.719799132641,12587.16292283546,
	12585.608834486624,12584.057515744375,12582.508948462792,12580.963114688615,12579.419996658138,
	12577.879576793674,12576.341837703898,12574.806762178752,12573.274333189343,12571.744533881894,
	12570.21734757765,12568.692757774312,12567.170748134971,12565.651302493872,12564.134404849878,
	12562.620039366444,12561.108190367528,12559.598842337537,12558.09197991645,12556.5875879021,
	12555.085651243242,12553.586155040879,12552.089084545754,12550.594425154468,12549.102162410221,
	12547.612281999627,12546.12476975128,12544.639611632634,12543.156793750653,12541.676302347478,
	12540.198123800468,12538.722244620105,12537.248651447904,12535.777331054447,12534.308270339787,
	12532.841456327938,12531.376876169606,12529.914517138952,12528.454366630476,12526.996412159273,
	12525.540641359716,12524.087041982906,12522.635601894943,12521.186309078514,12519.739151627035,
	12518.294117746089,12516.851195752413,12515.410374070263,12513.97164123287,12512.53498587815,
	12511.10039674986,12509.667862695456,12508.23737266497,12506.808915708241,12505.382480977476,
	12503.958057721797,12502.535635289109,12501.11520312222,12499.69675076124,12498.280267839278,
	12496.865744082883,12495.45316931063,12494.04253343155,12492.633826445082,12491.22703843903,
	12489.822159589494,12488.419180158467,12487.018090495534,12485.61888103172,12484.221542285344,
	12482.826064855339,12481.432439423857,12480.040656751988,12478.650707683424,12477.26258313876,
	12475.876274117005,12474.49177169649,12473.109067029785,12471.728151346117,12470.3490159485,
	12468.971652214355,12467.596051594195,12466.222205610877,12464.850105858848,12463.479744001963,
	12462.11111177514,12460.744200981679,12459.379003493872,12458.015511251057,12456.653716259258,
	12455.293610591065,12453.935186383083,12452.578435838741,12451.223351223245,12449.8699248665,
	12448.518149160158,12447.168016559057,12445.819519576253,12444.472650788077,12443.127402829203,
	12441.783768395328,12440.441740238883,12439.101311171795,12437.762474063034,12436.42522183583,
	12435.089547472893,12433.755444011096,12432.422904542433,12431.091922213694,12429.7624902238,
	12428.434601827632,12427.108250330994,12425.783429090287,12424.460131517611,12423.138351073101,
	12421.818081267811,12420.499315661518,12419.182047870429,12417.866271550136,12416.551980411377,
	12415.23916820889,12413.927828747168,12412.617955877397,12411.309543496584,12410.002585548278,
	12408.697076022076,12407.393008951976,12406.090378416795,12404.789178539546,12403.489403487474,
	12402.191047470536,12400.894104742178,12399.598569597929,12398.304436375522,12397.011699454826,
	12395.720353255649,12394.430392239932,12393.141810909083,12391.854603805657,12390.568765510285,
	12389.284290643682,12388.001173865765,12386.71940987532,12385.438993407182,12384.159919235299,
	12382.882182171841,12381.60577706387,12380.330698797681,12379.056942293138,12377.784502507311,
	12376.513374433975,12375.243553100488,12373.975033569614,12372.707810937982,12371.441880338589,
	12370.177236936697,12368.913875930857,12367.651792554609,12366.390982073077,12365.131439783914,
	12363.873161018242,12362.616141137429,12361.3603755382,12360.105859644276,12358.852588912432,
	12357.600558832644,12356.349764921722,12355.100202727965,12353.85186783132,12352.604755839677,
	12351.358862391313,12350.114183153251,12348.870713821521,12347.628450121705,12346.387387805431,
	12345.147522655712,12343.908850481243,12342.671367117535,12341.435068433448,12340.199950313961,
	12338.966008681626,12337.733239479818,12336.501638681211,12335.271202283271,12334.041926309148,
	12332.813806808266,12331.5868398555,12330.361021551093,12329.13634801921,12327.9128154116,
	12326.69041990163,12325.469157688105,12324.24902499458,12323.03001806714,12321.812133178171,
	12320.595366622008,12319.37971471479,12318.165173798556,12316.9517402318,12315.739410412116,
	12314.528180741465,12313.318047652472,12312.109007596762,12310.90105705257,12309.694192516448,
	12308.488410505513,12307.283707562037,12306.08008024645,12304.87752514295,12303.676038852524,
	12302.475618000215,12301.276259230644,12300.077959209739,12298.880714606428,12297.684522169468,
	12296.489378582528,12295.295280602151,12294.102224993452,12292.910208539854,12291.719228043268,
	12290.52928032635,12289.340362228635,12288.152470610492,12286.965602347882,12285.779754339146,
	12284.59492349662,12283.411106752848,12282.228301059613,12281.046503384556,12279.865710711185,
	12278.685920049309,12277.50712841314,12276.329332842846,12275.152530428817,12273.976718137446,
	12272.801893163149,12271.62805257651,12270.455193498688,12269.283313068727,12268.112408441424,
	12266.94247678759,12265.773515294339,12264.605521163729,12263.438491615281,12262.272423882425,
	12261.107315215326,12259.943162879601,12258.779964154537,12257.617716336772,12256.45641673587,
	12255.296062676336,12254.13665150173,12252.978180564569,12251.820647235749,12250.664048898598,
	12249.508382952046,12248.353646808366,12247.199837894139,12246.046953650663,12244.894991531333,
	12243.743949006754,12242.593823557783,12241.444612679581,12240.296313882413,12239.148924689725,
	12238.002442636362,12236.856865270864,12235.712190156153,12234.56841486706,12233.425536992487,
	12232.283554138126,12231.14246390763,12230.00226393238,12228.86295185029,12227.72452531186,
	12226.58698198247,12225.450319536527,12224.31453566055,12223.179628056314,12222.045594435427,
	12220.912432520581,12219.780140047402,12218.648714763414,12217.518154427007,12216.388456808512,
	12215.259619689863,12214.131640862555,12213.004518133263,12211.878249316393,12210.752832236636,
	12209.628264734632,12208.504544657639,12207.381669864415,12206.25963822564,12205.138447624051,
	12204.018095948595,12202.898581101137,12201.779900997513,12200.662053557955,12199.545036716054,
	12198.428848416634,12197.313486612064,12196.198949266458,12195.085234354809,12193.97233986027,
	12192.860263776034,12191.749004106654,12190.638558865805,12189.5289260762,12188.420103769799,
	12187.312089989637,12186.204882786888,12185.098480222938,12183.992880369959,12182.888081304565,
	12181.784081118736,12180.680877909166,12179.578469783342,12178.47685485791,12177.37603125802,
	12176.275997117982,12175.176750581764,12174.078289799838,12172.980612933257,12171.883718151546,
	12170.787603633085,12169.692267563672,12168.597708138426,12167.50392356057,12166.410912042327,
	12165.318671804012,12164.227201073307,12163.136498087177,12162.046561090658,12160.957388336286,
	12159.868978084747,12158.781328605242,12157.694438175366,12156.608305078626,12155.522927608105,
	12154.438304064062,12153.354432755528,12152.271311996212,12151.188940111662,12150.107315431964,
	12149.026436295893,12147.94630104867,12146.866908045366,12145.788255645717,12144.710342218707,
	12143.63316613812,12142.556725788185,12141.481019558885,12140.406045844868,12139.331803053716,
	12138.258289594878,12137.185503886383,12136.113444353128,12135.042109427752,12133.971497550716,
	12132.901607165057,12131.832436725417,12130.763984690517,12129.696249526096,12128.629229705262,
	12127.562923706935,12126.497330016411,12125.432447128613,12124.36827353996,12123.304807753439,
	12122.24204828642,12121.1799936557,12120.118642382866,12119.057993001263,12117.99804404814,
	12116.938794064701,12115.880241600873,12114.822385213634,12113.765223463202,12112.708754917594,
	12111.652978150527,12110.597891741309,12109.543494276439,12108.489784347632,12107.436760550223,
	12106.384421489462,12105.332765775007,12104.281792019246,12103.231498844636,12102.181884876567,
	12101.132948747138,12100.084689094077,12099.03710456034,12097.990193794058,12096.943955450854,
	12095.89838818853,12094.853490675387,12093.809261577766,12092.765699574851,12091.722803346533,
	12090.680571581068,12089.639002968379,12088.59809620526,12087.557849997878,12086.518263050173,
	12085.479334076406,12084.441061794641,12083.40344492781,12082.366482204023,12081.330172356531,
	12080.294514123974,12079.259506249024,12078.225147480298,12077.191436569317,12076.15837227667,
	12075.125953363902,12074.094178598136,12073.063046753385,12072.032556606791,12071.002706939946,
	12069.973496538509,12068.944924197353,12067.916988709772,12066.889688876905,12065.863023505772,
	12064.836991405822,12063.811591391435,12062.78682228142,12061.762682901539,12060.739172077254,
	12059.71628864332,12058.694031437131,12057.672399298428,12056.6513910743,12055.631005615523,
	12054.611241775807,12053.592098415458,12052.573574397082,12051.555668588291,12050.538379859738,
	12049.521707090977,12048.505649156954,12047.49020494673,12046.475373346762,12045.461153250399,
	12044.447543554375,12043.434543159083,12042.422150970157,12041.410365896283,12040.399186851044,
	12039.388612751434,12038.378642516429,12037.369275073454,12036.360509351256,12035.352344280602,
	12034.344778799568,12033.337811849337,12032.331442373406,12031.325669319653,12030.320491640743,
	12029.315908291068,12028.311918231579,12027.308520425791,12026.305713840755,12025.303497446059,
	12024.301870216108,12023.300831129347,12022.300379168457,12021.300513316368,12020.30123256388,
	12019.3025359035,12018.304422330646,12017.306890845739,12016.309940450526,12015.31357015156,
	12014.317778960358,12013.322565889059,12012.327929956677,12011.333870181628,12010.340385588031,
	12009.347475204868,12008.35513806114,12007.363373191669,12006.372179632674,12005.381556426259,
	12004.39150261543,12003.402017247756,12002.4130993742,12001.424748047513,12000.43696232584,
	11999.449741269413,11998.463083940802,11997.476989407425,11996.491456738502,11995.50648500828,
	11994.52207329119,11993.53822066855,11992.554926219602,11991.572189033564,11990.590008195084,
	11989.608382798517,11988.627311938333,11987.646794711016,11986.666830218908,11985.687417563942,
	11984.708555853204,11983.730244196557,11982.752481708227,11981.775267500703,11980.79860069355,
	11979.822480409503,11978.846905772283,11977.871875907573,11976.897389946442,11975.92344702191,
	11974.95004626853,11973.977186826432,11973.00486783632,11972.033088443708,11971.061847791716,
	11970.091145032402,11969.120979319712,11968.151349805668,11967.182255649564,11966.213696013063,
	11965.245670057493,11964.278176950185,11963.31121586068,11962.34478595738,11961.378886416414,
	11960.413516414426,11959.448675128819,11958.484361745144,11957.520575444383,11956.557315413442,
	11955.594580844452,11954.632370926458,11953.670684855857,11952.709521831792,11951.74888105106,
	11950.788761716974,11949.82916303358,11948.870084209479,11947.911524452722,11946.953482976982,
	11945.995958996255,11945.038951726963,11944.082460389885,11943.126484206417,11942.1710224013,
	11941.216074199338,11940.261638831378,11939.307715527775,11938.354303523109,11937.401402053325,
	11936.44901035597,11935.49712767416,11934.545753248245,11933.594886326098,11932.644526155404,
	11931.694671982574,11930.7453230639,11929.796478653212,11928.848138005107,11927.900300379968,
	11926.952965039416,11926.006131247632,11925.059798267032,11924.113965369717,11923.16863181835,
	11922.223796893704,11921.279459869285,11920.335620017695,11919.392276619708,11918.449428956208,
	11917.507076308888,11916.565217964338,11915.62385320884,11914.68298133162,11913.74260162533,
	11912.802713382387,11911.863315898483,11910.924408471148,11909.9859904004,11909.048060986874,
	11908.110619536395,11907.173665352655,11906.237197744993,11905.301216021693,11904.36571949619,
	11903.430707479956,11902.496179290734,11901.562134247242,11900.628571665136,11899.695490870203,
	11898.762891184264,11897.830771934126,11896.899132443672,11895.96797204541,11895.037290069728,
	11894.107085851054,11893.177358722138,11892.248108022224,11891.319333088206,11890.391033262073,
	11889.463207884999,11888.535856305198,11887.608977863,11886.68257191041,11885.756637796976,
	11884.831174874242,11883.90618249568,11882.98166001643,11882.057606792798,11881.134022184211,
	11880.210905554417,11879.288256261076,11878.366073673666,11877.444357152954,11876.523106069548,
	11875.602319792231,11874.681997691625,11873.76213914508,11872.842743521684,11871.923810199229,
	11871.005338557634,11870.08732797609,11869.16977783519,11868.2526875186,11867.336056411685,
	11866.419883900291,11865.504169372822,11864.588912220908,11863.674111832963,11862.759767603604,
	11861.84587892764,11860.932445202916,11860.019465825295,11859.10694019332,11858.194867713419,
	11857.28324778383,11856.37207981034,11855.461363198401,11854.551097357751,11853.641281696284,
	11852.731915623965,11851.822998553791,11850.91452989909,11850.006509077282,11849.098935503474,
	11848.191808596604,11847.285127776897,11846.378892465875,11845.473102086493,11844.567756063165,
	11843.662853824186,11842.758394794633,11841.854378403197,11840.950804083468,11840.047671263905,
	11839.144979380126,11838.242727867593,11837.340916161707,11836.439543699089,11835.53860992299,
	11834.638114270801,11833.738056186965,11832.838435112893,11831.93925049602,11831.04050178217,
	11830.142188418293,11829.244309855629,11828.346865543006,11827.449854932705,11826.553277480625,
	11825.657132639753,11824.761419865692,11823.866138618856,11822.971288355628,11822.076868538219,
	11821.182878626509,11820.289318087052,11819.39618638221,11818.503482975779,11817.611207340553,
	11816.719358939932,11815.82793724446,11814.936941728012,11814.046371861217,11813.15622711708,
	11812.266506974367,11811.377210905326,11810.4883383903,11809.599888906881,11808.711861935719,
	11807.824256958616,11806.937073459801,11806.050310921051,11805.163968828256,11804.278046669122,
	11803.392543931875,11802.507460105084,11801.62279467713,11800.738547143732,11799.854716994885,
	11798.971303726294,11798.088306831822,11797.205725809137,11796.323560157169,11795.441809371665,
	11794.560472956013,11793.679550411041,11792.79904123903,11791.918944942478,11791.039261029286,
	11790.159989002435,11789.281128372375,11788.402678645514,11787.524639332647,11786.647009944305,
	11785.769789994742,11784.892978995,11784.016576459231,11783.140581904016,11782.264994845576,
	11781.38981480249,11780.51504129348,11779.640673838592,11778.766711958087,11777.893155175661,
	11777.020003013817,11776.147254999134,11775.274910657296,11774.402969513974,11773.5314310954,
	11772.660294934052,11771.789560558122,11770.919227500577,11770.049295290968,11769.179763467371,
	11768.310631558528,11767.441899103602,11766.573565640349,11765.705630702056,11764.8380938323,
	11763.970954568893,11763.104212452517,11762.237867025711,11761.371917832908,11760.506364414945,
	11759.641206320444,11758.776443092112,11757.91207428025,11757.048099431871,11756.184518095739,
	11755.321329823993,11754.458534166955,11753.596130674374,11752.734118904411,11751.872498407522,
	11751.011268741751,11750.15042946247,11749.289980126094,11748.429920292263,11747.570249519553,
	11746.710967368826,11745.852073402244,11744.993567181065,11744.13544826761,11743.277716229575,
	11742.420370628337,11741.563411032213,11740.706837009646,11739.85064812543,11738.994843950446,
	11738.139424054036
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	90778.31476672851,90453.6603779748,90130.6859411215,89809.38058511874,89489.733519048,
	89171.73403150203,88855.37148995334,88540.63534012644,88227.51510538252,87916.00038610901,
	87606.0808591049,87297.74627698351,86990.98646756617,86685.79133330475,86382.15085066356,
	86080.05506956637,85779.49411280123,85480.45817544319,85182.93752429167,84886.92249730558,
	84592.40350303074,84299.37102006037,84007.81559646883,83717.72784927046,83429.09846387674,
	83141.91819356203,82856.17785891437,82571.86834732535,82288.9806124483,82007.50567368821,
	81727.43461567625,81448.75858776161,81171.46880350403,80895.5565401662,80621.01313821059,
	80347.83000081376,80075.99859336123,79805.51044296438,79536.35713797931,79268.53032752284,
	79002.0217209948,78736.8230876105,78472.92625592364,78210.32311337179,77949.00560580549,
	77688.9657370347,77430.19556837804,77172.68721820737,76916.43286150295,76661.4247294152,
	76407.6551088155,76155.11634187531,75903.80082561773,75653.7010115019,75404.80940499002,
	75157.11856512782,74910.62110413298,74665.30968697005,74421.17703094092,74178.21590528492,
	73936.41913076742,73695.77957927676,73456.2901734305,73217.9438861812,72980.73374041892,
	72744.65280858894,72509.69421230146,72275.85112195574,72043.11675635069,71811.48438232325,
	71580.94731435883,71351.49891423623,71123.13259065345,70895.84179886081,70669.62004031036,
	70444.46086228591,70220.35785755674,69997.3046640226,69775.29496436204,69554.32248568733,
	69334.3809992076,69115.46431987363,68897.56630605226,68680.68085918954,68464.80192346775,
	68249.9234854926,68036.03957394706,67823.14425928477,67611.23165339272,67400.29590928734,
	67190.33122077856,66981.33182217533,66773.29198796375,66566.20603249807,66360.06830969635,
	66154.87321273668,65950.6151737519,65747.28866353797,65544.88819125174,65343.408304115954,
	65142.84358713085,64943.188662783155,64744.438190759494,64546.5868676606,64349.62942671801,
	64153.56063752043,63958.37530572172,63764.068272783596,63570.63441568736,63378.06864667284,
	63186.36591295867,62995.52119648766,62805.529513651956,62616.385915037055,62428.08548516091,
	62240.62334221038,62053.99463779033,61868.19455666989,61683.21831652594,61499.06116769892,
	61315.718392936345,61133.18530716041,60951.45725721049,60770.529621604364,60590.39781030888,
	60411.05726448771,60232.50345627093,60054.73188852609,59877.73809461552,59701.51763817443,
	59526.06611287726,59351.37914221677,59177.45237926965,59004.281506485786,58831.86223545286,
	58660.19030669095,58489.261489426804,58319.071581377015,58149.616408538306,57980.89182497421,
	57812.89371259894,57645.61798097693,57479.06056710981,57313.21743523127,57148.084576604546,
	56983.65800931886,56819.93377809062,56656.90795405978,56494.57663459858,56332.93594311004,
	56171.982028839564,56011.71106667322,55852.11925695546,55693.2028252965,55534.95802238088,
	55377.38112378616,55220.46842979204,55064.21626520127,54908.620979156316,54753.67894495667,
	54599.38655988418,54445.740245017725,54292.736445065086,54140.371628181805,53988.64228580034,
	53837.544932458266,53687.076105625834,53537.232365538424,53388.01029502367,53239.40649934327,
	53091.41760601978,52944.04026467614,52797.27114687153,52651.106945941356,52505.54437683555,
	52360.58017596148,52216.21110102496,52072.433930872336,51929.245465339285,51786.642525093564,
	51644.621951484754,51503.18060639034,51362.31537206779,51222.02315100465,51082.30086576983,
	50943.145458866544,50804.55389259137,50666.523148883905,50529.05022918602,50392.13215430096,
	50255.765964251266,50119.948718139545,49984.677494008276,49849.949388702305,49715.761517736406,
	49582.11101515467,49448.99503339776,49316.41074317171,49184.35533331237,49052.826010658646,
	48921.81999991684,48791.334543535,48661.366901575784,48531.914351585874,48402.97418847369,
	48274.543724380936,48146.62028856087,48019.20122725484,47892.28390356747,47765.86569735078,
	47639.94400507981,47514.51623973325,47389.579830677474,47265.13222354811,47141.17088013349,
	47017.693278259176,46894.6969116719,46772.17928992853,46650.13793828256,46528.57039756923,
	46407.47422409879,46286.8469895421,46166.686280827045,46046.98970002133,45927.754864234215,
	45808.97940550274,45690.66097068957,45572.79722137737,45455.385833762535,45338.42449855458,
	45221.91092086896,45105.84282013251,44990.21792997455,44875.0339981324,44760.288786347206,
	44645.98007026962,44532.10563936046,44418.66329679002,44305.65085934622,44193.066157337504,
	44080.907034496464,43969.171347888114,43857.856967814645,43746.961777722325,43636.483674111594,
	43526.42056644356,43416.770377050045,43307.53104104535,43198.700506233654,43090.276733024824,
	42982.257694342356,42874.64137553851,42767.425774309726,42660.6089006055,42554.18877654807,
	42448.16343634698,42342.53092621258,42237.289304276426,42132.436640506305,42027.971016626674,
	41923.89052603322,41820.19327371789,41716.87737618442,41613.94096137066,41511.38216856975,
	41409.19914835209,41307.39006248674,41205.95308386704,41104.886396429334,41004.18819508263,
	40903.856685630286,40803.89008469703,40704.28661965184,40605.044528538405,40506.16205999951,
	40407.63747320571,40309.469037783274,40211.65503374392,40114.19375141102,40017.083491353354,
	39920.322564312686,39823.90929113599,39727.84200270689,39632.11903987641,39536.73875339595,
	39441.69950385182,39346.99966159603,39252.63760668279,39158.611728800846,39064.920427210775,
	38971.562110678286,38878.53519741071,38785.838114995,38693.46930033335,38601.42719958017,
	38509.71026808015,38418.31697031028,38327.24577981123,38236.49517913332,38146.063659773485,
	38055.94972211688,37966.151875374635,37876.668637529256,37787.49853527213,37698.64010394774,
	37610.09188749583,37521.85243839443,37433.92031760163,37346.29409450297,37258.97234685044,
	37171.95366071065,37085.23663041063,36998.81985847981,36912.70195559834,36826.88154054263,
	36741.35724013112,36656.12768917423,36571.19153041736,36486.54741449339,36402.19399986683,
	36318.129952785945,36234.35394722852,36150.86466485337,36067.66079494992,35984.74103438797,
	35902.10408756814,35819.748666372136,35737.67349011557,35655.87728549824,35574.35878655672,
	35493.11673461697,35412.149878245866,35331.456973205306,35251.0367824052,35170.88807585803,
	35091.009630630535,35011.40023080193,34932.058667415426,34852.983738434115,34774.174248698364,
	34695.62900987866,34617.34684043294,34539.32656556419,34461.56701717577,34384.067033829015,
	34306.82546069981,34229.841149537766,34153.11295862403,34076.639752727184,34000.420403066644,
	33924.45378726539,33848.73878931521,33773.27429953365,33698.05921452194,33623.09243712879,
	33548.37287640909,33473.89944758352,33399.671072002064,33325.68667710409,33251.945196379434,
	33178.44556932972,33105.18674143385,33032.16766410748,32959.38729466583,32886.84459628721,
	32814.5385379784,32742.468094534637,32670.63224650463,32599.02998015716,32527.66028744142,
	32456.52216595473,32385.61461890606,32314.93665508098,32244.487288808035,32174.26553992375,
	32104.270433738242,32034.50100100178,31964.95627787239,31895.63530587972,31826.537131894293,
	31757.66080809358,31689.005391929724,31620.569946097217,31552.35353850105,31484.355242223635,
	31416.574135494444,31349.009301657185,31281.659829141616,31214.5248114273,31147.603347019187,
	31080.894539411307,31014.397497060523,30948.111333354504,30882.035166582486,30816.16811990538,
	30750.509321326383,30685.057903662342,30619.813004514042,30554.773766237602,30489.939335915875,
	30425.308865330968,30360.88151093391,30296.65643382086,30232.63279969915,30168.809778866376,
	30105.186546178073,30041.762281024094,29978.5361672981,29915.50739337504,29852.67515208086,
	29790.038640668405,29727.597060790562,29665.349618474054,29603.295524094643,29541.43399234972,
	29479.764242235815,29418.285497020257,29356.996984218098,29295.897935567507,29234.987587003023,
	29174.265178633304,29113.729954716255,29053.3811636344,28993.218057870967,28933.23989398714,
	28873.445932597286,28813.835438346072,28754.407679885764,28695.161929851747,28636.097464840925,
	28577.213565389084,28518.509515947375,28459.984604860714,28401.638124344438,28343.469370464187,
	28285.477643112994,28227.662245988024,28170.02248657221,28112.557676109835,28055.267129587413,
	27998.150165711697,27941.206106888167,27884.434279200825,27827.834012392974,27771.404639843902,
	27715.145498551046,27659.055929108312,27603.135275687062,27547.382886015002,27491.798111358552,
	27436.380306500498,27381.12882972303,27326.043042787238,27271.122310914594,27216.36600276647,
	27161.773490427935,27107.3441493862,27053.07735851397,26998.9725000503,26945.028959582916,
	26891.246126029127,26837.62339161759,26784.160151872788,26730.855805593972,26677.709754840096,
	26624.721404911063,26571.89016433117,26519.21544483108,26466.696661331123,26414.333231924866,
	26362.124577861003,26310.070123528178,26258.169296437492,26206.421527205966,26154.826249541133,
	26103.38290022359,26052.09091909191,26000.94974902695,25949.958835934238,25899.117628730375,
	25848.42557932674,25797.88214261358,25747.486776445043,25697.23894162375,25647.138101886656,
	25597.183723888007,25547.375277186646,25497.71223423085,25448.19407034199,25398.82026370208,
	25349.590295338843,25300.50364911023,25251.559811692256,25202.758272562736,25154.098523989487,
	25105.580061014825,25057.2023814431,25008.964985825383,24960.867377448016,24912.909062318344,
	24865.089549149983,24817.408349352725,24769.86497701644,24722.45894889983,24675.18978441705,
	24628.057005624705,24581.060137210436,24534.198706477702,24487.472243336775,24440.880280289697,
	24394.4223524189,24348.09799737578,24301.90675536731,24255.848169145236,24209.921783993886,
	24164.127147718344,24118.463810631358,24072.931325545498,24027.52924775834,23982.257135041524,
	23937.114547631314,23892.10104821569,23847.21620192385,23802.459576315418,23757.83074136928,
	23713.329269473525,23668.954735413165,23624.70671636087,23580.584791866764,23536.588543846294,
	23492.717556572155,23448.971416661516,23405.34971306865,23361.85203707269,23318.47798226842,
	23275.22714455667,23232.099122134587,23189.093515484954,23146.20992736754,23103.447962809965,
	23060.80722909676,23018.28733576144,22975.887894576746,22933.608519544498,22891.448826888933,
	22849.408435044894,22807.48696465077,22765.684038539275,22723.99928172814,22682.432321412125,
	22640.982786953828,22599.65030987596,22558.434523852105,22517.335064698473,22476.351570366474,
	22435.48368093389,22394.731038596125,22354.09328765986,22313.570074533534,22273.161047720037,
	22232.865857809495,22192.684157470714,22152.61560144393,22112.659846533166,22072.816551598746,
	22033.08537755034,21993.46598733898,21953.95804594969,21914.561220395466,21875.27517970876,
	21836.099594935666,21797.034139128176,21758.078487337138,21719.2323166066,21680.49530596555,
	21641.867136422545,21603.347490958775,21564.93605452014,21526.632514013414,21488.436558298108,
	21450.347878179946,21412.36616640533,21374.491117655998,21336.722428540263,21299.059797589896,
	21261.5029252524,21224.051513885563,21186.70526775169,21149.46389301181,21112.32709771966,
	21075.294591816448,21038.366087124832,21001.541297344076,20964.8199380434,20928.20172665798,
	20891.68638248249,20855.273626666185,20818.96318220809,20782.754773950746,20746.64812857641,
	20710.64297460088,20674.739042369078,20638.936064049787,20603.23377363155,20567.631906916176,
	20532.130201515578,20496.728396845978,20461.42623412405,20426.22345636128,20391.11980836026,
	20356.11503670925,20321.208889778653,20286.40111771562,20251.6914724405,20217.07970764119,
	20182.565578770118,20148.14884303896,20113.829259415215,20079.60658861713,20045.48059310976,
	20011.45103710094,19977.517686537463,19943.680309099836,19909.93867419932,19876.29255297336,
	19842.741718281464,19809.285944701584,19775.92500852555,19742.658687755473,19709.48676209976,
	19676.40901296893,19643.42522347167,19610.535178411188,19577.73866428111,19545.035469261253,
	19512.425383214224,19479.908197681092,19447.48370587733,19415.15170268958,19382.911984670605,
	19350.764350036407,19318.70859866141,19286.744532074736,19254.87195345626,19223.090667632583,
	19191.400481072425,19159.801201883183,19128.292639806292,19096.87460621297,19065.546914100232,
	19034.30937808625,19003.161814406307,18972.104040908172,18941.13587704733,18910.257143882813,
	18879.467664072254,18848.76726186702,18818.155763107934,18787.63299521968,18757.198787205976,
	18726.852969644457,18696.59537468143,18666.425836026563,18636.34418894696,18606.3502702618,
	18576.443918336558,18546.624973076945,18516.893275922725,18487.248669841414,18457.690999322054,
	18428.22011036808,18398.835850491032,18369.5380687029,18340.326615509235,18311.201342901502,
	18282.16210434918,18253.208754791864,18224.341150631615,18195.55914972287,18166.862611365406,
	18138.251396293777,18109.725366668896,18081.28438606755,18052.928319472776,18024.65703326327,
	17996.470395202385,17968.368274427143,17940.350541436652,17912.41706807985,17884.567727543228,
	17856.802394338087,17829.12094428708,17801.523254509888,17774.009203409703,17746.578670657906,
	17719.231537178723,17691.967685133357,17664.786997903164,17637.689360072953,17610.674657413154,
	17583.742776861007,17556.89360650195,17530.127035549747,17503.44295432613,17476.841254239258,
	17450.321827762255,17423.884568410205,17397.529370716762,17371.256130209727,17345.064743385992,
	17318.955107685255,17292.927121463115,17266.980683963553,17241.11569528942,17215.332056373096,
	17189.62966894566,17164.00843550489,17138.46825928216,17113.009044209044,17087.63069488192,
	17062.333116525602,17037.11621495639,17011.979896543522,16986.924068169123,16961.94863718812,
	16937.053511385286,16912.238598932556,16887.503808344383,16862.849048431723,16838.274228254984,
	16813.77925707617,16789.364044308524,16765.028499466174,16740.77253211212,16716.596051804157,
	16692.498968040727,16668.481190205148,16644.542627508228,16620.683188929826,16596.90278316029,
	16573.201318538788,16549.578702992676,16526.034843974492,16502.569648398785,16479.18302257759,
	16455.874872155408,16432.645102043545,16409.49361635379,16386.420318331868,16363.425110290456,
	16340.507893541699,16317.668568330913,16294.907033769243,16272.223187767391,16249.616926970146,
	16227.088146691407,16204.636740850525,16182.262601910557,16159.965620817738,16137.745686943186,
	16115.60268802761,16093.536510128404,16071.547037570377,16049.63415290016,16027.797736844874,
	16006.037668276773,15984.353824181067,15962.74607963167,15941.214307773325,15919.758379810555,
	15898.378165005392,15877.073530683398,15855.844342250248,15834.690463218029,15813.611755243528,
	15792.608078179293,15771.67929013777,15750.82524756967,15730.045805359281,15709.340816934982,
	15688.710134398998,15668.153608675493,15647.671089680065,15627.262426509858,15606.927467658621,
	15586.666061252661,15566.478055318115,15546.363298070664,15526.321638235862,15506.352925399806,
	15486.457010390684,15466.63374569341,15446.88298589808,15427.20458818497,15407.598412845005,
	15388.064323838977,15368.60218939546,15349.211882649177,15329.89328231943,15310.646273430773,
	15291.470748075766,15272.366606219872,15253.333756549247,15234.372117361121,15215.481617496187,
	15196.662197312766,15177.913809701658,15159.236421139982,15140.630012783406,15122.094581593208,
	15103.630141497802,15085.2367245831,15066.914382311557,15048.663186763442,15030.483231897306,
	15012.374634825175,14994.337537095826,14976.372105982038,14958.478535763927,14940.657049002693,
	14922.90789779685,14905.231365012962,14887.627765483707,14870.097447163032,14852.640792230255,
	14835.258218134008,14817.950178565367,14800.717164350863,14783.559704255276,14766.478365684061,
	14749.473755274828,14732.546519368578,14715.697344350478,14698.926956850151,14682.236123793586,
	14665.625652296558,14649.096389392787,14632.649221588794,14616.285074239599,14600.004910738875,
	14583.809731520634,14567.700572867354,14551.678505523825,14535.744633115526,14519.900090372223,
	14504.14604115823,14488.483676314143,14472.914211313579,14457.438883742914,14442.058950610579,
	14426.775685496581,14411.590375551805,14396.504318361884,14381.518818685367,14366.635185084599,
	14351.854726462869,14337.178748525415,14322.608550181607,14308.145419906788,14293.790632081887,
	14279.545443331082,14265.411088875466,14251.38877892228,14237.479695109412,14223.684987023225,
	14210.00576880785,14196.443115883852,14182.998061792323,14169.671595181158,14156.46465694616,
	14143.378137542672,14130.4128744781,14117.569649996218,14104.849188963084,14092.252156961871,
	14079.779158602167,14067.430736049317,14055.207367775907,14043.109467537925,14031.13738357395,
	14019.29139802807,14007.571726591423,13995.978518360347,13984.511855904391,13973.171755537618,
	13961.95816778742,13950.870978050512,13939.91000742743,13929.0750137268,13918.365692627034,
	13907.781678986179,13897.322548287497,13886.987818209875,13876.776950310961,13866.689351811721,
	13856.72437747055,13846.881331534505,13837.159469758171,13827.558001476997,13818.076091725812,
	13808.71286339112,13799.467399388473,13790.338744853274,13781.325909338682,13772.427869010658,
	13763.643568831634,13754.97192472725,13746.41182572813,13737.962136080934,13729.6216973228,
	13721.389330314429,13713.263837226905,13705.244003478887,13697.32859962044,13689.516383159062,
	13681.806100328675,13674.196487795924,13666.686274305206,13659.274182257677,13651.958929228254,
	13644.739229414363,13637.613795021425,13630.581337581209,13623.640569206065,13616.790203778031,
	13610.028958074161,13603.355552829362,13596.768713736972,13590.26717238983,13583.849667161816,
	13577.5149440317,13571.261757352346,13565.08887056476,13558.995056860605,13552.979099793956,
	13547.039793844604,13541.175944934485,13535.38637089956,13529.66990191842,13524.025380900235,
	13518.451663833355,13512.947620098066,13507.512132735294,13502.144098699726,13496.842429062415,
	13491.606049191658,13486.43389890556,13481.324932594674,13476.278119322043,13471.292442896702,
	13466.366901927797,13461.500509853578,13456.692294955583,13451.941300349707,13447.246583963577,
	13442.607218496989,13438.022291365867,13433.490904635586,13429.012174939138,13424.585233384467,
	13420.20922545169,13415.883310876967,13411.606663540495,13407.378471320706,13403.197935967175,
	13399.064272953494,13394.976711326093,13390.934493549632,13386.936875344436,13382.983125523746,
	13379.072525822927,13375.204370729458,13371.377967307162,13367.592635019377,13363.847705551087,
	13360.142522627566,13356.476441834278,13352.84883043231,13349.259067178404,13345.70654213966,
	13342.190656511593,13338.710822435241,13335.26646281396,13331.857011133705,13328.481911280927,
	13325.140617362491,13321.832593528829,13318.557313795529,13315.31426186814,13312.102930968895,
	13308.922823663106,13305.773451689716,13302.654335792335,13299.565005553046,13296.504999227525,
	13293.473863582814,13290.471153737084,13287.496433001093,13284.5492727235,13281.629252136301,
	13278.73595820418,13275.868985475023,13273.027935934615,13270.21241886034,13267.422050682062,
	13264.656454840075,13261.915261649612,13259.19810816564,13256.504638049944,13253.834501442061,
	13251.187354830241,13248.562860927626,13245.960688547548,13243.380512483767,13240.822013391458,
	13238.28487767045,13235.768797351879,13233.273469985766,13230.798598531295,13228.343891249342,
	13225.909061596507,13223.493828121544,13221.097914365173,13218.72104875871,13216.362964528382,
	13214.023399598607,13211.702096499796,13209.398802275073,13207.11326839176,13204.84525065302,
	13202.59450911154,13200.36080798608,13198.14391557692,13195.943604187136,13193.759650042142,
	13191.591833212018,13189.439937536072,13187.303750548324,13185.183063404105,13183.077670809958,
	13180.987370952098,13178.911965429888,13176.85125918732,13174.805060448778,13172.773180654152,
	13170.755434395858,13168.75163935831,13166.76161625711,13164.785188780084,13162.822183529835,
	13160.872429968962,13158.93576035769,13157.012009711685,13155.101015739408,13153.20261879423,
	13151.31666182292,13149.442990316333,13147.581452260136,13145.731898088337,13143.894180634934,
	13142.068155091016,13140.25367895658,13138.450612000048,13136.658816214655,13134.878155775043,
	13133.108496997313,13131.349708299398,13129.601660161468,13127.864225086516,13126.137277563643,
	13124.420694029375,13122.714352839344,13121.018134219215,13119.331920240542,13117.655594783142,
	13115.989043503327,13114.332153800166,13112.684814784045,13111.046917245303,13109.418353624233,
	13107.799017980413,13106.188805963704,13104.587614786122,13102.995343192619,13101.411891433689,
	13099.837161240384,13098.271055794461,13096.713479705662,13095.164338983968,13093.62354101649,
	13092.09099454208,13090.566609627753,13089.050297645763,13087.54197124953,13086.041544352654,
	13084.54893210538,13083.064050875071,13081.586818222797,13080.117152883839,13078.654974747693,
	13077.200204837394,13075.752765290497,13074.312579339532,13072.879571294152,13071.453666521875,
	13070.03479143023,13068.622873449167,13067.21784101434,13065.819623548843,13064.428151448416,
	13063.043356063565,13061.665169683487,13060.29352552176,13058.928357700297,13057.569601233214,
	13056.21719201409,13054.871066799262,13053.53116319521,13052.197419643908,13050.869775409019,
	13049.548170563874,13048.232545974866,13046.922843292828,13045.619004936661,13044.320974083974,
	13043.028694656587,13041.742111308891,13040.461169417476,13039.185815068098,13037.915995044757,
	13036.651656819484,13035.392748539494,13034.139219018698,13032.891017725997,13031.6480947742,
	13030.410400911998,13029.177887511587,13027.950506562003,13026.728210655821,13025.510952982171,
	13024.298687317769,13023.091368015826,13021.88894999956,13020.691388751213,13019.498640305032,
	13018.310661237894,13017.127408661729,13015.9488402153,13014.774914055415,13013.605588850423,
	13012.440823770596,13011.280578482781,13010.124813141341,13008.973488382006,13007.826565313024,
	13006.684005510468,13005.54577100898,13004.411824296247,13003.282128306268,13002.156646412664,
	13001.035342421706,12999.918180566643,12998.80512550095,12997.696142292643,12996.591196419153,
	12995.490253757836,12994.3932805849,12993.300243566291,12992.21110975342,12991.1258465782,
	12990.044421844466,12988.96680372845,12987.892960767436,12986.822861857685,12985.75647624956,
	12984.693773541218,12983.634723675083,12982.57929693133,12981.527463925104,12980.479195598906,
	12979.434463223315,12978.393238385575,12977.355492990608,12976.321199254488,12975.290329699406,
	12974.262857151723,12973.23875473491,12972.217995868677,12971.200554262366,12970.186403911726,
	12969.175519095488,12968.167874371302,12967.163444571768,12966.16220480084,12965.164130430843,
	12964.169197097139,12963.177380695977,12962.188657381424,12961.203003560355,12960.220395890674,
	12959.240811276077,12958.264226865871,12957.290620048225,12956.31996844916,12955.352249929028,
	12954.38744257913,12953.42552471987,12952.466474894947,12951.510271872163,12950.556894637437,
	12949.606322394104,12948.658534558008,12947.713510757649,12946.771230828354,12945.831674811461,
	12944.894822951686,12943.960655693358,12943.029153679763,12942.100297750821,12941.174068932947,
	12940.25044844959,12939.329417709914,12938.410958309081,12937.495052025015,12936.581680817906,
	12935.670826825039,12934.76247236203,12933.856599916644,12932.953192150593,12932.052231896216,
	12931.153702151643,12930.257586083148,12929.363867019816,12928.472528451653,12927.583554031082,
	12926.696927566356,12925.81263302195,12924.930654517966,12924.05097632288,12923.173582863941,
	12922.29845870933,12921.425588576083,12920.5549573272,12919.686549968124,12918.820351646496,
	12917.956347650035,12917.094523404501,12916.234864472424,12915.377356551637,12914.521985473608,
	12913.668737199556,12912.817597824844,12911.96855357017,12911.121590787232,12910.276695949162,
	12909.433855656658,12908.593056632033,12907.754285719886,12906.917529884306,12906.082776208645,
	12905.250011893158,12904.419224254743,12903.590400723637,12902.763528844807,12901.938596275242,
	12901.11559078208,12900.294500243046,12899.475312642528,12898.658016073538,12897.842598734665,
	12897.029048928647,12896.217355062361,12895.40750564475,12894.599489286356,12893.793294697143,
	12892.988910686934,12892.186326162537,12891.385530128387,12890.586511684836,12889.78926002561,
	12888.993764439889,12888.200014307684,12887.407999101732,12886.61770838556,12885.829131811803,
	12885.04225912196,12884.257080144325,12883.473584795516,12882.691763077311,12881.911605076244,
	12881.133100962594,12880.356240990117,12879.58101549381,12878.8074148932,12878.035429683121,
	12877.265050442213,12876.496267826202,12875.729072568538,12874.963455480294,12874.199407449856,
	12873.436919437567,12872.675982482397,12871.91658769558,12871.158726260688,12870.402389434756,
	12869.647568546607,12868.89425499458,12868.142440249123,12867.392115847588,12866.643273399095,
	12865.895904577925,12865.150001126543,12864.405554855595,12863.662557638547,12862.921001417828,
	12862.180878196892,12861.442180045005,12860.704899095308,12859.969027541507,12859.234557640726,
	12858.501481712161,12857.769792132905,12857.039481343969,12856.31054184382,12855.582966188538,
	12854.856746994961,12854.131876937236,12853.408348745184,12852.686155208203,12851.965289167836,
	12851.245743524963,12850.527511232824,12849.810585299767,12849.094958788808,12848.380624815192,
	12847.667576548398,12846.955807207984,12846.245310068422,12845.536078452937,12844.828105736766,
	12844.121385344906,12843.415910752257,12842.71167548306,12842.008673111684,12841.306897258786,
	12840.606341595396,12839.906999837362,12839.208865749222,12838.511933141415,12837.816195872538,
	12837.121647843609,12836.428283002553,12835.73609534269,12835.045078901261,12834.35522775902,
	12833.666536040999,12832.978997914559,12832.292607591547,12831.607359324218,12830.923247407953,
	12830.240266179364,12829.558410015825,12828.877673336749,12828.198050600513,12827.519536306927,
	12826.842124995603,12826.165811242825,12825.490589666682,12824.81645492326,12824.143401706682,
	12823.471424748273,12822.800518818183,12822.130678723,12821.461899306347,12820.794175448102,
	12820.127502064697,12819.46187410929,12818.79728656877,12818.13373446699,12817.471212861647,
	12816.809716845179,12816.149241545449,12815.489782122664,12814.831333771008,12814.173891719754,
	12813.517451229223,12812.862007594062,12812.207556140405,12811.554092226934,12810.901611244552,
	12810.250108615848,12809.599579793985,12808.950020263923,12808.301425541895,12807.653791174325,
	12807.00711273664,12806.361385836588,12805.716606109652,12805.072769222377,12804.429870870234,
	12803.78790677734,12803.14687269612,12802.506764407119,12801.867577722911,12801.22930847914,
	12800.59195254152,12799.955505803891,12799.319964186929,12798.685323637155,12798.051580129408,
	12797.418729664427,12796.786768270904,12796.15569199986,12795.525496933293,12794.89617917545,
	12794.267734857223,12793.640160134364,12793.013451188679,12792.387604225878,12791.762615476828,
	12791.138481196775,12790.515197664981,12789.892761185363,12789.271168085097,12788.65041471565,
	12788.030497450985,12787.41141268841,12786.793156850143,12786.17572638001,12785.559117743675,
	12784.943327431178,12784.328351951548,12783.714187841366,12783.100831654438,12782.488279969439,
	12781.876529383178,12781.265576517799,12780.655418013701,12780.046050535288,12779.437470765271,
	12778.82967540657,12778.222661187317,12777.616424851387,12777.010963163897,12776.406272911658,
	12775.802350899694,12775.199193954206,12774.596798921368,12773.995162663105,12773.39428206582,
	12772.794154031464,12772.194775482738,12771.59614335987,12770.998254623302,12770.401106251082,
	12769.804695241124,12769.209018605765,12768.614073380713,12768.019856615578,12767.426365379493,
	12766.833596759529,12766.241547860278,12765.650215802709,12765.059597725525,12764.469690785416,
	12763.88049215613,12763.291999026878,12762.704208604631,12762.11711811254,12761.530724791592,
	12760.945025898329,12760.360018705313,12759.77570050034,12759.192068588367,12758.60912029102,
	12758.02685294468,12757.445263902257,12756.864350529313,12756.284110210305,12755.704540343217,
	12755.125638343381,12754.547401638103,12753.969827669942,12753.392913899324,12752.816657798254,
	12752.241056856425,12751.666108575702,12751.09181047143,12750.518160074402,12749.945154932091,
	12749.372792602744,12748.801070659078,12748.229986689676,12747.65953829563,12747.089723090423,
	12746.520538704099,12745.951982776915,12745.384052964691,12744.816746935585,12744.250062372837,
	12743.683996968044,12743.11854843316,12742.55371448493,12741.989492858896,12741.42588130079,
	12740.862877569763,12740.300479433163,12739.738684681452,12739.177491107694,12738.616896520485,
	12738.056898739984,12737.497495598749,12736.938684941706,12736.380464625314,12735.822832518174,
	12735.26578649937,12734.709324460742,12734.153444308608,12733.598143954274,12733.043421325496,
	12732.489274359874,12731.935701005685,12731.382699223332,12730.830266984733,12730.27840227058,
	12729.727103074327,12729.17636740084,12728.626193264887,12728.07657869045,12727.527521714053,
	12726.979020383335,12726.431072754658,12725.883676896074,12725.33683088459,12724.790532810612,
	12724.24478076788,12723.699572870124,12723.154907232953,12722.610781985977,12722.06719526686,
	12721.524145224328,12720.981630018165,12720.439647812549,12719.898196787679,12719.357275130278,
	12718.816881035766,12718.277012712679,12717.73766837437,12717.198846245283,12716.660544561406,
	12716.12276156553,12715.585495508849,12715.048744652786,12714.512507269817,12713.97678163696,
	12713.441566046164,12712.906858790206,12712.37265817804,12711.838962522375,12711.305770149556,
	12710.773079388306,12710.240888580829,12709.709196076245,12709.178000231894,12708.64729941221,
	12708.117091993066,12707.58737635693,12707.058150893794,12706.529414001596,12706.001164089343,
	12705.473399570581,12704.946118867612,12704.419320412982,12703.893002644327,12703.367164009509,
	12702.841802960247,12702.316917962684,12701.792507483417,12701.268570002578,12700.745104002526,
	12700.222107978465,12699.699580428256,12699.17751986126,12698.655924790977,12698.134793742372,
	12697.6141252413,12697.093917827526,12696.574170044574,12696.054880442647,12695.536047582664,
	12695.01767002664,12694.499746350704,12693.982275130827,12693.465254955123,12692.948684417675,
	12692.432562117798,12691.916886662179,12691.401656664153,12690.886870745706,12690.372527533344,
	12689.85862566022,12689.34516376636,12688.832140501769,12688.319554514857,12687.807404469513,
	12687.295689030707,12686.78440687129,12686.273556670807,12685.763137113216,12685.253146891191,
	12684.743584703732,12684.234449252519,12683.72573924904,12683.217453411475,12682.709590458195,
	12682.202149121293,12681.695128133266,12681.188526234762,12680.68234217333,12680.176574700985,
	12679.671222574774,12679.166284560928,12678.661759426332,12678.157645947438,12677.65394290588,
	12677.150649090345,12676.647763291228,12676.145284306693,12675.64321094026,12675.141542002211,
	12674.640276308417,12674.13941267761,12673.63894993408,12673.13888691267,12672.639222447679,
	12672.139955380793,12671.64108456082,12671.142608838873,12670.644527072312,12670.146838125836,
	12669.649540865199,12669.152634166796,12668.656116907076,12668.15998796945,12667.664246242985,
	12667.168890622703,12666.673920005318,12666.179333294873,12665.685129400463,12665.191307235586,
	12664.697865718761,12664.204803773278,12663.712120327002,12663.21981431133,12662.727884668133,
	12662.23633033426,12661.745150263301,12661.254343401588,12660.76390870706,12660.273845142905,
	12659.784151673333,12659.294827268142,12658.805870904633,12658.31728155929,12657.82905821873,
	12657.341199868748,12656.853705504853,12656.366574123367,12655.879804725811,12655.393396318143,
	12654.907347912254,12654.421658520268,12653.936327163512,12653.451352864015,12652.96673465171,
	12652.482471554878,12651.998562613864,12651.515006866128,12651.031803355354,12650.548951132985,
	12650.066449249625,12649.584296762176,12649.102492733296,12648.621036224808,12648.13992630629,
	12647.659162054022,12647.178742540555,12646.698666849657,12646.218934065419,12645.739543275218,
	12645.260493572034,12644.781784053217,12644.303413818418,12643.825381972456,12643.347687621726,
	12642.87032987893,12642.393307860033,12641.91662068268,12641.44026747061,12640.964247349742,
	12640.488559452082,12640.013202909226,12639.538176858689,12639.063480444778,12638.589112809737,
	12638.11507310133,12637.641360472995,12637.167974078835,12636.694913080373,12636.222176635962,
	12635.749763915215,12635.277674085177,12634.805906320536,12634.334459795693,12633.863333691213,
	12633.392527189515,12632.922039477471,12632.451869746112,12631.98201718523,12631.512480995505,
	12631.043260372011,12630.574354520564,12630.105762648429,12629.637483961853,12629.1695176754,
	12628.701863003202,12628.234519168898,12627.767485389673,12627.30076089235,12626.834344907684,
	12626.368236665012,12625.902435399934,12625.436940349606,12624.971750755585,12624.506865862004,
	12624.042284916808,12623.578007168637,12623.114031869516,12622.65035827821,12622.186985653094,
	12621.723913254436,12621.261140348903,12620.798666203576,12620.336490088372,12619.874611280266,
	12619.413029052113,12618.951742685666,12618.49075146215,12618.03005466825,12617.569651588767,
	12617.109541517968,12616.64972374821,12616.190197574102,12615.730962296157,12615.272017218636,
	12614.813361642759,12614.354994876849,12613.89691623003,12613.439125017743,12612.981620553524,
	12612.52440215491,12612.067469143889,12611.61082084451,12611.15445658103,12610.69837568114,
	12610.242577480487,12609.787061309053,12609.331826503403,12608.87687240467,12608.422198353457,
	12607.967803691898,12607.513687768185,12607.059849932328,12606.606289535559,12606.153005931887,
	12605.699998474198,12605.247266526721,12604.794809449093,12604.342626604408,12603.890717357559,
	12603.439081081184,12602.987717144733,12602.536624918488,12602.085803783182,12601.635253115011,
	12601.184972293704,12600.734960702885,12600.285217727731,12599.835742755873,12599.386535176716,
	12598.937594383317,12598.488919770274,12598.0405107347,12597.59236667203,12597.144486987128,
	12596.696871082127,12596.249518362794,12595.802428237022,12595.355600115963,12594.90903340951,
	12594.46272753265,12594.016681905316,12593.57089594306,12593.125369066669,12592.680100700107,
	12592.235090270256,12591.790337201384,12591.345840924263,12590.901600868825,12590.457616474358,
	12590.013887171268,12589.570412397987,12589.127191594467,12588.68422420475,12588.241509669908,
	12587.799047439024,12587.35683695597,12586.914877671637,12586.473169041261,12586.03171051642,
	12585.590501553477,12585.149541610814,12584.7088301469,12584.26836662453,12583.82815050735,
	12583.388181260698,12582.948458352894,12582.50898125236,12582.069749431917,12581.630762361843,
	12581.192019521814,12580.753520387254,12580.315264436402,12579.87725114849,12579.439480010038,
	12579.001950502252,12578.564662112944,12578.127614332645,12577.690806645543,12577.254238547346,
	12576.817909532896,12576.381819093725,12575.945966728103,12575.510351937444,12575.07497422161,
	12574.639833080928,12574.204928021725,12573.770258549564,12573.335824170814,12572.901624396263,
	12572.467658735173,12572.03392670476,12571.600427815023,12571.167161583444,12570.734127530342,
	12570.301325173281,12569.86875403188,12569.436413632307,12569.004303498747,12568.572423152455,
	12568.14077212755,12567.709349951328,12567.27815615417,12566.847190270451,12566.416451832116,
	12565.985940378436,12565.555655442437,12565.125596569138,12564.695763293897,12564.266155159474,
	12563.836771714969,12563.407612501356,12562.978677065654,12562.54996495732,12562.121475725746,
	12561.693208925255,12561.265164105447,12560.837340821026,12560.409738630316,12559.982357090617,
	12559.555195759098,12559.12825420087,12558.701531974146,12558.275028641154,12557.848743771705,
	12557.422676929657,12556.996827683084,12556.571195599443,12556.14578025357,12555.72058121639,
	12555.29559805947,12554.87083035922,12554.446277693824,12554.021939641161,12553.597815777806,
	12553.173905686697,12552.750208950265,12552.32672515089,12551.903453873516,12551.480394705799,
	12551.05754723565,12550.634911049321,12550.212485741224,12549.790270900794,12549.368266119176,
	12548.946470994753,12548.524885122233,12548.103508098124,12547.682339519775,12547.261378986543,
	12546.840626103882,12546.420080470898,12545.999741690224,12545.579609368548,12545.159683113792,
	12544.739962530031,12544.32044722782,12543.901136815763,12543.482030907508,12543.063129115038,
	12542.64443105053,12542.225936332286,12541.807644572671,12541.389555393718,12540.971668408958,
	12540.553983243157,12540.136499514614,12539.719216847361,12539.302134864523,12538.885253191695,
	12538.468571453952,12538.052089279561,12537.63580629546,12537.219722134007,12536.803836421917,
	12536.388148795517,12535.972658886807,12535.5573663297,12535.142270756101,12534.727371810346,
	12534.312669124285,12533.898162339094,12533.483851093186,12533.069735031657,12532.655813792653,
	12532.24208702192,12531.828554364136,12531.415215464722,12531.0020699698,12530.589117527517,
	12530.176357786613,12529.763790399553,12529.351415016496,12528.93923128872,12528.527238870085,
	12528.115437415785,12527.703826580107,12527.292406021585,12526.881175397137,12526.470134365212,
	12526.0592825864,12525.648619718713,12525.23814543102,12524.827859378125,12524.417761229623,
	12524.007850646603,12523.598127299383,12523.188590852942,12522.779240975602,12522.3700773363,
	12521.961099604658,12521.552307454074,12521.143700555449,12520.735278579978,12520.327041206332,
	12519.91898810682,12519.511118959268,12519.103433437058,12518.695931222439,12518.28861199324,
	12517.88147542883,12517.474521211212,12517.06774902391,12516.661158547375,12516.254749466687,
	12515.848521466613,12515.44247423109,12515.036607452117,12514.630920812491,12514.225414002784,
	12513.82008671361,12513.414938634281,12513.009969455841,12512.60517887283,12512.200566573805,
	12511.796132260924,12511.391875623194,12510.98779635856,12510.58389416494,12510.180168738625,
	12509.776619778633
	}}
};
