// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIGNIN_PROFILE_CREATION_CUSTOMIZE_THEMES_HANDLER_H_
#define CHROME_BROWSER_UI_WEBUI_SIGNIN_PROFILE_CREATION_CUSTOMIZE_THEMES_HANDLER_H_

#include "base/optional.h"
#include "mojo/public/cpp/bindings/pending_receiver.h"
#include "mojo/public/cpp/bindings/pending_remote.h"
#include "mojo/public/cpp/bindings/receiver.h"
#include "mojo/public/cpp/bindings/remote.h"
#include "third_party/skia/include/core/SkColor.h"
#include "ui/webui/resources/cr_components/customize_themes/customize_themes.mojom.h"

class ProfileCreationCustomizeThemesHandler
    : public customize_themes::mojom::CustomizeThemesHandler {
 public:
  explicit ProfileCreationCustomizeThemesHandler(
      mojo::PendingRemote<customize_themes::mojom::CustomizeThemesClient>
          pending_client,
      mojo::PendingReceiver<customize_themes::mojom::CustomizeThemesHandler>
          pending_handler);
  ~ProfileCreationCustomizeThemesHandler() override;

  // customize_themes::mojom::CustomizeThemesHandler:
  void ApplyAutogeneratedTheme(const SkColor& frame_color) override;
  void ApplyDefaultTheme() override;
  void ApplyChromeTheme(int32_t id) override;
  void InitializeTheme() override;
  void GetChromeThemes(GetChromeThemesCallback callback) override;
  void ConfirmThemeChanges() override;
  void RevertThemeChanges() override;

 private:
  mojo::Remote<customize_themes::mojom::CustomizeThemesClient> remote_client_;
  mojo::Receiver<customize_themes::mojom::CustomizeThemesHandler> receiver_;
};

#endif  // CHROME_BROWSER_UI_WEBUI_SIGNIN_PROFILE_CREATION_CUSTOMIZE_THEMES_HANDLER_H_
